/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import phex.common.IntObj;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.download.RemoteFile;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.event.SecurityRulesChangeListener;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.tabs.search.SearchResultElement;
import phex.gui.tabs.search.SearchResultElementComparator;
import phex.query.QueryManager;
import phex.query.Search;
import phex.rules.Rule;
import phex.rules.SearchFilterRules;
import phex.security.IPAccessRule;
import phex.security.PhexSecurityManager;
import phex.security.SecurityRule;

public class SearchResultsDataModel
implements SearchDataListener,
SecurityRulesChangeListener,
ISearchDataModel {
    private static final HashMap searchToDataModelMap = new HashMap();
    private ArrayList allRemoteFiles;
    private HashSet allSearchResultSHA1Set;
    private int allSearchResultCount;
    private ArrayList displayedSearchResults;
    private HashMap displayedSearchResultSHA1Map;
    private SearchTreeTableModel visualizationModel;
    private SearchResultElementComparator comparator;
    private Search search;
    private Rule quickFilterRule;
    private Set searchFilterRuleSet;
    private IntObj searchElementCountObj;
    private IntObj filteredElementCountObj;

    private SearchResultsDataModel(Search search) {
        this.search = search;
        this.allRemoteFiles = new ArrayList();
        this.allSearchResultSHA1Set = new HashSet();
        this.allSearchResultCount = 0;
        this.displayedSearchResults = new ArrayList();
        this.displayedSearchResultSHA1Map = new HashMap();
        this.searchElementCountObj = new IntObj();
        this.filteredElementCountObj = new IntObj();
        this.comparator = new SearchResultElementComparator();
        this.searchFilterRuleSet = new HashSet();
        SearchFilterRules filterRules = QueryManager.getInstance().getSearchFilterRules();
        this.searchFilterRuleSet.addAll(filterRules.getPermanentList());
        search.addSearchChangeListener(this);
        PhexSecurityManager.getInstance().addSecurityRuleChangeListener(this);
    }

    public int getSearchElementCount() {
        return this.displayedSearchResults.size();
    }

    public int getAllSearchResultCount() {
        return this.allSearchResultCount;
    }

    public IntObj getSearchElementCountObj() {
        if (this.searchElementCountObj.intValue() != this.displayedSearchResults.size()) {
            this.searchElementCountObj.setValue(this.displayedSearchResults.size());
        }
        return this.searchElementCountObj;
    }

    public IntObj getFilteredElementCountObj() {
        int count = this.getFilteredElementCount();
        if (this.filteredElementCountObj.intValue() != count) {
            this.filteredElementCountObj.setValue(count);
        }
        return this.filteredElementCountObj;
    }

    public int getFilteredElementCount() {
        return this.allSearchResultCount - this.displayedSearchResults.size();
    }

    public SearchResultElement getSearchElementAt(int index) {
        if (index < 0 || index >= this.displayedSearchResults.size()) {
            return null;
        }
        return (SearchResultElement)this.displayedSearchResults.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSearchResults(RemoteFile[] newSearchResults) {
        this.processFilterRules(newSearchResults);
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                for (int i = 0; i < newSearchResults.length; ++i) {
                    RemoteFile remoteFile = newSearchResults[i];
                    if (remoteFile.isFilteredRemoved()) continue;
                    if (!remoteFile.isFilteredHidden()) {
                        this.addSearchResultForDisplay(remoteFile);
                    }
                    this.addSearchResultToAll(remoteFile);
                }
            }
        }
    }

    private void addSearchResultToAll(RemoteFile remoteFile) {
        this.allRemoteFiles.add(remoteFile);
        String sha1 = remoteFile.getSHA1();
        boolean found = false;
        if (sha1 != null) {
            found = this.allSearchResultSHA1Set.contains(sha1);
        }
        if (!found) {
            ++this.allSearchResultCount;
            if (sha1 != null && sha1.length() > 0) {
                this.allSearchResultSHA1Set.add(sha1);
            }
        }
    }

    private void addSearchResultForDisplay(RemoteFile remoteFile) {
        SearchResultElement resultElement = null;
        String sha1 = remoteFile.getSHA1();
        if (sha1 != null) {
            resultElement = (SearchResultElement)this.displayedSearchResultSHA1Map.get(sha1);
        }
        if (resultElement != null) {
            resultElement.addRemoteFile(remoteFile);
            this.fireSearchResultAdded(remoteFile, resultElement);
        } else {
            resultElement = new SearchResultElement(remoteFile);
            int index = Collections.binarySearch(this.displayedSearchResults, resultElement, this.comparator);
            if (index <= 0) {
                if (sha1 != null && sha1.length() > 0) {
                    this.displayedSearchResultSHA1Map.put(sha1, resultElement);
                }
                this.displayedSearchResults.add(-index - 1, resultElement);
                this.fireNewSearchResultAdded(resultElement, -index - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSortBy(int sortField, boolean isSortedAscending) {
        ArrayList arrayList = this.displayedSearchResults;
        synchronized (arrayList) {
            this.comparator.setSortField(sortField, isSortedAscending);
            Collections.sort(this.displayedSearchResults, this.comparator);
            this.fireAllSearchResultsChanged();
        }
    }

    public void setVisualizationModel(SearchTreeTableModel model) {
        this.visualizationModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchResults() {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.allSearchResultCount = 0;
                this.displayedSearchResults.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.fireAllSearchResultsChanged();
                this.search.fireSearchChanged();
            }
        }
    }

    public Search getSearch() {
        return this.search;
    }

    public Rule getQuickFilterRule() {
        return this.quickFilterRule;
    }

    public void setQuickFilterRule(Rule rule) {
        this.quickFilterRule = rule;
        this.updateFilteredQueryList();
    }

    public boolean isRuleActive(Rule rule) {
        return this.searchFilterRuleSet.contains(rule);
    }

    public void activateRule(Rule rule) {
        this.searchFilterRuleSet.add(rule);
        this.updateFilteredQueryList();
    }

    public void deactivateRule(Rule rule) {
        this.searchFilterRuleSet.remove(rule);
        this.updateFilteredQueryList();
    }

    private void processFilterRules(RemoteFile[] remoteFiles) {
        if (this.searchFilterRuleSet == null) {
            return;
        }
        if (this.quickFilterRule != null) {
            this.quickFilterRule.process(this.search, remoteFiles);
        }
        Iterator iterator = this.searchFilterRuleSet.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            rule.process(this.search, remoteFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilteredQueryList() {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                RemoteFile[] remoteFiles = new RemoteFile[this.allRemoteFiles.size()];
                this.allRemoteFiles.toArray(remoteFiles);
                this.allSearchResultCount = 0;
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.displayedSearchResults.clear();
                this.fireAllSearchResultsChanged();
                for (int i = 0; i < remoteFiles.length; ++i) {
                    remoteFiles[i].clearFilterFlags();
                }
                this.addSearchResults(remoteFiles);
                this.search.fireSearchChanged();
            }
        }
    }

    public void searchDataChanged(SearchDataEvent event) {
        if (event.getType() == 1) {
            RemoteFile[] newSearchResults = event.getSearchData();
            this.addSearchResults(newSearchResults);
        }
    }

    public String toString() {
        return super.toString() + " - " + this.search;
    }

    public void securityRuleChanged(int position) {
    }

    public void securityRuleAdded(SecurityRule rule, int position) {
        if (rule.isDisabled()) {
            return;
        }
        if (rule instanceof IPAccessRule) {
            this.updateSecurityFilteredQueryList((IPAccessRule)rule);
        }
    }

    public void securityRuleRemoved(int position) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSecurityFilteredQueryList(IPAccessRule rule) {
        ArrayList arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                ArrayList remoteFilesList = new ArrayList(this.allRemoteFiles);
                this.allSearchResultCount = 0;
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.displayedSearchResults.clear();
                this.fireAllSearchResultsChanged();
                ListIterator iterator = remoteFilesList.listIterator();
                while (iterator.hasNext()) {
                    RemoteFile remoteFile = (RemoteFile)iterator.next();
                    DestAddress address = remoteFile.getHostAddress();
                    IpAddress ipAddress = address.getIpAddress();
                    if (ipAddress != null && !rule.isHostIPAllowed(ipAddress.getHostIP())) {
                        iterator.remove();
                        continue;
                    }
                    remoteFile.clearFilterFlags();
                }
                RemoteFile[] remoteFiles = new RemoteFile[remoteFilesList.size()];
                remoteFilesList.toArray(remoteFiles);
                this.addSearchResults(remoteFiles);
                this.search.fireSearchChanged();
            }
        }
    }

    private void fireAllSearchResultsChanged() {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] path = new Object[]{this.visualizationModel.getRoot()};
        this.visualizationModel.fireTreeStructureChanged(this, path, null, null);
    }

    private void fireNewSearchResultAdded(SearchResultElement resultElement, int index) {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] path = new Object[]{this.visualizationModel.getRoot()};
        int[] indices = new int[]{index};
        Object[] changes = new Object[]{resultElement};
        if (this.displayedSearchResults.size() == 1) {
            this.visualizationModel.fireTreeStructureChanged(this, path, indices, changes);
        } else {
            this.visualizationModel.fireTreeNodesInserted(this, path, indices, changes);
        }
    }

    private void fireSearchResultAdded(RemoteFile remoteFile, SearchResultElement resultElement) {
        if (this.visualizationModel == null) {
            return;
        }
        Object[] path = new Object[]{this.visualizationModel.getRoot(), resultElement};
        Object[] changes = new Object[]{remoteFile};
        this.visualizationModel.fireTreeNodesInserted(this, path, null, changes);
    }

    public static SearchResultsDataModel registerNewSearch(Search search) {
        SearchResultsDataModel dataModel = new SearchResultsDataModel(search);
        searchToDataModelMap.put(search, dataModel);
        return dataModel;
    }

    public static SearchResultsDataModel lookupResultDataModel(Search search) {
        return (SearchResultsDataModel)searchToDataModelMap.get(search);
    }
}

