/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.util.ArrayList;
import phex.common.IntObj;
import phex.common.ShortObj;
import phex.download.RemoteFile;
import phex.utils.Localizer;

public class SearchResultElement {
    private RemoteFile remoteFile;
    private ArrayList remoteFileList;
    private ShortObj bestScore;
    private ShortObj bestRating;
    private IntObj bestSpeed;

    public SearchResultElement(RemoteFile aRemoteFile) {
        this.remoteFile = aRemoteFile;
        this.bestScore = new ShortObj(this.remoteFile.getScore());
        this.bestRating = new ShortObj(this.remoteFile.getQueryHitHost().getHostRating());
        this.bestSpeed = new IntObj(this.remoteFile.getSpeed());
        this.remoteFileList = new ArrayList(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteFile(RemoteFile aRemoteFile) {
        ArrayList arrayList = this.remoteFileList;
        synchronized (arrayList) {
            if (this.remoteFileList.size() == 0) {
                this.remoteFileList.add(this.remoteFile);
            }
            this.remoteFileList.add(aRemoteFile);
            if (aRemoteFile.getScore() > this.bestScore.value) {
                this.bestScore.value = aRemoteFile.getScore();
            }
            if (aRemoteFile.getQueryHitHost().getHostRating() > this.bestRating.value) {
                this.bestRating.value = aRemoteFile.getQueryHitHost().getHostRating();
            }
            if (aRemoteFile.getSpeed() > this.bestSpeed.value) {
                this.bestSpeed.value = aRemoteFile.getSpeed();
            }
        }
    }

    public int getRemoteFileListCount() {
        return this.remoteFileList.size();
    }

    public RemoteFile getRemoteFileAt(int index) {
        if (index < 0 || index >= this.remoteFileList.size()) {
            return null;
        }
        return (RemoteFile)this.remoteFileList.get(index);
    }

    public RemoteFile getSingleRemoteFile() {
        return this.remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile[] getRemoteFiles() {
        if (this.remoteFileList.size() == 0) {
            return new RemoteFile[]{this.remoteFile};
        }
        ArrayList arrayList = this.remoteFileList;
        synchronized (arrayList) {
            RemoteFile[] remoteFiles = new RemoteFile[this.remoteFileList.size()];
            this.remoteFileList.toArray(remoteFiles);
            return remoteFiles;
        }
    }

    public Object getValue(int modelIndex) {
        switch (modelIndex) {
            case 3: {
                return this.bestScore;
            }
            case 4: {
                return this.bestRating;
            }
            case 5: {
                return this.bestSpeed;
            }
            case 6: {
                int listSize = this.remoteFileList.size();
                if (this.remoteFileList.size() > 0) {
                    return Localizer.getFormatedString("NumberOfHosts", new Object[]{new Integer(listSize)});
                }
                return this.remoteFile.getQueryHitHost().getHostAddress();
            }
            case 7: {
                int listSize = this.remoteFileList.size();
                if (this.remoteFileList.size() > 0) {
                    return Localizer.getFormatedString("NumberOfHosts", new Object[]{new Integer(listSize)});
                }
                return this.remoteFile.getQueryHitHost().getVendor();
            }
        }
        return "";
    }
}

