/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import org.apache.commons.collections.comparators.ComparableComparator;
import phex.common.IntObj;
import phex.event.SearchListChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.renderer.ProgressCellRenderer;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.query.BrowseHostResults;
import phex.query.KeywordSearch;
import phex.query.QueryManager;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.query.WhatsNewSearch;
import phex.utils.Localizer;

public class SearchListTableModel
extends FWSortableTableModel
implements SearchListChangeListener {
    public static final int SEARCH_TERM_COLUMN_ID = 1001;
    public static final int RESULT_COUNT_COLUMN_ID = 1002;
    public static final int FILTERED_COUNT_COLUMN_ID = 1003;
    public static final int PROGRESS_COLUMN_ID = 1004;
    public static final int STATUS_COLUMN_ID = 1005;
    public static final int SEARCH_TERM_MODEL_INDEX = 0;
    public static final int RESULT_COUNT_MODEL_INDEX = 1;
    public static final int FILTERED_COUNT_MODEL_INDEX = 2;
    public static final int PROGRESS_MODEL_INDEX = 3;
    public static final int STATUS_MODEL_INDEX = 4;
    private static String[] tableColumns = new String[]{Localizer.getString("SearchTerm"), Localizer.getString("Results"), Localizer.getString("Filtered"), Localizer.getString("Progress"), Localizer.getString("Status")};
    private static Class[] tableClasses = new Class[]{String.class, IntObj.class, IntObj.class, ProgressCellRenderer.class, String.class};
    private SearchContainer searchContainer;
    private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

    public SearchListTableModel() {
        super(tableColumns, tableClasses);
        this.searchContainer = QueryManager.getInstance().getSearchContainer();
        this.searchContainer.addSearchListChangeListener(this);
    }

    public int getRowCount() {
        return this.searchContainer.getSearchCount();
    }

    public Object getValueAt(int row, int col) {
        Search search = this.searchContainer.getSearchAt(row);
        if (search == null) {
            return "";
        }
        switch (col) {
            case 0: {
                if (search instanceof KeywordSearch) {
                    return ((KeywordSearch)search).getSearchString();
                }
                if (search instanceof WhatsNewSearch) {
                    return Localizer.getString("SearchTab_WhatsNewSearch");
                }
                if (search instanceof BrowseHostResults) {
                    return Localizer.getFormatedString("SearchTab_BrowsingHost", new Object[]{((BrowseHostResults)search).getDestAddress().getFullHostName()});
                }
                throw new RuntimeException("Unknwon search type");
            }
            case 1: {
                SearchResultsDataModel dataModel = SearchResultsDataModel.lookupResultDataModel(search);
                return dataModel.getSearchElementCountObj();
            }
            case 2: {
                SearchResultsDataModel dataModel = SearchResultsDataModel.lookupResultDataModel(search);
                return dataModel.getFilteredElementCountObj();
            }
            case 3: {
                return search.getProgressObj();
            }
            case 4: {
                if (search.isSearching()) {
                    return Localizer.getString("Searching");
                }
                return Localizer.getString("Search_Stopped");
            }
        }
        return "";
    }

    public Object getComparableValueAt(int row, int column) {
        return this.getValueAt(row, column);
    }

    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 3: {
                return ComparableComparator.getInstance();
            }
        }
        return null;
    }

    public int mapColumnIDToModelIndex(int columnId) {
        switch (columnId) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int columnID) {
        return columnID != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] columnIds = new int[]{1001, 1002, 1003, 1004, 1005};
        return columnIds;
    }

    public void searchChanged(int position) {
        this.lazyEventQueue.addTableModelEvent(new TableModelEvent(this, position, position, -1, 0));
    }

    public void searchAdded(Search search, int position) {
        this.fireTableChanged(new TableModelEvent(this, position, position, -1, 1));
    }

    public void searchRemoved(Search search, int position) {
        this.fireTableChanged(new TableModelEvent(this, position, position, -1, -1));
    }
}

