/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import phex.event.SearchListChangeListener;
import phex.gui.common.FWButtonBar;
import phex.gui.tabs.search.SearchButton;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.query.QueryManager;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.utils.NLogger;

public class SearchButtonBar
extends FWButtonBar
implements SearchListChangeListener {
    private Timer updateDisplayTimer;
    private SearchTab searchTab;
    private SearchResultsDataModel displayedDataModel;
    private SearchContainer searchContainer;
    private ButtonGroup searchButtonGroup;
    private Object accessLock = new Object();
    private AbstractButton notSelectedButton;
    private HashMap searchButtonMap;
    private ButtonHandler buttonHandler;
    static /* synthetic */ Class class$phex$gui$tabs$search$cp$SearchInfoBox;

    public SearchButtonBar(SearchTab searchTab) {
        this.searchTab = searchTab;
        this.searchButtonGroup = new ButtonGroup();
        this.notSelectedButton = new JToggleButton();
        this.searchButtonGroup.add(this.notSelectedButton);
        this.searchButtonMap = new HashMap();
        this.buttonHandler = new ButtonHandler();
        this.searchContainer = QueryManager.getInstance().getSearchContainer();
        int count = this.searchContainer.getSearchCount();
        for (int i = 0; i < count; ++i) {
            Search search = this.searchContainer.getSearchAt(i);
            if (search == null) continue;
            this.searchAdded(search, -1);
        }
        this.addMouseListener(new MouseListener());
    }

    public void addNotify() {
        super.addNotify();
        this.searchContainer.addSearchListChangeListener(this);
        if (this.updateDisplayTimer == null) {
            this.updateDisplayTimer = new Timer(2000, new UpdateButtonsTimerAction());
        }
        this.updateDisplayTimer.start();
    }

    public void removeNotify() {
        super.removeNotify();
        this.searchContainer.removeSearchListChangeListener(this);
        if (this.updateDisplayTimer != null) {
            this.updateDisplayTimer.stop();
            this.updateDisplayTimer = null;
        }
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (this.displayedDataModel != searchResultsDataModel) {
            this.displayedDataModel = searchResultsDataModel;
            if (searchResultsDataModel != null) {
                Search search = searchResultsDataModel.getSearch();
                SearchButton btn = (SearchButton)this.searchButtonMap.get(search);
                if (btn != null) {
                    btn.setSelected(true);
                }
            } else {
                this.notSelectedButton.setSelected(true);
            }
        }
    }

    public void searchChanged(int position) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchAdded(Search search, int position) {
        SearchButton btn = new SearchButton(search);
        btn.addActionListener(this.buttonHandler);
        Object object = this.accessLock;
        synchronized (object) {
            this.searchButtonMap.put(search, btn);
            this.searchButtonGroup.add(btn);
            this.addButton(btn);
        }
        if (this.displayedDataModel != null && search == this.displayedDataModel.getSearch()) {
            btn.setSelected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchRemoved(Search search, int position) {
        SearchButton btn = (SearchButton)this.searchButtonMap.remove(search);
        Object object = this.accessLock;
        synchronized (object) {
            this.searchButtonGroup.remove(btn);
            this.removeButton(btn);
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SearchButton searchButton = (SearchButton)e.getSource();
                searchButton.updateButtonDisplay();
                SearchButtonBar.this.searchTab.refreshTabActions();
                Search search = searchButton.getSearch();
                if (search == null) {
                    return;
                }
                SearchResultsDataModel dataModel = SearchResultsDataModel.lookupResultDataModel(search);
                SearchButtonBar.this.searchTab.setDisplayedSearch(dataModel);
            }
            catch (Exception exp) {
                NLogger.error("USER_INTERFACE", (Object)exp, (Throwable)exp);
            }
        }
    }

    private final class UpdateButtonsTimerAction
    implements ActionListener {
        private UpdateButtonsTimerAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                Object object = SearchButtonBar.this.accessLock;
                synchronized (object) {
                    Iterator iterator = SearchButtonBar.this.buttons.iterator();
                    while (iterator.hasNext()) {
                        SearchButton searchButton = (SearchButton)iterator.next();
                        searchButton.updateButtonDisplay();
                    }
                }
            }
            catch (Throwable th) {
                NLogger.error(class$phex$gui$tabs$search$cp$SearchInfoBox == null ? (class$phex$gui$tabs$search$cp$SearchInfoBox = SearchButtonBar.class$("phex.gui.tabs.search.cp.SearchInfoBox")) : class$phex$gui$tabs$search$cp$SearchInfoBox, (Object)th, th);
            }
        }
    }

    private final class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getClickCount() == 2) {
                    SearchButtonBar.this.searchTab.setDisplayedSearch(null);
                }
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }
}

