/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import org.apache.commons.collections.comparators.ComparableComparator;
import phex.event.ShareChangeListener;
import phex.event.SharedFilesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.renderer.FileSizeCellRenderer;
import phex.gui.tabs.library.FileSystemTableCellRenderer;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.thex.ShareFileThexData;
import phex.utils.FilesOnlyFileFilter;
import phex.utils.Localizer;

public class SharedFilesTableModel
extends FWSortableTableModel {
    public static final int FILE_COLUMN_ID = 1001;
    public static final int DIRECTORY_COLUMN_ID = 1002;
    public static final int SIZE_COLUMN_ID = 1003;
    public static final int SEARCH_COUNT_COLUMN_ID = 1004;
    public static final int UPLOAD_COUNT_COLUMN_ID = 1005;
    public static final int SHA1_COLUMN_ID = 1006;
    public static final int THEX_COLUMN_ID = 1007;
    public static final int ALT_LOC_COUNT_COLUMN_ID = 1008;
    public static final int FILE_MODEL_INDEX = 0;
    public static final int DIRECTORY_MODEL_INDEX = 1;
    public static final int SIZE_MODEL_INDEX = 2;
    public static final int SEARCH_COUNT_MODEL_INDEX = 3;
    public static final int UPLOAD_COUNT_MODEL_INDEX = 4;
    public static final int ALT_LOC_COUNT_MODEL_INDEX = 5;
    public static final int SHA1_MODEL_INDEX = 6;
    public static final int THEX_MODEL_INDEX = 7;
    private static String[] tableColumns = new String[]{Localizer.getString("File"), Localizer.getString("Directory"), Localizer.getString("Size"), Localizer.getString("SearchCount"), Localizer.getString("UploadCount"), Localizer.getString("SharedFilesTable_AltLocCount"), Localizer.getString("SHA1"), Localizer.getString("SharedFilesTable_TigerTree")};
    private static Class[] tableClasses = new Class[]{FileSystemTableCellRenderer.class, String.class, FileSizeCellRenderer.class, Integer.class, Integer.class, Integer.class, String.class, String.class};
    private FileFilter fileFilter = new FilesOnlyFileFilter();
    private File displayDirectory;
    private File[] displayDirectryFiles;
    private SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();

    public SharedFilesTableModel() {
        super(tableColumns, tableClasses);
        FileSystemChangeListener listener = new FileSystemChangeListener();
        this.sharedFilesService.addSharedFilesChangeListener(listener);
    }

    public void setDisplayDirectory(File displayDirectory) {
        this.displayDirectory = displayDirectory;
        if (displayDirectory != null) {
            this.displayDirectryFiles = displayDirectory.listFiles(this.fileFilter);
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.displayDirectory == null) {
            return 0;
        }
        if (this.displayDirectryFiles == null) {
            return 0;
        }
        return this.displayDirectryFiles.length;
    }

    public Object getValueAt(int row, int col) {
        if (this.displayDirectory == null) {
            return "";
        }
        if (row >= this.displayDirectryFiles.length) {
            this.fireTableRowsDeleted(row, row);
            return "";
        }
        ShareFile shareFile = this.sharedFilesService.getShareFileByFile(this.displayDirectryFiles[row]);
        if (shareFile == null) {
            switch (col) {
                case 0: {
                    return this.displayDirectryFiles[row];
                }
                case 1: {
                    return this.displayDirectryFiles[row].getParent();
                }
                case 2: {
                    return new Long(this.displayDirectryFiles[row].length());
                }
                case 3: 
                case 4: 
                case 5: {
                    return null;
                }
                case 6: 
                case 7: {
                    return "";
                }
            }
        } else {
            switch (col) {
                case 0: {
                    return shareFile;
                }
                case 1: {
                    return shareFile.getSystemFile().getParent();
                }
                case 2: {
                    return shareFile.getFileSizeObject();
                }
                case 3: {
                    return new Integer(shareFile.getSearchCount());
                }
                case 4: {
                    return new Integer(shareFile.getUploadCount());
                }
                case 5: {
                    if (shareFile.getURN() == null) {
                        return new Integer(0);
                    }
                    return new Integer(shareFile.getAltLocContainer().getSize());
                }
                case 6: {
                    return shareFile.getSHA1();
                }
                case 7: {
                    ShareFileThexData thexData = shareFile.getThexData(false);
                    return thexData != null ? thexData.getRootHash() : "";
                }
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 2: {
                return ComparableComparator.getInstance();
            }
        }
        return null;
    }

    public int mapColumnIDToModelIndex(int columnId) {
        switch (columnId) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
            case 1008: {
                return 5;
            }
            case 1006: {
                return 6;
            }
            case 1007: {
                return 7;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int columnID) {
        return columnID != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] columnIds = new int[]{1001, 1002, 1003, 1004, 1005, 1008, 1006, 1007};
        return columnIds;
    }

    private class SharedFilesListener
    implements SharedFilesChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void sharedFileChanged(int position) {
            SharedFilesTableModel.this.fireTableCellUpdated(position, position);
        }

        public void sharedFileAdded(int position) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SharedFilesTableModel.this, position, position, -1, 1));
        }

        public void sharedFileRemoved(int position) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SharedFilesTableModel.this, position, position, -1, -1));
        }

        public void allSharedFilesChanged() {
            SharedFilesTableModel.this.fireTableDataChanged();
        }
    }

    public class FileSystemChangeListener
    implements ShareChangeListener {
        public void sharedDirectoriesChanged() {
            SharedFilesTableModel.this.fireTableDataChanged();
        }
    }
}

