/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.SystemUtils;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.URN;
import phex.common.format.NumberFormatUtils;
import phex.event.ShareChangeListener;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWPopupMenu;
import phex.gui.common.FWToolBar;
import phex.gui.common.FileDialogHandler;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.dialogs.ExportDialog;
import phex.gui.dialogs.FilterLibraryDialog;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.library.LibraryNode;
import phex.gui.tabs.library.SharedFilesTableModel;
import phex.gui.tabs.library.SharingTreeModel;
import phex.gui.tabs.library.SharingTreeRenderer;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedDirectory;
import phex.share.SharedFilesService;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.SystemShellExecute;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class LibraryTab
extends FWTab {
    private static final String SHARED_FILES_TABLE_IDENTIFIER = "SharedFilesTable";
    private JLabel sharedFilesLabel;
    private FWTable sharedFilesTable;
    private JTree mainTree;
    private SharingTreeModel sharingTreeModel;
    private FWPopupMenu fileTreePopup;
    private FWPopupMenu fileTablePopup;
    private JScrollPane sharedFilesTableScrollPane;
    private SharedFilesTableModel sharedFilesModel;
    private FWTableColumnModel sharedFilesColumnModel;
    private static final String ADD_SHARE_FOLDER_ACTION_KEY = "AddShareFolderAction";
    private static final String REMOVE_SHARE_FOLDER_ACTION_KEY = "RemoveShareFolderAction";
    private static final String RESCAN_ACTION_KEY = "RescanAction";
    private static final String VIEW_BITZI_ACTION_KEY = "ViewBitziTicketAction";
    private static final String EXPORT_ACTION_KEY = "ExportAction";
    private static final String FILTER_ACTION_KEY = "FilterAction";
    private static final String OPEN_FILE_ACTION_KEY = "OpenFileAction";
    private static final String EXPLORE_FOLDER_ACTION_KEY = "ExploreFolderAction";

    public LibraryTab() {
        super(1007, Localizer.getString("Library"), GUIRegistry.getInstance().getIconFactory().getIcon("Library"), Localizer.getString("TTTLibrary"), Localizer.getChar("LibraryMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("LibraryAccelerator")), 4);
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout tabLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder tabBuilder = new PanelBuilder(tabLayout, this);
        JPanel contentPanel = new JPanel();
        FWElegantPanel elegantPanel = new FWElegantPanel(Localizer.getString("Library"), contentPanel);
        tabBuilder.add((Component)elegantPanel, cc.xy(2, 2));
        FormLayout contentLayout = new FormLayout("fill:d:grow", "fill:d:grow");
        PanelBuilder contentBuilder = new PanelBuilder(contentLayout, contentPanel);
        MouseHandler mouseHandler = new MouseHandler();
        JPanel treePanel = this.createTreePanel(mouseHandler);
        JPanel tablePanel = this.createTablePanel(guiSettings, mouseHandler);
        JSplitPane splitPane = new JSplitPane(1, treePanel, tablePanel);
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        splitPane.setDividerSize(4);
        splitPane.setOneTouchExpandable(false);
        contentBuilder.add((Component)splitPane, cc.xy(1, 1));
        this.sharedFilesLabel = new JLabel(" ");
        this.sharedFilesLabel.setHorizontalAlignment(4);
        elegantPanel.addHeaderPanelComponent(this.sharedFilesLabel, "East");
        ShareManager.getInstance().getSharedFilesService().addSharedFilesChangeListener(new SharedFilesChangeHandler());
        this.fileTreePopup = new FWPopupMenu();
        this.fileTablePopup = new FWPopupMenu();
        FWAction action = this.getTabAction(ADD_SHARE_FOLDER_ACTION_KEY);
        this.fileTreePopup.addAction(action);
        action = this.getTabAction(REMOVE_SHARE_FOLDER_ACTION_KEY);
        this.fileTreePopup.addAction(action);
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX) {
            action = this.getTabAction(EXPLORE_FOLDER_ACTION_KEY);
            this.fileTreePopup.addAction(action);
        }
        action = this.getTabAction(OPEN_FILE_ACTION_KEY);
        this.fileTablePopup.addAction(action);
        action = this.getTabAction(VIEW_BITZI_ACTION_KEY);
        this.fileTablePopup.addAction(action);
        this.fileTablePopup.addSeparator();
        this.fileTreePopup.addSeparator();
        action = this.getTabAction(RESCAN_ACTION_KEY);
        this.fileTablePopup.addAction(action);
        this.fileTreePopup.addAction(action);
        action = this.getTabAction(EXPORT_ACTION_KEY);
        this.fileTablePopup.addAction(action);
        this.fileTreePopup.addAction(action);
        action = this.getTabAction(FILTER_ACTION_KEY);
        this.fileTablePopup.addAction(action);
        this.fileTreePopup.addAction(action);
    }

    private JPanel createTreePanel(MouseHandler mouseHandler) {
        JPanel panel = new JPanel();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder tabBuilder = new PanelBuilder(layout, panel);
        this.sharingTreeModel = new SharingTreeModel();
        this.mainTree = new JTree(this.sharingTreeModel);
        this.mainTree.setMinimumSize(new Dimension(0, 0));
        this.mainTree.setRowHeight(0);
        this.mainTree.setCellRenderer(new SharingTreeRenderer());
        this.mainTree.addMouseListener(mouseHandler);
        this.mainTree.getSelectionModel().addTreeSelectionListener(new SelectionHandler());
        ToolTipManager.sharedInstance().registerComponent(this.mainTree);
        TreeNode root = (TreeNode)this.sharingTreeModel.getRoot();
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.mainTree.expandPath(new TreePath(new Object[]{root, root.getChildAt(i)}));
        }
        JScrollPane treeScrollPane = new JScrollPane(this.mainTree);
        tabBuilder.add((Component)treeScrollPane, cc.xywh(1, 1, 1, 1));
        FWToolBar shareToolbar = new FWToolBar(0);
        shareToolbar.setBorderPainted(false);
        shareToolbar.setFloatable(false);
        tabBuilder.add((Component)shareToolbar, cc.xy(1, 3));
        FWAction action = new AddShareFolderAction();
        this.addTabAction(ADD_SHARE_FOLDER_ACTION_KEY, action);
        shareToolbar.addAction(action);
        action = new RemoveShareFolderAction();
        this.addTabAction(REMOVE_SHARE_FOLDER_ACTION_KEY, action);
        shareToolbar.addAction(action);
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX) {
            action = new ExploreFolderAction();
            this.addTabAction(EXPLORE_FOLDER_ACTION_KEY, action);
        }
        return panel;
    }

    private JPanel createTablePanel(DGuiSettings guiSettings, MouseHandler mouseHandler) {
        JPanel panel = new JPanel();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder tabBuilder = new PanelBuilder(layout, panel);
        this.sharedFilesModel = new SharedFilesTableModel();
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(guiSettings, SHARED_FILES_TABLE_IDENTIFIER);
        this.buildSharedFilesTableColumnModel(dTable);
        this.sharedFilesTable = new FWTable((TableModel)new FWSortedTableModel(this.sharedFilesModel), this.sharedFilesColumnModel);
        this.sharedFilesTable.activateAllHeaderActions();
        this.sharedFilesTable.setAutoResizeMode(0);
        this.sharedFilesTable.addMouseListener(mouseHandler);
        this.sharedFilesTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.sharedFilesTableScrollPane = FWTable.createFWTableScrollPane(this.sharedFilesTable);
        tabBuilder.add((Component)this.sharedFilesTableScrollPane, cc.xy(1, 1));
        FWToolBar shareToolbar = new FWToolBar(0);
        shareToolbar.setBorderPainted(false);
        shareToolbar.setFloatable(false);
        tabBuilder.add((Component)shareToolbar, cc.xy(1, 3));
        FWAction action = new OpenFileAction();
        this.addTabAction(OPEN_FILE_ACTION_KEY, action);
        shareToolbar.addAction(action);
        action = new ViewBitziTicketAction();
        this.addTabAction(VIEW_BITZI_ACTION_KEY, action);
        shareToolbar.addAction(action);
        shareToolbar.addSeparator();
        action = new RescanAction();
        this.addTabAction(RESCAN_ACTION_KEY, action);
        shareToolbar.addAction(action);
        action = new ExportAction();
        this.addTabAction(EXPORT_ACTION_KEY, action);
        shareToolbar.addAction(action);
        action = new FilterAction();
        this.addTabAction(FILTER_ACTION_KEY, action);
        shareToolbar.addAction(action);
        return panel;
    }

    public void updateUI() {
        super.updateUI();
        if (this.sharedFilesTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.sharedFilesTableScrollPane);
        }
    }

    private LibraryNode getSelectedTreeComponent() {
        TreePath path = this.mainTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        LibraryNode node = (LibraryNode)path.getLastPathComponent();
        return node;
    }

    private void buildSharedFilesTableColumnModel(DTable tableSettings) {
        int[] columnIds = SharedFilesTableModel.getColumnIdArray();
        DTableColumnList columnList = null;
        if (tableSettings != null) {
            columnList = tableSettings.getTableColumnList();
        }
        this.sharedFilesColumnModel = new FWTableColumnModel(this.sharedFilesModel, columnIds, columnList);
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTableColumnList dList = this.sharedFilesColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dList);
        dTable.setTableIdentifier(SHARED_FILES_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == LibraryTab.this.mainTree) {
                LibraryTab.this.refreshTabActions();
                LibraryTab.this.fileTreePopup.show(source, x, y);
            } else if (source == LibraryTab.this.sharedFilesTable) {
                LibraryTab.this.refreshTabActions();
                LibraryTab.this.fileTablePopup.show(source, x, y);
            }
        }
    }

    private class SharedFilesChangeHandler
    implements ShareChangeListener {
        private SharedFilesChangeHandler() {
        }

        public void sharedDirectoriesChanged() {
            this.updateLabel();
        }

        private void updateLabel() {
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            buffer.append(sharedFilesService.getFileCount());
            buffer.append(" / ");
            buffer.append(NumberFormatUtils.formatSignificantByteSize((long)sharedFilesService.getTotalFileSizeInKb() * 1024L)).append(')');
            LibraryTab.this.sharedFilesLabel.setText(buffer.toString());
        }
    }

    private class SelectionHandler
    implements ListSelectionListener,
    TreeSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                LibraryTab.this.refreshTabActions();
            }
        }

        public void valueChanged(TreeSelectionEvent e) {
            final Object treeRoot = LibraryTab.this.sharingTreeModel.getRoot();
            final Object lastPathComponent = e.getPath().getLastPathComponent();
            if (lastPathComponent == treeRoot) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        LibraryTab.this.mainTree.setSelectionPath(new TreePath(new Object[]{treeRoot, LibraryTab.this.sharingTreeModel.getChild(treeRoot, 0)}));
                    }
                });
                return;
            }
            ThreadPool.getInstance().addJob(new Runnable(){

                public void run() {
                    if (lastPathComponent instanceof LibraryNode) {
                        LibraryTab.this.sharedFilesModel.setDisplayDirectory(((LibraryNode)lastPathComponent).getSystemFile());
                    } else {
                        LibraryTab.this.sharedFilesModel.setDisplayDirectory(null);
                    }
                }
            }, "LibraryTableUpdate");
            LibraryTab.this.refreshTabActions();
        }
    }

    private class RemoveShareFolderAction
    extends FWAction {
        RemoveShareFolderAction() {
            super(Localizer.getString("LibraryTab_StopShare"), GUIRegistry.getInstance().getIconFactory().getIcon("ShareFolderClear"), Localizer.getString("LibraryTab_TTTStopShare"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            TreePath selectionPath = LibraryTab.this.mainTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof LibraryNode)) {
                return;
            }
            final File file = ((LibraryNode)lastPathComponent).getSystemFile();
            if (file == null) {
                return;
            }
            Runnable runner = new Runnable(){

                public void run() {
                    RemoveShareFolderAction.this.stopShareDirRecursive(file);
                    GUIActionPerformer.rescanSharedFiles();
                }
            };
            ThreadPool.getInstance().addJob(runner, LibraryTab.REMOVE_SHARE_FOLDER_ACTION_KEY);
            this.refreshActionState();
        }

        private void stopShareDirRecursive(File file) {
            if (!file.isDirectory()) {
                return;
            }
            ServiceManager.sCfg.sharedDirectoriesSet.remove(file.getAbsolutePath());
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            SharedDirectory directory = sharedFilesService.getSharedDirectory(file);
            if (directory == null) {
                return;
            }
            File[] dirs = file.listFiles(new DirectoryOnlyFileFilter());
            for (int i = 0; i < dirs.length; ++i) {
                this.stopShareDirRecursive(dirs[i]);
            }
        }

        public void refreshActionState() {
            TreePath selectionPath = LibraryTab.this.mainTree.getSelectionPath();
            if (selectionPath == null) {
                this.setEnabled(false);
                return;
            }
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof LibraryNode)) {
                this.setEnabled(false);
                return;
            }
            File file = ((LibraryNode)lastPathComponent).getSystemFile();
            if (file == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }
    }

    private class AddShareFolderAction
    extends FWAction {
        AddShareFolderAction() {
            super(Localizer.getString("LibraryTab_Share"), GUIRegistry.getInstance().getIconFactory().getIcon("ShareFolder"), Localizer.getString("LibraryTab_TTTShare"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File[] files;
                Object lastPathComponent;
                File currentDirectory = null;
                TreePath selectionPath = LibraryTab.this.mainTree.getSelectionPath();
                if (selectionPath != null && (lastPathComponent = selectionPath.getLastPathComponent()) instanceof LibraryNode) {
                    currentDirectory = ((LibraryNode)lastPathComponent).getSystemFile();
                }
                if ((files = FileDialogHandler.openMultipleDirectoryChooser(LibraryTab.this, Localizer.getString("LibraryTab_SelectDirectoryToShare"), Localizer.getString("LibraryTab_Select"), Localizer.getChar("LibraryTab_SelectMnemonic"), currentDirectory, Localizer.getString("LibraryTab_CopyrightWarnTitle"), Localizer.getString("LibraryTab_CopyrightWarnMessage"))) == null) {
                    return;
                }
                Runnable runner = new Runnable(){

                    public void run() {
                        try {
                            for (int i = 0; i < files.length; ++i) {
                                if (files[i] == null) continue;
                                AddShareFolderAction.this.shareDirRecursive(files[i]);
                            }
                            GUIActionPerformer.rescanSharedFiles();
                        }
                        catch (Throwable th) {
                            NLogger.error("USER_INTERFACE", (Object)th, th);
                        }
                    }
                };
                ThreadPool.getInstance().addJob(runner, LibraryTab.ADD_SHARE_FOLDER_ACTION_KEY);
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        public void refreshActionState() {
        }

        private void shareDirRecursive(File file) {
            if (!file.isDirectory()) {
                return;
            }
            ServiceManager.sCfg.sharedDirectoriesSet.add(file.getAbsolutePath());
            File[] dirs = file.listFiles(new DirectoryOnlyFileFilter());
            for (int i = 0; i < dirs.length; ++i) {
                this.shareDirRecursive(dirs[i]);
            }
        }
    }

    private class ExploreFolderAction
    extends FWAction {
        ExploreFolderAction() {
            super(Localizer.getString("LibraryTab_Explore"), GUIRegistry.getInstance().getIconFactory().getIcon("Explore"), Localizer.getString("LibraryTab_TTTExplore"));
        }

        public void actionPerformed(ActionEvent e) {
            TreePath selectionPath = LibraryTab.this.mainTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof LibraryNode)) {
                return;
            }
            File dir = ((LibraryNode)lastPathComponent).getSystemFile();
            if (dir == null) {
                return;
            }
            try {
                SystemShellExecute.exploreFolder(dir);
            }
            catch (IOException exp) {
                // empty catch block
            }
        }

        public void refreshActionState() {
            TreePath selectionPath = LibraryTab.this.mainTree.getSelectionPath();
            if (selectionPath == null) {
                this.setEnabled(false);
                return;
            }
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof LibraryNode)) {
                this.setEnabled(false);
                return;
            }
            File file = ((LibraryNode)lastPathComponent).getSystemFile();
            if (file == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }
    }

    private class FilterAction
    extends FWAction {
        public FilterAction() {
            super(Localizer.getString("LibraryTab_Filter"), GUIRegistry.getInstance().getIconFactory().getIcon("Filter"), Localizer.getString("LibraryTab_TTTFilter"));
        }

        public void actionPerformed(ActionEvent e) {
            FilterLibraryDialog dialog = new FilterLibraryDialog();
            dialog.setVisible(true);
        }

        public void refreshActionState() {
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            block4: {
                int row = LibraryTab.this.sharedFilesTable.getSelectedRow();
                row = LibraryTab.this.sharedFilesTable.convertRowIndexToModel(row);
                if (row < 0) {
                    return;
                }
                Object obj = LibraryTab.this.sharedFilesModel.getValueAt(row, 0);
                if (obj == null || !(obj instanceof ShareFile)) {
                    return;
                }
                ShareFile sFile = (ShareFile)obj;
                URN urn = sFile.getURN();
                String url = URLUtil.buildBitziLookupURL(urn);
                try {
                    BrowserLauncher.openURL(url);
                }
                catch (IOException exp) {
                    NLogger.warn("USER_INTERFACE", (Object)exp);
                    Object[] dialogOptions = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int choice = JOptionPane.showOptionDialog(LibraryTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, dialogOptions, Localizer.getString("Yes"));
                    if (choice != 0) break block4;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
                }
            }
        }

        public void refreshActionState() {
            int row = LibraryTab.this.sharedFilesTable.getSelectedRow();
            row = LibraryTab.this.sharedFilesTable.convertRowIndexToModel(row);
            if (row < 0) {
                this.setEnabled(false);
                return;
            }
            Object obj = LibraryTab.this.sharedFilesModel.getValueAt(row, 0);
            if (obj == null || !(obj instanceof ShareFile)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class OpenFileAction
    extends FWAction {
        OpenFileAction() {
            super(Localizer.getString("LibraryTab_OpenFile"), GUIRegistry.getInstance().getIconFactory().getIcon("Open"), Localizer.getString("LibraryTab_TTTOpenFile"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File file;
                int row = LibraryTab.this.sharedFilesTable.getSelectedRow();
                row = LibraryTab.this.sharedFilesTable.convertRowIndexToModel(row);
                if (row < 0) {
                    return;
                }
                Object obj = LibraryTab.this.sharedFilesModel.getValueAt(row, 0);
                if (obj == null) {
                    return;
                }
                if (obj instanceof ShareFile) {
                    ShareFile sFile = (ShareFile)obj;
                    file = sFile.getSystemFile();
                } else if (obj instanceof File) {
                    file = (File)obj;
                } else {
                    return;
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            SystemShellExecute.launchFile(file);
                        }
                        catch (IOException exp) {
                        }
                        catch (Throwable th) {
                            NLogger.error("USER_INTERFACE", (Object)th, th);
                        }
                    }
                };
                ThreadPool.getInstance().addJob(runnable, "SystenShellExecute");
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        public void refreshActionState() {
            int row = LibraryTab.this.sharedFilesTable.getSelectedRow();
            row = LibraryTab.this.sharedFilesTable.convertRowIndexToModel(row);
            if (row < 0) {
                this.setEnabled(false);
                return;
            }
            Object obj = LibraryTab.this.sharedFilesModel.getValueAt(row, 0);
            if (obj == null) {
                this.setEnabled(false);
                return;
            }
            if (obj instanceof ShareFile || obj instanceof File) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class ExportAction
    extends FWAction {
        ExportAction() {
            super(Localizer.getString("LibraryTab_Export"), GUIRegistry.getInstance().getIconFactory().getIcon("Export"), Localizer.getString("LibraryTab_TTTExport"));
        }

        public void actionPerformed(ActionEvent e) {
            ExportDialog dialog = new ExportDialog();
            dialog.setVisible(true);
        }

        public void refreshActionState() {
        }
    }

    class RescanAction
    extends FWAction {
        RescanAction() {
            super(Localizer.getString("LibraryTab_Rescan"), GUIRegistry.getInstance().getIconFactory().getIcon("Refresh"), Localizer.getString("LibraryTab_TTTRescan"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTab.this.sharingTreeModel.updateFileSystem();
            GUIActionPerformer.rescanSharedFiles();
        }

        public void refreshActionState() {
        }
    }
}

