/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class HalfGrayedImageFilter
extends GrayFilter {
    public static Icon createHalfGrayIcon(Icon icon) {
        HalfGrayedImageFilter filter = new HalfGrayedImageFilter();
        FilteredImageSource prod = new FilteredImageSource(((ImageIcon)icon).getImage().getSource(), filter);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
        return new ImageIcon(grayImage);
    }

    public HalfGrayedImageFilter() {
        super(true, 60);
        this.canFilterIndexColorModel = false;
    }

    public void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int off, int scansize) {
        for (int cy = 0; cy < h; ++cy) {
            for (int cx = w - y - 1; cx < w; ++cx) {
                if (cx == w - y - 1) {
                    if (pixels[cx] >> 24 == 0) continue;
                    pixels[cx] = -16777216;
                    continue;
                }
                pixels[cx] = this.filterRGB(x + cx, y + cy, pixels[cx]);
            }
        }
        this.consumer.setPixels(x, y, w, h, ColorModel.getRGBdefault(), pixels, off, scansize);
    }
}

