/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import phex.event.ShareChangeListener;
import phex.share.ShareManager;
import phex.utils.DirectoryOnlyFileFilter;
import sun.awt.shell.ShellFolder;

public class FileSystemTreeModel
implements TreeModel {
    protected EventListenerList listenerList = new EventListenerList();
    private FileFilter dirFilter = new DirectoryOnlyFileFilter();
    private File[] fsRoots;
    private Object root = new String("ROOT");
    private HashMap fsTree = new HashMap();
    FileSystemView fsv;

    public FileSystemTreeModel() {
        this.updateFileSystem();
        FileSystemChangeListener listener = new FileSystemChangeListener();
        ShareManager.getInstance().getSharedFilesService().addSharedFilesChangeListener(listener);
    }

    public void updateFileSystem() {
        this.fsv = FileSystemView.getFileSystemView();
        this.fsRoots = this.fsv.getRoots();
        this.fsTree.clear();
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        System.out.println("getChild " + parent + " " + index);
        if (parent.equals(this.root)) {
            return this.fsRoots[index];
        }
        FolderInfo info = this.getFolderInfo((File)parent);
        return info.getChilds()[index];
    }

    public int getChildCount(Object parent) {
        System.out.println("getChildCount " + parent);
        if (parent.equals(this.root)) {
            return this.fsRoots.length;
        }
        FolderInfo info = this.getFolderInfo((File)parent);
        return info.getChilds().length;
    }

    public boolean isLeaf(Object node) {
        return false;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        System.out.println("valueForPathChanged");
    }

    public int getIndexOfChild(Object parent, Object child) {
        System.out.println("getIndexOfChild");
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    private void fireTreeStructureChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? FileSystemTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, (TreePath)null);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    private FolderInfo getFolderInfo(File file) {
        FolderInfo fInfo = (FolderInfo)this.fsTree.get(file);
        if (fInfo != null && fInfo.timestamp < System.currentTimeMillis() - 30000L) {
            return fInfo;
        }
        fInfo = new FolderInfo();
        fInfo.file = file;
        fInfo.timestamp = System.currentTimeMillis();
        this.fsTree.put(file, fInfo);
        return fInfo;
    }

    private class FolderInfo {
        private File file;
        private File[] childs;
        long timestamp;

        private FolderInfo() {
        }

        public File[] getChilds() {
            System.out.println("---");
            System.out.println(((ShellFolder)this.file).getPath());
            System.out.println(((ShellFolder)this.file).isFileSystem());
            System.out.println(ShellFolder.isComputerNode(this.file));
            System.out.println(ShellFolder.isFileSystemRoot(this.file));
            System.out.println("---");
            if (this.childs != null) {
                return this.childs;
            }
            File[] files = FileSystemTreeModel.this.fsv.getFiles(this.file, false);
            ArrayList<File> folderList = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                if (!FileSystemTreeModel.this.fsv.isTraversable(files[i]).booleanValue()) continue;
                folderList.add(files[i]);
            }
            this.childs = folderList.toArray(new File[folderList.size()]);
            return this.childs;
        }
    }

    public class FileSystemChangeListener
    implements ShareChangeListener {
        public void sharedDirectoriesChanged() {
            FileSystemTreeModel.this.fireTreeStructureChanged();
        }
    }
}

