/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import java.util.Comparator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import org.apache.commons.collections.comparators.ComparableComparator;
import phex.common.ShortObj;
import phex.common.format.NumberFormatUtils;
import phex.download.DownloadScopeList;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadCandidatesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.comparator.HostAddressComparator;
import phex.gui.renderer.HostAddressCellRenderer;
import phex.gui.renderer.ScopeProgressCellRenderer;
import phex.utils.Localizer;

public class SWCandidateTableModel
extends FWSortableTableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int VENDOR_COLUMN_ID = 1002;
    public static final int PROGRESS_COLUMN_ID = 1003;
    public static final int TOTAL_DOWNLOAD_COLUMN_ID = 1004;
    public static final int RATE_COLUMN_ID = 1005;
    public static final int STATUS_COLUMN_ID = 1006;
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int PROGRESS_MODEL_INDEX = 2;
    public static final int TOTAL_DOWNLOAD_MODEL_INDEX = 3;
    public static final int RATE_MODEL_INDEX = 4;
    public static final int STATUS_MODEL_INDEX = 5;
    private static String[] tableColumns = new String[]{Localizer.getString("SharingHost"), Localizer.getString("Vendor"), Localizer.getString("DownloadTable_Available"), Localizer.getString("DownloadTable_DownloadTotal"), Localizer.getString("Rate"), Localizer.getString("Status")};
    private static Class[] tableClasses = new Class[]{HostAddressCellRenderer.class, String.class, ScopeProgressCellRenderer.class, String.class, String.class, String.class};
    private SwarmingManager swarmingMgr = SwarmingManager.getInstance();
    private SWDownloadFile downloadFile;
    private FWTable downloadTable;
    private DownloadCandidatesListener changeListener;

    public SWCandidateTableModel(FWTable aDownloadTable) {
        super(tableColumns, tableClasses);
        this.downloadTable = aDownloadTable;
        this.downloadTable.getSelectionModel().addListSelectionListener(new DownloadSelectionChangeHandler());
        this.changeListener = new DownloadCandidatesListener();
    }

    public SWDownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    public int getRowCount() {
        if (this.downloadFile == null) {
            return 0;
        }
        return this.downloadFile.getCandidatesCount();
    }

    public Object getValueAt(int row, int column) {
        SWDownloadCandidate candidate = this.downloadFile.getCandidate(row);
        if (candidate == null) {
            this.fireTableRowsDeleted(row, row);
            return "";
        }
        switch (column) {
            case 0: {
                return candidate.getHostAddress();
            }
            case 1: {
                return candidate.getVendor();
            }
            case 2: {
                return candidate;
            }
            case 3: {
                return NumberFormatUtils.formatSignificantByteSize(candidate.getTotalDownloadSize());
            }
            case 4: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return null;
                }
                return NumberFormatUtils.formatSignificantByteSize(segment.getTransferSpeed()) + Localizer.getString("PerSec");
            }
            case 5: {
                return SWDownloadInfo.getDownloadCandidateStatusString(candidate);
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 0: {
                return new HostAddressComparator();
            }
            case 2: {
                return ComparableComparator.getInstance();
            }
        }
        return null;
    }

    public Object getComparableValueAt(int row, int column) {
        SWDownloadCandidate candidate = this.downloadFile.getCandidate(row);
        if (candidate == null) {
            return "";
        }
        switch (column) {
            case 2: {
                DownloadScopeList availableScopeList = candidate.getAvailableScopeList();
                if (availableScopeList == null) {
                    return null;
                }
                return new Long(availableScopeList.getAggregatedLength());
            }
            case 3: {
                return new Long(candidate.getTotalDownloadSize());
            }
            case 5: {
                ShortObj status = candidate.getStatusObj();
                if (status.value == 18) {
                    int queuePosition = candidate.getXQueueParameters().getPosition();
                    Double doubObj = new Double(status.doubleValue() + 1.0 - Math.min((double)queuePosition, 10000.0) / 10000.0);
                    return doubObj;
                }
                long timeLeft = candidate.getStatusTimeLeft();
                double val = timeLeft == 0L ? status.doubleValue() : status.doubleValue() - 1.0 + 1.0 / (double)timeLeft;
                return new Double(val);
            }
            case 4: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return null;
                }
                return new Long(segment.getTransferSpeed());
            }
        }
        return this.getValueAt(row, column);
    }

    public int mapColumnIDToModelIndex(int columnId) {
        switch (columnId) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
            case 1006: {
                return 5;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int columnID) {
        return columnID != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] columnIds = new int[]{1001, 1002, 1003, 1004, 1005, 1006};
        return columnIds;
    }

    private class DownloadCandidatesListener
    implements DownloadCandidatesChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void downloadCandidateChanged(int position) {
            SWCandidateTableModel.this.fireTableCellUpdated(position, position);
        }

        public void downloadCandidateAdded(int position) {
            SWCandidateTableModel.this.fireTableChanged(new TableModelEvent(SWCandidateTableModel.this, position, position, -1, 1));
        }

        public void downloadCandidateRemoved(int position) {
            SWCandidateTableModel.this.fireTableChanged(new TableModelEvent(SWCandidateTableModel.this, position, position, -1, -1));
        }
    }

    private class DownloadSelectionChangeHandler
    implements ListSelectionListener {
        private DownloadSelectionChangeHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ListSelectionModel model = (ListSelectionModel)e.getSource();
                int viewIdx = model.getMinSelectionIndex();
                int modelIdx = SWCandidateTableModel.this.downloadTable.convertRowIndexToModel(viewIdx);
                SWDownloadFile tmpDownloadFile = SWCandidateTableModel.this.swarmingMgr.getDownloadFile(modelIdx);
                if (tmpDownloadFile != SWCandidateTableModel.this.downloadFile) {
                    if (SWCandidateTableModel.this.downloadFile != null) {
                        SWCandidateTableModel.this.downloadFile.removeDownloadCandidatesChangeListener(SWCandidateTableModel.this.changeListener);
                    }
                    SWCandidateTableModel.this.downloadFile = tmpDownloadFile;
                    if (SWCandidateTableModel.this.downloadFile != null) {
                        SWCandidateTableModel.this.downloadFile.addDownloadCandidatesChangeListener(SWCandidateTableModel.this.changeListener);
                    }
                    SWCandidateTableModel.this.fireTableDataChanged();
                }
            }
        }
    }
}

