/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.table.TableModel;
import phex.download.swarming.SWDownloadFile;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.tabs.download.DownloadTransferTableModel;
import phex.utils.NLogger;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class DownloadTransfersPanel
extends JPanel {
    private static final String TRANSFER_TABLE_IDENTIFIER = "TransferTable";
    private SWDownloadFile lastDownloadFile;
    private FWTable transferTable;
    private FWTableColumnModel transferColumnModel;
    private JScrollPane transferTableScrollPane;
    private DownloadTransferTableModel transferModel;

    public void initializeComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "fill:d:grow");
        PanelBuilder tabBuilder = new PanelBuilder(layout, this);
        this.transferModel = new DownloadTransferTableModel();
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(guiSettings, TRANSFER_TABLE_IDENTIFIER);
        this.buildTransferTableColumnModel(dTable);
        this.transferTable = new FWTable((TableModel)new FWSortedTableModel(this.transferModel), this.transferColumnModel);
        this.transferTable.activateAllHeaderActions();
        this.transferTable.setSelectionMode(0);
        this.transferTable.setAutoResizeMode(0);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.transferTable);
        this.transferTableScrollPane = FWTable.createFWTableScrollPane(this.transferTable);
        tabBuilder.add((Component)this.transferTableScrollPane, cc.xy(1, 1));
        GUIUtils.adjustTableProgresssBarHeight(this.transferTable);
        ActionListener updateInterfaceAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DownloadTransfersPanel.this.updateInterface();
                }
                catch (Throwable th) {
                    NLogger.error("USER_INTERFACE", (Object)th, th);
                }
            }
        };
        Timer timer = new Timer(2000, updateInterfaceAction);
        timer.start();
    }

    public void updateDownloadFile(SWDownloadFile file) {
        this.lastDownloadFile = file;
        this.transferModel.updateDownloadFile(file);
        this.updateInterface();
    }

    private void updateInterface() {
        this.transferModel.fireTableRowsUpdated(0, this.transferModel.getRowCount());
    }

    public void updateUI() {
        super.updateUI();
        if (this.transferTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.transferTable);
        }
        if (this.transferTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.transferTableScrollPane);
        }
    }

    private void buildTransferTableColumnModel(DTable tableSettings) {
        int[] columnIds = DownloadTransferTableModel.getColumnIdArray();
        DTableColumnList columnList = null;
        if (tableSettings != null) {
            columnList = tableSettings.getTableColumnList();
        }
        this.transferColumnModel = new FWTableColumnModel(this.transferModel, columnIds, columnList);
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        DTableColumnList dList = this.transferColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dList);
        dTable.setTableIdentifier(TRANSFER_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }
}

