/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import org.apache.commons.collections.comparators.ComparableComparator;
import phex.common.ShortObj;
import phex.common.format.NumberFormatUtils;
import phex.download.DownloadScopeList;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadSegment;
import phex.event.DownloadCandidatesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.comparator.ETAComparator;
import phex.gui.comparator.HostAddressComparator;
import phex.gui.renderer.ETACellRenderer;
import phex.gui.renderer.HostAddressCellRenderer;
import phex.gui.renderer.ProgressCellRenderer;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class DownloadTransferTableModel
extends FWSortableTableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int VENDOR_COLUMN_ID = 1002;
    public static final int FROM_COLUMN_ID = 1003;
    public static final int TO_COLUMN_ID = 1004;
    public static final int COMPLETED_COLUMN_ID = 1005;
    public static final int SIZE_COLUMN_ID = 1006;
    public static final int PROGRESS_COLUMN_ID = 1007;
    public static final int RATE_COLUMN_ID = 1008;
    public static final int ETA_COLUMN_ID = 1009;
    public static final int STATUS_COLUMN_ID = 1010;
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int FROM_MODEL_INDEX = 2;
    public static final int TO_MODEL_INDEX = 3;
    public static final int COMPLETED_MODEL_INDEX = 4;
    public static final int SIZE_MODEL_INDEX = 5;
    public static final int PROGRESS_MODEL_INDEX = 6;
    public static final int RATE_MODEL_INDEX = 7;
    public static final int ETA_MODEL_INDEX = 8;
    public static final int STATUS_MODEL_INDEX = 9;
    private static String[] tableColumns = new String[]{Localizer.getString("DownloadTransfer_Host"), Localizer.getString("DownloadTransfer_Vendor"), Localizer.getString("DownloadTransfer_From"), Localizer.getString("DownloadTransfer_To"), Localizer.getString("DownloadTransfer_Completed"), Localizer.getString("DownloadTransfer_Size"), Localizer.getString("DownloadTransfer_Progress"), Localizer.getString("DownloadTransfer_Rate"), Localizer.getString("DownloadTransfer_ETA"), Localizer.getString("DownloadTransfer_Status")};
    private static Class[] tableClasses = new Class[]{HostAddressCellRenderer.class, String.class, String.class, String.class, String.class, String.class, ProgressCellRenderer.class, String.class, ETACellRenderer.class, String.class};
    private SWDownloadFile downloadFile;
    private DownloadCandidatesListener changeListener = new DownloadCandidatesListener();

    public DownloadTransferTableModel() {
        super(tableColumns, tableClasses);
    }

    public void updateDownloadFile(SWDownloadFile file) {
        if (this.downloadFile == file) {
            return;
        }
        if (this.downloadFile != null) {
            this.downloadFile.removeDownloadCandidatesChangeListener(this.changeListener);
        }
        this.downloadFile = file;
        if (this.downloadFile != null) {
            this.downloadFile.addDownloadCandidatesChangeListener(this.changeListener);
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.downloadFile == null) {
            return 0;
        }
        return this.downloadFile.getTransferCandidateCount();
    }

    public Object getValueAt(int row, int column) {
        SWDownloadCandidate candidate = this.downloadFile.getTransferCandidate(row);
        if (candidate == null) {
            return "";
        }
        switch (column) {
            case 0: {
                return candidate.getHostAddress();
            }
            case 1: {
                return candidate.getVendor();
            }
            case 2: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return "";
                }
                return NumberFormatUtils.formatSize(segment.getStart());
            }
            case 3: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return "";
                }
                return NumberFormatUtils.formatSize(segment.getEnd());
            }
            case 4: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return "";
                }
                return NumberFormatUtils.formatFullByteSize(segment.getTransferredDataSize());
            }
            case 5: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return "";
                }
                return NumberFormatUtils.formatFullByteSize(segment.getTotalDataSize());
            }
            case 6: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return "";
                }
                return segment.getProgress();
            }
            case 7: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return "";
                }
                return NumberFormatUtils.formatSignificantByteSize(segment.getTransferSpeed()) + Localizer.getString("PerSec");
            }
            case 8: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return "";
                }
                return segment;
            }
            case 9: {
                return SWDownloadInfo.getDownloadCandidateStatusString(candidate);
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 0: {
                return new HostAddressComparator();
            }
            case 6: {
                return ComparableComparator.getInstance();
            }
            case 8: {
                return new ETAComparator();
            }
        }
        return null;
    }

    public Object getComparableValueAt(int row, int column) {
        SWDownloadCandidate candidate = this.downloadFile.getTransferCandidate(row);
        if (candidate == null) {
            return "";
        }
        switch (column) {
            case 2: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return null;
                }
                return new Long(segment.getStart());
            }
            case 3: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return null;
                }
                return new Long(segment.getEnd());
            }
            case 5: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return null;
                }
                return new Long(segment.getTotalDataSize());
            }
            case 6: {
                DownloadScopeList availableScopeList = candidate.getAvailableScopeList();
                if (availableScopeList == null) {
                    return null;
                }
                return new Long(availableScopeList.getAggregatedLength());
            }
            case 9: {
                ShortObj status = candidate.getStatusObj();
                if (status.value == 18) {
                    int queuePosition = candidate.getXQueueParameters().getPosition();
                    Double doubObj = new Double(status.doubleValue() + 1.0 - Math.min((double)queuePosition, 10000.0) / 10000.0);
                    return doubObj;
                }
                long timeLeft = candidate.getStatusTimeLeft();
                return new Double(status.doubleValue() + (double)timeLeft / 1000000.0);
            }
            case 7: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return null;
                }
                return new Long(segment.getTransferSpeed());
            }
            case 8: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                return segment;
            }
        }
        return this.getValueAt(row, column);
    }

    public int mapColumnIDToModelIndex(int columnId) {
        switch (columnId) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1006: {
                return 5;
            }
            case 1005: {
                return 4;
            }
            case 1007: {
                return 6;
            }
            case 1008: {
                return 7;
            }
            case 1009: {
                return 8;
            }
            case 1010: {
                return 9;
            }
        }
        NLogger.error("USER_INTERFACE", "Invalid column id: " + columnId);
        return -1;
    }

    public boolean isColumnHideable(int columnID) {
        return columnID != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] columnIds = new int[]{1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010};
        return columnIds;
    }

    private class DownloadCandidatesListener
    implements DownloadCandidatesChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void downloadCandidateChanged(int position) {
            DownloadTransferTableModel.this.fireTableCellUpdated(position, position);
        }

        public void downloadCandidateAdded(int position) {
            DownloadTransferTableModel.this.fireTableChanged(new TableModelEvent(DownloadTransferTableModel.this, position, position, -1, 1));
        }

        public void downloadCandidateRemoved(int position) {
            DownloadTransferTableModel.this.fireTableChanged(new TableModelEvent(DownloadTransferTableModel.this, position, position, -1, -1));
        }
    }
}

