/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import phex.gui.actions.FWAction;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.dialogs.SecurityRuleConfigDialog;
import phex.gui.models.SecurityTableModel;
import phex.gui.renderer.SecurityRuleRowRenderer;
import phex.gui.tabs.FWTab;
import phex.security.IPAccessRule;
import phex.security.PhexSecurityManager;
import phex.security.SecurityRule;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableColumnList;

public class SecurityTab
extends FWTab {
    private static final String SECURITY_TABLE_IDENTIFIER = "SecurityTable";
    private static final SecurityRule[] EMPTY_SECURITYRULE_ARRAY = new SecurityRule[0];
    private JPopupMenu securityPopup;
    private SecurityTableModel securityModel;
    private FWTableColumnModel securityColumnModel;
    private FWTable securityTable;
    private JScrollPane securityTableScrollPane;
    private PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
    private static final String EDIT_SECURITY_RULE_ACTION_KEY = "EditSecurityRuleAction";

    public SecurityTab() {
        super(1005, Localizer.getString("Security"), GUIRegistry.getInstance().getIconFactory().getIcon("Security"), Localizer.getString("TTTSecurity"), Localizer.getChar("SecurityMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("SecurityAccelerator")), 5);
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout tabLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder tabBuilder = new PanelBuilder(tabLayout, this);
        JPanel contentPanel = new JPanel();
        FWElegantPanel banner = new FWElegantPanel(Localizer.getString("Security"), contentPanel);
        tabBuilder.add((Component)banner, cc.xy(2, 2));
        FormLayout contentLayout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder contentBuilder = new PanelBuilder(contentLayout, contentPanel);
        MouseHandler mouseHandler = new MouseHandler();
        this.securityModel = new SecurityTableModel();
        DTable dTable = GUIUtils.getDGuiTableByIdentifier(guiSettings, SECURITY_TABLE_IDENTIFIER);
        this.buildSecurityTableColumnModel(dTable);
        this.securityTable = new FWTable((TableModel)new FWSortedTableModel(this.securityModel), this.securityColumnModel);
        SecurityRuleRowRenderer securityRowRenderer = new SecurityRuleRowRenderer();
        Enumeration<TableColumn> enumr = this.securityColumnModel.getColumns();
        while (enumr.hasMoreElements()) {
            TableColumn column = enumr.nextElement();
            column.setCellRenderer(securityRowRenderer);
        }
        this.securityTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.securityTable.activateAllHeaderActions();
        this.securityTable.setAutoResizeMode(0);
        this.securityTable.addMouseListener(mouseHandler);
        this.securityTableScrollPane = FWTable.createFWTableScrollPane(this.securityTable);
        this.securityTableScrollPane.addMouseListener(mouseHandler);
        contentBuilder.add((Component)this.securityTableScrollPane, cc.xy(1, 1));
        FWToolBar securityToolbar = new FWToolBar(0);
        securityToolbar.setBorderPainted(false);
        securityToolbar.setFloatable(false);
        contentBuilder.add((Component)securityToolbar, cc.xy(1, 3));
        this.securityPopup = new JPopupMenu();
        FWAction action = new NewSecurityRuleAction();
        this.addTabAction(action);
        securityToolbar.addAction(action);
        this.securityPopup.add(action);
        action = new EditSecurityRuleAction();
        this.addTabAction(EDIT_SECURITY_RULE_ACTION_KEY, action);
        securityToolbar.addAction(action);
        this.securityPopup.add(action);
        action = new RemoveSecurityRuleAction();
        this.addTabAction(action);
        securityToolbar.addAction(action);
        this.securityPopup.add(action);
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.securityTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.securityTableScrollPane);
        }
    }

    private SecurityRule[] getSelectedSecurityRules() {
        if (this.securityTable.getSelectedRowCount() == 0) {
            return EMPTY_SECURITYRULE_ARRAY;
        }
        int[] viewIndices = this.securityTable.getSelectedRows();
        int[] modelIndices = this.securityTable.convertRowIndicesToModel(viewIndices);
        SecurityRule[] files = this.securityMgr.getIPAccessRulesAt(modelIndices);
        return files;
    }

    private void buildSecurityTableColumnModel(DTable tableSettings) {
        int[] columnIds = SecurityTableModel.getColumnIdArray();
        DTableColumnList columnList = null;
        if (tableSettings != null) {
            columnList = tableSettings.getTableColumnList();
        }
        this.securityColumnModel = new FWTableColumnModel(this.securityModel, columnIds, columnList);
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTableColumnList dList = this.securityColumnModel.createDGuiTableColumnList();
        DTable dTable = new DTable();
        dTable.setTableColumnList(dList);
        dTable.setTableIdentifier(SECURITY_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    public class RemoveSecurityRuleAction
    extends FWAction {
        public RemoveSecurityRuleAction() {
            super(Localizer.getString("RemoveSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTRemoveSecurityRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (SecurityTab.this.securityTable.getSelectedRow() < 0) {
                    this.setEnabled(false);
                    return;
                }
                SecurityRule[] securityRules = SecurityTab.this.getSelectedSecurityRules();
                for (int i = 0; i < securityRules.length; ++i) {
                    if (securityRules[i] == null || securityRules[i].isSystemRule()) continue;
                    PhexSecurityManager.getInstance().removeSecurityRule(securityRules[i]);
                }
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        public void refreshActionState() {
            int row = SecurityTab.this.securityTable.getSelectedRow();
            if (row < 0) {
                this.setEnabled(false);
                return;
            }
            SecurityRule[] securityRules = SecurityTab.this.getSelectedSecurityRules();
            for (int i = 0; i < securityRules.length; ++i) {
                if (securityRules[i] == null || securityRules[i].isSystemRule()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    public class EditSecurityRuleAction
    extends FWAction {
        public EditSecurityRuleAction() {
            super(Localizer.getString("EditSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("Edit"), Localizer.getString("TTTEditSecurityRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (SecurityTab.this.securityTable.getSelectedRowCount() != 1) {
                    return;
                }
                int viewIdx = SecurityTab.this.securityTable.getSelectedRow();
                int modelIdx = SecurityTab.this.securityTable.convertRowIndexToModel(viewIdx);
                IPAccessRule rule = SecurityTab.this.securityMgr.getIPAccessRule(modelIdx);
                if (rule == null || rule.isSystemRule()) {
                    return;
                }
                SecurityRuleConfigDialog dialog = new SecurityRuleConfigDialog(rule);
                dialog.show();
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        public void refreshActionState() {
            if (SecurityTab.this.securityTable.getSelectedRowCount() == 1) {
                int viewIdx = SecurityTab.this.securityTable.getSelectedRow();
                int modelIdx = SecurityTab.this.securityTable.convertRowIndexToModel(viewIdx);
                IPAccessRule rule = SecurityTab.this.securityMgr.getIPAccessRule(modelIdx);
                if (rule == null || rule.isSystemRule()) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    public class NewSecurityRuleAction
    extends FWAction {
        public NewSecurityRuleAction() {
            super(Localizer.getString("NewSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("New"), Localizer.getString("TTTNewSecurityRule"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SecurityRuleConfigDialog dialog = new SecurityRuleConfigDialog();
                dialog.show();
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        public void refreshActionState() {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getClickCount() == 2 && e.getSource() == SecurityTab.this.securityTable) {
                    SecurityTab.this.getTabAction(SecurityTab.EDIT_SECURITY_RULE_ACTION_KEY).actionPerformed(null);
                }
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        public void mouseReleased(MouseEvent e) {
            try {
                if (e.isPopupTrigger()) {
                    this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
                }
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        public void mousePressed(MouseEvent e) {
            try {
                Component source;
                if (SwingUtilities.isRightMouseButton(e) && (source = (Component)e.getSource()) == SecurityTab.this.securityTable) {
                    Point p = e.getPoint();
                    int row = SecurityTab.this.securityTable.rowAtPoint(p);
                    int column = SecurityTab.this.securityTable.columnAtPoint(p);
                    SecurityTab.this.securityTable.changeSelection(row, column, false, false);
                }
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == SecurityTab.this.securityTable || source == SecurityTab.this.securityTableScrollPane) {
                SecurityTab.this.securityPopup.show(source, x, y);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            try {
                SecurityTab.this.refreshTabActions();
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }
}

