/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import java.util.Comparator;
import phex.common.format.NumberFormatUtils;
import phex.common.format.TimeFormatUtils;
import phex.event.NetworkHostsChangeListener;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.comparator.HostAddressComparator;
import phex.gui.renderer.HostAddressCellRenderer;
import phex.host.Host;
import phex.host.HostInfo;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.utils.Localizer;

public class NetworkTableModel
extends FWSortableTableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int VENDOR_COLUMN_ID = 1002;
    public static final int TYPE_COLUMN_ID = 1003;
    public static final int RECEIVED_DROPPED_COLUMN_ID = 1004;
    public static final int SENT_QUEUED_COLUMN_ID = 1005;
    public static final int SHARED_COLUMN_ID = 1007;
    public static final int UPTIME_COLUMN_ID = 1008;
    public static final int STATUS_COLUMN_ID = 1009;
    public static final int MODE_COLUMN_ID = 1010;
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int TYPE_MODEL_INDEX = 2;
    public static final int MODE_MODEL_INDEX = 3;
    public static final int RECEIVED_DROPPED_MODEL_INDEX = 4;
    public static final int SENT_QUEUED_MODEL_INDEX = 5;
    public static final int SHARED_MODEL_INDEX = 6;
    public static final int UPTIME_MODEL_INDEX = 7;
    public static final int STATUS_MODEL_INDEX = 8;
    private static String[] tableColumns = new String[]{Localizer.getString("RemoteHost"), Localizer.getString("Vendor"), Localizer.getString("Type"), Localizer.getString("Mode"), Localizer.getString("ReceivedDropped"), Localizer.getString("SentQueuedDropped"), Localizer.getString("Shared"), Localizer.getString("Uptime"), Localizer.getString("Status")};
    private static Class[] tableClasses = new Class[]{HostAddressCellRenderer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private NetworkHostsContainer hostsContainer;

    public NetworkTableModel() {
        super(tableColumns, tableClasses);
        HostManager hostMgr = HostManager.getInstance();
        this.hostsContainer = hostMgr.getNetworkHostsContainer();
        this.hostsContainer.addNetworkHostsChangeListener(new NetworkHostsListener());
    }

    public int getRowCount() {
        return this.hostsContainer.getNetworkHostCount();
    }

    public Object getValueAt(int row, int col) {
        Host host = this.hostsContainer.getNetworkHostAt(row);
        if (host == null) {
            this.fireTableRowsDeleted(row, row);
            return "";
        }
        switch (col) {
            case 0: {
                return host.getHostAddress();
            }
            case 1: {
                return host.getVendor();
            }
            case 2: {
                Object[] args = new Object[]{host.getType()};
                return Localizer.getFormatedString("HostType", args);
            }
            case 3: {
                if (!host.isConnected()) {
                    return "";
                }
                if (host.isUltrapeer()) {
                    String mode = Localizer.getString("Ultrapeer");
                    if (host.getPushProxyAddress() != null) {
                        mode = mode + " (PP)";
                    }
                    return mode;
                }
                if (host.isUltrapeerLeafConnection()) {
                    return Localizer.getString("Leaf");
                }
                return Localizer.getString("Peer");
            }
            case 4: {
                return String.valueOf(host.getReceivedCount() + " (" + String.valueOf(host.getDropCount()) + ")");
            }
            case 5: {
                return String.valueOf(host.getSentCount()) + " / " + String.valueOf(host.getSendQueueLength()) + " / " + String.valueOf(host.getSendDropCount());
            }
            case 6: {
                if (host.getFileCount() == -1L) {
                    return "";
                }
                return host.getFileCount() + "/" + NumberFormatUtils.formatSignificantByteSize(host.getTotalSize() * 1024L);
            }
            case 7: {
                long upSeconds = host.getConnectionUpTime(System.currentTimeMillis()) / 1000L;
                return TimeFormatUtils.formatSignificantElapsedTime(upSeconds);
            }
            case 8: {
                return HostInfo.getHostStatusString(host);
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 0: {
                return new HostAddressComparator();
            }
        }
        return null;
    }

    public Object getComparableValueAt(int row, int column) {
        switch (column) {
            case 7: {
                Host host = this.hostsContainer.getNetworkHostAt(row);
                if (host == null) {
                    return new Long(Long.MIN_VALUE);
                }
                return host.getConnectionUpTimeObject(System.currentTimeMillis());
            }
        }
        return this.getValueAt(row, column);
    }

    public int mapColumnIDToModelIndex(int columnId) {
        switch (columnId) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1010: {
                return 3;
            }
            case 1004: {
                return 4;
            }
            case 1005: {
                return 5;
            }
            case 1007: {
                return 6;
            }
            case 1008: {
                return 7;
            }
            case 1009: {
                return 8;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int columnID) {
        return columnID != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] columnIds = new int[]{1001, 1002, 1003, 1010, 1004, 1005, 1007, 1008, 1009};
        return columnIds;
    }

    private class NetworkHostsListener
    implements NetworkHostsChangeListener {
        private NetworkHostsListener() {
        }

        public void networkHostChanged(int position) {
            NetworkTableModel.this.fireTableRowsUpdated(position, position);
        }

        public void networkHostAdded(int position) {
            NetworkTableModel.this.fireTableRowsInserted(position, position);
        }

        public void networkHostRemoved(int position) {
            NetworkTableModel.this.fireTableRowsDeleted(position, position);
        }
    }
}

