/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.AbstractListModel;
import phex.event.BookmarkedHostsChangeListener;
import phex.host.FavoriteHost;
import phex.host.FavoritesContainer;
import phex.host.HostManager;

public class FavoritesListModel
extends AbstractListModel {
    private FavoritesContainer favoritesContainer;

    public FavoritesListModel() {
        HostManager hostMgr = HostManager.getInstance();
        this.favoritesContainer = hostMgr.getFavoritesContainer();
        this.favoritesContainer.addBookmarkedHostsChangeListener(new FavoritesListener());
    }

    public int getSize() {
        return this.favoritesContainer.getBookmarkedHostsCount();
    }

    public Object getElementAt(int row) {
        FavoriteHost host = this.favoritesContainer.getBookmarkedHostAt(row);
        if (host == null) {
            this.fireIntervalRemoved(this, row, row);
            return "";
        }
        return host;
    }

    private class FavoritesListener
    implements BookmarkedHostsChangeListener {
        private FavoritesListener() {
        }

        public void bookmarkedHostAdded(int position) {
            FavoritesListModel.this.fireIntervalAdded(this, position, position);
        }

        public void bookmarkedHostRemoved(int position) {
            FavoritesListModel.this.fireIntervalRemoved(this, position, position);
        }
    }
}

