/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import phex.common.ServiceManager;
import phex.common.address.AddressUtils;
import phex.common.address.IpAddress;
import phex.connection.NetworkManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IPTextField;
import phex.gui.common.IntegerTextField;
import phex.gui.common.PlainMultiLinePanel;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class ProxyPane
extends OptionsSettingsPane {
    private static final String EXPORT_IP_KEY = "ExportIP";
    private static final String SOCKS5_PROXY_PORT_KEY = "SOCKS5ProxyPort";
    private static final String HTTP_PROXY_PORT_KEY = "HTTPProxyPort";
    private static final String EXPORT_IP_ERROR_KEY = "ExportIPError";
    private static final String WRONG_EXPORT_IP_FORMAT = "WrongExportIPFormat";
    private IPTextField exportIPTF;
    private JCheckBox socks5ProxyCkbx;
    private JLabel socks5HostLabel;
    private JTextField socks5ProxyHostTF;
    private JLabel socks5PortLabel;
    private IntegerTextField socks5ProxyPortTF;
    private JCheckBox socks5AuthenticationCkbx;
    private JLabel socks5UserLabel;
    private JTextField socks5UserNameTF;
    private JLabel socks5PasswordLabel;
    private JPasswordField socks5PasswordTF;
    private JCheckBox httpProxyCkbx;
    private PlainMultiLinePanel infoLabel;
    private JLabel httpHostLabel;
    private JTextField httpProxyHostTF;
    private JLabel httpPortLabel;
    private IntegerTextField httpProxyPortTF;

    public ProxyPane() {
        super("FirewallProxy");
    }

    protected void prepareComponent() {
        FormLayout layout = new FormLayout("10dlu, right:d, 2dlu, d, 10dlu, right:d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 6dlu, p, 3dlu, fill:d:grow, 3dlu, p, 3dlu, p, 6dlu");
        layout.setRowGroups(new int[][]{{3, 5, 9, 11, 13, 15, 21}});
        this.setLayout(layout);
        PanelBuilder builder = new PanelBuilder(layout, this);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("FirewallSettings"), cc.xywh(1, 1, 9, 1));
        builder.addLabel(Localizer.getString("ExportIPAs") + ": ", cc.xy(2, 3));
        this.exportIPTF = new IPTextField();
        this.exportIPTF.setIPString(ServiceManager.sCfg.mMyIP);
        builder.add((Component)this.exportIPTF, cc.xy(4, 3));
        builder.addSeparator(Localizer.getString("SOCKSSettings"), cc.xywh(1, 5, 9, 1));
        this.socks5ProxyCkbx = new JCheckBox(Localizer.getString("UseSocks5Proxy"), ServiceManager.sCfg.mProxyUse);
        this.socks5ProxyCkbx.addActionListener(new CheckboxActionListener());
        builder.add((Component)this.socks5ProxyCkbx, cc.xywh(2, 7, 3, 1));
        this.socks5HostLabel = builder.addLabel(Localizer.getString("ProxyHostIP") + ": ", cc.xy(2, 9));
        this.socks5ProxyHostTF = new JTextField(ServiceManager.sCfg.mProxyHost, 15);
        builder.add((Component)this.socks5ProxyHostTF, cc.xy(4, 9));
        this.socks5PortLabel = builder.addLabel(Localizer.getString("Port") + ": ", cc.xy(6, 9));
        this.socks5ProxyPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mProxyPort), 5, 5);
        builder.add((Component)this.socks5ProxyPortTF, cc.xy(8, 9));
        this.socks5AuthenticationCkbx = new JCheckBox(Localizer.getString("Authentication"), ServiceManager.sCfg.useProxyAuthentication);
        this.socks5AuthenticationCkbx.addActionListener(new CheckboxActionListener());
        builder.add((Component)this.socks5AuthenticationCkbx, cc.xywh(2, 11, 3, 1));
        this.socks5UserLabel = builder.addLabel(Localizer.getString("Username") + ": ", cc.xy(2, 13));
        this.socks5UserNameTF = new JTextField(ServiceManager.sCfg.mProxyUserName, 10);
        builder.add((Component)this.socks5UserNameTF, cc.xy(4, 13));
        this.socks5PasswordLabel = builder.addLabel(Localizer.getString("Password") + ": ", cc.xy(6, 13));
        this.socks5PasswordTF = new JPasswordField(ServiceManager.sCfg.mProxyPassword, 10);
        builder.add((Component)this.socks5PasswordTF, cc.xy(8, 13));
        builder.addSeparator(Localizer.getString("HTTPProxySettings"), cc.xywh(1, 15, 9, 1));
        this.infoLabel = new PlainMultiLinePanel(Localizer.getString("HttpProxyInfoText"));
        builder.add((Component)this.infoLabel, cc.xywh(2, 17, 8, 1));
        this.httpProxyCkbx = new JCheckBox(Localizer.getString("UseHTTPProxy"), ServiceManager.sCfg.isHttpProxyUsed);
        this.httpProxyCkbx.addActionListener(new CheckboxActionListener());
        builder.add((Component)this.httpProxyCkbx, cc.xywh(2, 19, 3, 1));
        this.httpHostLabel = builder.addLabel(Localizer.getString("ProxyHostIP") + ": ", cc.xy(2, 21));
        this.httpProxyHostTF = new JTextField(ServiceManager.sCfg.httpProxyHost, 15);
        builder.add((Component)this.httpProxyHostTF, cc.xy(4, 21));
        this.httpPortLabel = builder.addLabel(Localizer.getString("Port") + ": ", cc.xy(6, 21));
        this.httpProxyPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.httpProxyPort), 5, 5);
        builder.add((Component)this.httpProxyPortTF, cc.xy(8, 21));
        this.refreshEnableState();
    }

    public void checkInput(HashMap inputDic) {
        if (!this.exportIPTF.isFieldEmpty()) {
            if (this.exportIPTF.isInputValid()) {
                inputDic.put(EXPORT_IP_KEY, this.exportIPTF.getIP());
            } else {
                inputDic.put(EXPORT_IP_ERROR_KEY, WRONG_EXPORT_IP_FORMAT);
                this.setInputValid(inputDic, false);
                return;
            }
        }
        try {
            String socks5ProxyPortStr = this.socks5ProxyPortTF.getText();
            Integer socks5ProxyPort = new Integer(socks5ProxyPortStr);
            inputDic.put(SOCKS5_PROXY_PORT_KEY, socks5ProxyPort);
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        try {
            String httpProxyPortStr = this.httpProxyPortTF.getText();
            Integer httpProxyPort = new Integer(httpProxyPortStr);
            inputDic.put(HTTP_PROXY_PORT_KEY, httpProxyPort);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setInputValid(inputDic, true);
    }

    public void displayErrorMessage(HashMap inputDic) {
        if (inputDic.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(inputDic);
        }
        if (inputDic.containsKey(EXPORT_IP_ERROR_KEY)) {
            this.exportIPTF.requestFocus();
            GUIUtils.showErrorMessage(Localizer.getString(WRONG_EXPORT_IP_FORMAT), Localizer.getString("IPFormatError"));
        }
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        String httpProxyHost;
        String password;
        String userName;
        boolean useAuthentication;
        String proxyHost;
        boolean useSocks5Proxy;
        byte[] exportIP = (byte[])inputDic.get(EXPORT_IP_KEY);
        String exportIPStr = "";
        if (exportIP != null) {
            exportIPStr = AddressUtils.ip2string(exportIP);
        }
        if (!ServiceManager.sCfg.mMyIP.equals(exportIPStr)) {
            if (exportIP != null) {
                IpAddress ip = new IpAddress(exportIP);
                NetworkManager.getInstance().setForcedHostIP(ip);
            } else {
                NetworkManager.getInstance().setForcedHostIP(null);
            }
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.mProxyUse != (useSocks5Proxy = this.socks5ProxyCkbx.isSelected())) {
            ServiceManager.sCfg.mProxyUse = useSocks5Proxy;
            OptionsSettingsPane.triggerConfigSave(inputDic);
            GUIRegistry.getInstance().getMainFrame().setTitle();
        }
        if (!ServiceManager.sCfg.mProxyHost.equals(proxyHost = this.socks5ProxyHostTF.getText())) {
            ServiceManager.sCfg.mProxyHost = proxyHost;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        Integer proxyPortInt = (Integer)inputDic.get(SOCKS5_PROXY_PORT_KEY);
        int proxyPort = 1080;
        if (proxyPortInt != null) {
            proxyPort = proxyPortInt;
        }
        if (ServiceManager.sCfg.mProxyPort != proxyPort) {
            ServiceManager.sCfg.mProxyPort = proxyPort;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.useProxyAuthentication != (useAuthentication = this.socks5AuthenticationCkbx.isSelected())) {
            ServiceManager.sCfg.useProxyAuthentication = useAuthentication;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (!ServiceManager.sCfg.mProxyUserName.equals(userName = this.socks5UserNameTF.getText())) {
            ServiceManager.sCfg.mProxyUserName = userName;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (!ServiceManager.sCfg.mProxyPassword.equals(password = new String(this.socks5PasswordTF.getPassword()))) {
            ServiceManager.sCfg.mProxyPassword = password;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        boolean httpProxyChanged = false;
        boolean isHttpProxyUsed = this.httpProxyCkbx.isSelected();
        if (ServiceManager.sCfg.isHttpProxyUsed != isHttpProxyUsed) {
            ServiceManager.sCfg.isHttpProxyUsed = isHttpProxyUsed;
            OptionsSettingsPane.triggerConfigSave(inputDic);
            httpProxyChanged = true;
        }
        if (!ServiceManager.sCfg.httpProxyHost.equals(httpProxyHost = this.httpProxyHostTF.getText())) {
            ServiceManager.sCfg.httpProxyHost = httpProxyHost;
            OptionsSettingsPane.triggerConfigSave(inputDic);
            httpProxyChanged = true;
        }
        Integer httpProxyPortInt = (Integer)inputDic.get(HTTP_PROXY_PORT_KEY);
        int httpProxyPort = 80;
        if (httpProxyPortInt != null) {
            httpProxyPort = httpProxyPortInt;
        }
        if (ServiceManager.sCfg.httpProxyPort != httpProxyPort) {
            ServiceManager.sCfg.httpProxyPort = httpProxyPort;
            OptionsSettingsPane.triggerConfigSave(inputDic);
            httpProxyChanged = true;
        }
        if (httpProxyChanged) {
            ServiceManager.sCfg.updateSystemSettings();
        }
    }

    private void refreshEnableState() {
        boolean isBehindFirewallSelected = true;
        this.socks5ProxyCkbx.setEnabled(isBehindFirewallSelected);
        boolean isSocks5ProxySelected = this.socks5ProxyCkbx.isSelected();
        this.socks5HostLabel.setEnabled(isBehindFirewallSelected && isSocks5ProxySelected);
        this.socks5ProxyHostTF.setEnabled(isBehindFirewallSelected && isSocks5ProxySelected);
        this.socks5PortLabel.setEnabled(isBehindFirewallSelected && isSocks5ProxySelected);
        this.socks5ProxyPortTF.setEnabled(isBehindFirewallSelected && isSocks5ProxySelected);
        this.socks5AuthenticationCkbx.setEnabled(isBehindFirewallSelected && isSocks5ProxySelected);
        this.socks5UserLabel.setEnabled(isBehindFirewallSelected && isSocks5ProxySelected && this.socks5AuthenticationCkbx.isSelected());
        this.socks5UserNameTF.setEnabled(isBehindFirewallSelected && isSocks5ProxySelected && this.socks5AuthenticationCkbx.isSelected());
        this.socks5PasswordLabel.setEnabled(isBehindFirewallSelected && isSocks5ProxySelected && this.socks5AuthenticationCkbx.isSelected());
        this.socks5PasswordTF.setEnabled(isBehindFirewallSelected && isSocks5ProxySelected && this.socks5AuthenticationCkbx.isSelected());
        this.httpHostLabel.setEnabled(this.httpProxyCkbx.isSelected());
        this.httpProxyHostTF.setEnabled(this.httpProxyCkbx.isSelected());
        this.httpPortLabel.setEnabled(this.httpProxyCkbx.isSelected());
        this.httpProxyPortTF.setEnabled(this.httpProxyCkbx.isSelected());
    }

    class CheckboxActionListener
    implements ActionListener {
        CheckboxActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ProxyPane.this.refreshEnableState();
        }
    }
}

