/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class NetworkPane
extends OptionsSettingsPane {
    private static final String LISTENING_PORT_KEY = "ListeningPort";
    private static final String LISTENING_PORT_EXCESS_ERROR_KEY = "ListeningPortExcessErrorKey";
    private static final String CONNECTION_TIMEOUT_KEY = "ConnectionTimeout";
    private static final String UP_2_UP_CONNECTIONS_KEY = "UP2UPConnections";
    private static final String UP_2_LEAF_CONNECTIONS_KEY = "UP2LeafConnections";
    private static final String LEAF_2_UP_CONNECTIONS_KEY = "Leaf2UPConnections";
    private static final String LEAF_2_UP_CONNECTIONS_EXCESS_ERROR_KEY = "Leaf2UPConnectionsExcessErrorKey";
    private static final String MAX_CONCURRENT_CONNECT_ATTEMPTS_KEY = "MaxConcurrentConnectAttempts";
    private IntegerTextField listeningPortTF;
    private IntegerTextField connectionTimeoutTF;
    private IntegerTextField maxConcurrentConnectAttemptsTF;
    private JCheckBox autoConnectChkbx;
    private JCheckBox connectedToLANChkbx;
    private JCheckBox allowToBeUPChkbx;
    private JCheckBox forceToBeUPChkbx;
    private JLabel up2upConnectionsLabel;
    private IntegerTextField up2upConnectionsTF;
    private JLabel up2LeafConnectionsLabel;
    private IntegerTextField up2LeafConnectionsTF;
    private JLabel leaf2upConnectionsLabel;
    private IntegerTextField leaf2upConnectionsTF;

    public NetworkPane() {
        super("Network");
    }

    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        this.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("10dlu, right:d, 2dlu, d, 10dlu, right:d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 8dlu, p, 3dlu, p, 3dlu, p, 8dlu, p, 3dlu, p");
        layout.setColumnGroups(new int[][]{{4, 8}, {2, 6}});
        layout.setRowGroups(new int[][]{{3, 5, 9, 11, 13, 17}});
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        builder.addSeparator(Localizer.getString("NetworkSettings"), cc.xywh(1, row, 9, 1));
        builder.addLabel(Localizer.getString(LISTENING_PORT_KEY) + ": ", cc.xy(2, row += 2));
        this.listeningPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mListeningPort), 5, 5);
        builder.add((Component)this.listeningPortTF, cc.xy(4, row));
        builder.addLabel(Localizer.getString(CONNECTION_TIMEOUT_KEY) + ": ", cc.xy(6, row));
        this.connectionTimeoutTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetConnectionTimeout / 1000), 3, 3);
        builder.add((Component)this.connectionTimeoutTF, cc.xy(8, row));
        JLabel label = builder.addLabel(Localizer.getString("NetworkSettings_MaxConcurrentConnectAttempts") + ": ", cc.xy(6, row += 2));
        label.setToolTipText(Localizer.getString("NetworkSettings_TTTMaxConcurrentConnectAttempts"));
        this.maxConcurrentConnectAttemptsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxConcurrentConnectAttempts), 2, 2);
        this.maxConcurrentConnectAttemptsTF.setToolTipText(Localizer.getString("NetworkSettings_TTTMaxConcurrentConnectAttempts"));
        builder.add((Component)this.maxConcurrentConnectAttemptsTF, cc.xy(8, row));
        this.autoConnectChkbx = new JCheckBox(Localizer.getString("AutoConnectOnStartup"), ServiceManager.sCfg.mAutoConnect);
        builder.add((Component)this.autoConnectChkbx, cc.xywh(2, row += 2, 3, 1));
        this.connectedToLANChkbx = new JCheckBox(Localizer.getString("ConnectedToLAN"), ServiceManager.sCfg.connectedToLAN);
        this.connectedToLANChkbx.setToolTipText(Localizer.getString("TTTConnectedToLAN"));
        builder.add((Component)this.connectedToLANChkbx, cc.xywh(6, row, 3, 1));
        builder.addSeparator(Localizer.getString("UltrapeerSettings"), cc.xywh(1, row += 2, 9, 1));
        this.allowToBeUPChkbx = new JCheckBox(Localizer.getString("AllowToBecomeUltrapeer"), ServiceManager.sCfg.allowToBecomeUP);
        this.allowToBeUPChkbx.setToolTipText(Localizer.getString("TTTAllowToBecomeUltrapeer"));
        this.allowToBeUPChkbx.addActionListener(new CheckboxActionListener());
        builder.add((Component)this.allowToBeUPChkbx, cc.xywh(2, row += 2, 3, 1));
        this.forceToBeUPChkbx = new JCheckBox(Localizer.getString("ForceToBeUltrapeer"), ServiceManager.sCfg.forceToBeUltrapeer);
        this.forceToBeUPChkbx.setToolTipText(Localizer.getString("TTTForceToBeUltrapeer"));
        this.forceToBeUPChkbx.addActionListener(new CheckboxActionListener());
        builder.add((Component)this.forceToBeUPChkbx, cc.xywh(6, row, 3, 1));
        this.up2upConnectionsLabel = builder.addLabel(Localizer.getString("ConnectionsToUltrapeers") + ": ", cc.xy(2, row += 2));
        this.up2upConnectionsLabel.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        this.up2upConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.up2upConnections), 2, 2);
        this.up2upConnectionsTF.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        builder.add((Component)this.up2upConnectionsTF, cc.xy(4, row));
        this.up2LeafConnectionsLabel = builder.addLabel(Localizer.getString("ConnectionsToLeafs") + ": ", cc.xy(6, row));
        this.up2LeafConnectionsLabel.setToolTipText(Localizer.getString("TTTToLeafs"));
        this.up2LeafConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.up2leafConnections), 2, 2);
        this.up2LeafConnectionsTF.setToolTipText(Localizer.getString("TTTToLeafs"));
        builder.add((Component)this.up2LeafConnectionsTF, cc.xy(8, row));
        builder.addSeparator(Localizer.getString("LeafSettings"), cc.xywh(1, row += 2, 9, 1));
        this.leaf2upConnectionsLabel = builder.addLabel(Localizer.getString("ConnectionsToUltrapeers") + ": ", cc.xy(2, row += 2));
        this.leaf2upConnectionsLabel.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        this.leaf2upConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.leaf2upConnections), 2, 1);
        this.leaf2upConnectionsTF.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        builder.add((Component)this.leaf2upConnectionsTF, cc.xy(4, row));
        this.refreshEnableState();
    }

    public void checkInput(HashMap inputDic) {
        try {
            String listeningPortStr = this.listeningPortTF.getText();
            Integer listeningPort = new Integer(listeningPortStr);
            if (listeningPort > 65500) {
                inputDic.put(LISTENING_PORT_EXCESS_ERROR_KEY, this.listeningPortTF);
                this.setInputValid(inputDic, false);
                return;
            }
            inputDic.put(LISTENING_PORT_KEY, listeningPort);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.listeningPortTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String connTimeoutStr = this.connectionTimeoutTF.getText();
            Integer connTimeout = new Integer(connTimeoutStr);
            inputDic.put(CONNECTION_TIMEOUT_KEY, connTimeout);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.connectionTimeoutTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String up2upConnStr = this.up2upConnectionsTF.getText();
            Integer up2upConn = new Integer(up2upConnStr);
            inputDic.put(UP_2_UP_CONNECTIONS_KEY, up2upConn);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.up2upConnectionsTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String up2leafConnStr = this.up2LeafConnectionsTF.getText();
            Integer up2leafConn = new Integer(up2leafConnStr);
            inputDic.put(UP_2_LEAF_CONNECTIONS_KEY, up2leafConn);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.up2LeafConnectionsTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String leaf2upConnStr = this.leaf2upConnectionsTF.getText();
            Integer leaf2upConn = new Integer(leaf2upConnStr);
            if (leaf2upConn > 5) {
                inputDic.put(LEAF_2_UP_CONNECTIONS_EXCESS_ERROR_KEY, this.leaf2upConnectionsTF);
                this.setInputValid(inputDic, false);
                return;
            }
            inputDic.put(LEAF_2_UP_CONNECTIONS_KEY, leaf2upConn);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.leaf2upConnectionsTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String maxConcurrentConnectAttemptsStr = this.maxConcurrentConnectAttemptsTF.getText();
            Integer maxConcurrentConnectAttempts = new Integer(maxConcurrentConnectAttemptsStr);
            inputDic.put(MAX_CONCURRENT_CONNECT_ATTEMPTS_KEY, maxConcurrentConnectAttempts);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.maxConcurrentConnectAttemptsTF);
            this.setInputValid(inputDic, false);
            return;
        }
        this.setInputValid(inputDic, true);
    }

    public void displayErrorMessage(HashMap inputDic) {
        if (inputDic.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(inputDic);
        } else if (inputDic.containsKey(LEAF_2_UP_CONNECTIONS_EXCESS_ERROR_KEY)) {
            this.leaf2upConnectionsTF.setText(String.valueOf(5));
            this.leaf2upConnectionsTF.requestFocus();
            this.leaf2upConnectionsTF.selectAll();
            JOptionPane.showMessageDialog(this, Localizer.getFormatedString("NetworkSettings_Leaf2UpLimitExceeded", new Object[]{new Integer(5)}), Localizer.getString("NetworkSettings_LimitExceeded"), 0);
        } else if (inputDic.containsKey(LISTENING_PORT_EXCESS_ERROR_KEY)) {
            this.listeningPortTF.setText(String.valueOf(ServiceManager.sCfg.mListeningPort));
            this.listeningPortTF.requestFocus();
            this.listeningPortTF.selectAll();
            JOptionPane.showMessageDialog(this, Localizer.getString("NetworkSettings_ListeningPortLimitExceeded"), Localizer.getString("NetworkSettings_LimitExceeded"), 0);
        }
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        Integer maxConcurrentConnectAttemptsInt;
        int maxConcurrentConnectAttempts;
        Integer leaf2upConnectionsInt;
        int leaf2upConnections;
        Integer up2leafConnectionsInt;
        int up2leafConnections;
        Integer up2upConnectionsInt;
        int up2upConnections;
        boolean forceToBeUP;
        boolean allowToBeUP;
        boolean connectedToLAN;
        boolean autoConnect;
        Integer connectionTimeoutInt;
        int connectionTimeout;
        Integer listeningPortInt = (Integer)inputDic.get(LISTENING_PORT_KEY);
        int listeningPort = listeningPortInt;
        if (ServiceManager.sCfg.mListeningPort != listeningPort) {
            ServiceManager.sCfg.mListeningPort = listeningPort;
            OptionsSettingsPane.triggerConfigSave(inputDic);
            try {
                NetworkManager.getInstance().restartServer();
            }
            catch (Exception e) {
                GUIUtils.showErrorMessage(Localizer.getString("FailedToListenOnNewPort"), Localizer.getString("ListenerError"));
            }
        }
        if (ServiceManager.sCfg.mNetConnectionTimeout != (connectionTimeout = (connectionTimeoutInt = (Integer)inputDic.get(CONNECTION_TIMEOUT_KEY)) * 1000)) {
            ServiceManager.sCfg.mNetConnectionTimeout = connectionTimeout;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.mAutoConnect != (autoConnect = this.autoConnectChkbx.isSelected())) {
            ServiceManager.sCfg.mAutoConnect = autoConnect;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.connectedToLAN != (connectedToLAN = this.connectedToLANChkbx.isSelected())) {
            ServiceManager.sCfg.connectedToLAN = connectedToLAN;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.allowToBecomeUP != (allowToBeUP = this.allowToBeUPChkbx.isSelected())) {
            ServiceManager.sCfg.allowToBecomeUP = allowToBeUP;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.forceToBeUltrapeer != (forceToBeUP = this.forceToBeUPChkbx.isSelected())) {
            ServiceManager.sCfg.forceToBeUltrapeer = forceToBeUP;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.up2upConnections != (up2upConnections = (up2upConnectionsInt = (Integer)inputDic.get(UP_2_UP_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.up2upConnections = up2upConnections;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.up2leafConnections != (up2leafConnections = (up2leafConnectionsInt = (Integer)inputDic.get(UP_2_LEAF_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.up2leafConnections = up2leafConnections;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.leaf2upConnections != (leaf2upConnections = (leaf2upConnectionsInt = (Integer)inputDic.get(LEAF_2_UP_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.leaf2upConnections = leaf2upConnections;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.maxConcurrentConnectAttempts != (maxConcurrentConnectAttempts = (maxConcurrentConnectAttemptsInt = (Integer)inputDic.get(MAX_CONCURRENT_CONNECT_ATTEMPTS_KEY)).intValue())) {
            ServiceManager.sCfg.maxConcurrentConnectAttempts = maxConcurrentConnectAttempts;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
    }

    private void refreshEnableState() {
        this.up2LeafConnectionsLabel.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2LeafConnectionsTF.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2upConnectionsLabel.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2upConnectionsTF.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.forceToBeUPChkbx.setEnabled(this.allowToBeUPChkbx.isSelected());
    }

    class CheckboxActionListener
    implements ActionListener {
        CheckboxActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            NetworkPane.this.refreshEnableState();
        }
    }
}

