/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import phex.common.ServiceManager;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class DownloadPane
extends OptionsSettingsPane {
    private static final String WORKER_PER_DOWNLOAD_KEY = "WorkerPerDownload";
    private static final String MAX_TOTAL_WORKER_KEY = "TotalWorker";
    private static final String PUSH_TIMEOUT_KEY = "PushTimeout";
    private static final String INITIAL_SEGMENT_SIZE_KEY = "InitialSegmentSize";
    private static final String SEGMENT_TRANSFER_TIME_KEY = "SegmentTransferTime";
    private IntegerTextField totalWorkersTF;
    private IntegerTextField workerPerDownloadTF;
    private IntegerTextField pushTimeoutTF;
    private IntegerTextField initialSegmentSizeTF;
    private IntegerTextField segmentTransferTimeTF;
    private JCheckBox readoutMagmasChkbx;
    private JCheckBox removeCompletedDownloadsChkbx;
    private JCheckBox enableHitSnoopingChkbx;

    public DownloadPane() {
        super("Download");
    }

    protected void prepareComponent() {
        FormLayout layout = new FormLayout("10dlu, right:d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        layout.setRowGroups(new int[][]{{3, 5, 7, 9, 11, 13, 15, 17}});
        this.setLayout(layout);
        PanelBuilder builder = new PanelBuilder(layout, this);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("GeneralDownloadSettings"), cc.xywh(1, 1, 5, 1));
        JLabel label = builder.addLabel(Localizer.getString("DownloadSettings_TotalParallelDownloads") + ": ", cc.xy(2, 3));
        label.setToolTipText(Localizer.getString("DownloadSettings_TTTTotalParallelDownloads"));
        this.totalWorkersTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxTotalDownloadWorker), 6, 2);
        this.totalWorkersTF.setToolTipText(Localizer.getString("DownloadSettings_TTTTotalParallelDownloads"));
        builder.add((Component)this.totalWorkersTF, cc.xy(4, 3));
        label = builder.addLabel(Localizer.getString("DownloadSettings_ParallelDownloadsPerFile") + ": ", cc.xy(2, 5));
        label.setToolTipText(Localizer.getString("DownloadSettings_TTTParallelDownloadsPerFile"));
        this.workerPerDownloadTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxWorkerPerDownload), 6, 2);
        this.workerPerDownloadTF.setToolTipText(Localizer.getString("DownloadSettings_TTTParallelDownloadsPerFile"));
        builder.add((Component)this.workerPerDownloadTF, cc.xy(4, 5));
        label = builder.addLabel(Localizer.getString("DownloadSettings_InitialSegmentSizeKb") + ": ", cc.xy(2, 7));
        label.setToolTipText(Localizer.getString("DownloadSettings_TTTInitialSegmentSizeKb"));
        this.initialSegmentSizeTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.initialSegmentSize / 1024), 6, 4);
        this.initialSegmentSizeTF.setToolTipText(Localizer.getString("DownloadSettings_TTTInitialSegmentSizeKb"));
        builder.add((Component)this.initialSegmentSizeTF, cc.xy(4, 7));
        label = builder.addLabel(Localizer.getString("DownloadSettings_SegmentTransferTimeSec") + ": ", cc.xy(2, 9));
        label.setToolTipText(Localizer.getString("DownloadSettings_TTTSegmentTransferTimeSec"));
        this.segmentTransferTimeTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.segmentTransferTime), 6, 3);
        this.segmentTransferTimeTF.setToolTipText(Localizer.getString("DownloadSettings_TTTSegmentTransferTimeSec"));
        builder.add((Component)this.segmentTransferTimeTF, cc.xy(4, 9));
        builder.addLabel(Localizer.getString(PUSH_TIMEOUT_KEY) + ": ", cc.xy(2, 11));
        this.pushTimeoutTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mPushTransferTimeout / 1000), 6, 3);
        builder.add((Component)this.pushTimeoutTF, cc.xy(4, 11));
        this.readoutMagmasChkbx = new JCheckBox(Localizer.getString("DownloadSettings_ReadoutDownloadedMagmas"), ServiceManager.sCfg.autoReadoutDownloadedMagma);
        this.readoutMagmasChkbx.setToolTipText(Localizer.getString("DownloadSettings_TTTReadoutDownloadedMagmas"));
        builder.add((Component)this.readoutMagmasChkbx, cc.xywh(2, 13, 4, 1));
        this.removeCompletedDownloadsChkbx = new JCheckBox(Localizer.getString("DownloadSettings_AutoRemoveCompletedDownloads"), ServiceManager.sCfg.mDownloadAutoRemoveCompleted);
        this.removeCompletedDownloadsChkbx.setToolTipText(Localizer.getString("DownloadSettings_TTTAutoRemoveCompletedDownloads"));
        builder.add((Component)this.removeCompletedDownloadsChkbx, cc.xywh(2, 15, 4, 1));
        this.enableHitSnoopingChkbx = new JCheckBox(Localizer.getString("DownloadSettings_EnableHitSnooping"), ServiceManager.sCfg.enableHitSnooping);
        this.enableHitSnoopingChkbx.setToolTipText(Localizer.getString("DownloadSettings_TTTEnableHitSnooping"));
        builder.add((Component)this.enableHitSnoopingChkbx, cc.xywh(2, 17, 4, 1));
        this.initConfigValues();
        this.refreshEnableState();
    }

    public void checkInput(HashMap inputDic) {
        try {
            String workerPerDownloadStr = this.workerPerDownloadTF.getText();
            Short workerPerDownload = new Short(workerPerDownloadStr);
            inputDic.put(WORKER_PER_DOWNLOAD_KEY, workerPerDownload);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.workerPerDownloadTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String totalWorkersStr = this.totalWorkersTF.getText();
            Short totalWorkers = new Short(totalWorkersStr);
            inputDic.put(MAX_TOTAL_WORKER_KEY, totalWorkers);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.totalWorkersTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String initialSegmentSizeStr = this.initialSegmentSizeTF.getText();
            Short initialSegmentSize = new Short(initialSegmentSizeStr);
            inputDic.put(INITIAL_SEGMENT_SIZE_KEY, initialSegmentSize);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.initialSegmentSizeTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String segmentTransferTimeStr = this.segmentTransferTimeTF.getText();
            Short segmentTransferTime = new Short(segmentTransferTimeStr);
            inputDic.put(SEGMENT_TRANSFER_TIME_KEY, segmentTransferTime);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.segmentTransferTimeTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String pushTimeoutStr = this.pushTimeoutTF.getText();
            Integer pushTimeout = new Integer(pushTimeoutStr);
            inputDic.put(PUSH_TIMEOUT_KEY, pushTimeout);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.pushTimeoutTF);
            this.setInputValid(inputDic, false);
            return;
        }
        this.setInputValid(inputDic, true);
    }

    public void displayErrorMessage(HashMap inputDic) {
        if (inputDic.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(inputDic);
        }
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        boolean enableHitSnooping;
        boolean removeCompletedDownloads;
        boolean readoutMagmas;
        Integer pushTimeoutInt;
        int pushTimeout;
        Short maxWorkerPerDownloadInt;
        short maxWorkerPerDownload;
        Short segmentTransferTimeInt;
        short segmentTransferTime;
        Short initialSegmentSizeInt;
        short initialSegmentSize;
        Short totalWorkerInt = (Short)inputDic.get(MAX_TOTAL_WORKER_KEY);
        short totalWorker = totalWorkerInt;
        if (ServiceManager.sCfg.maxTotalDownloadWorker != totalWorker) {
            ServiceManager.sCfg.maxTotalDownloadWorker = totalWorker;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.initialSegmentSize != (initialSegmentSize = (initialSegmentSizeInt = (Short)inputDic.get(INITIAL_SEGMENT_SIZE_KEY)).shortValue()) * 1024) {
            ServiceManager.sCfg.initialSegmentSize = initialSegmentSize * 1024;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.segmentTransferTime != (segmentTransferTime = (segmentTransferTimeInt = (Short)inputDic.get(SEGMENT_TRANSFER_TIME_KEY)).shortValue())) {
            ServiceManager.sCfg.segmentTransferTime = segmentTransferTime;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.maxWorkerPerDownload != (maxWorkerPerDownload = (maxWorkerPerDownloadInt = (Short)inputDic.get(WORKER_PER_DOWNLOAD_KEY)).shortValue())) {
            ServiceManager.sCfg.maxWorkerPerDownload = maxWorkerPerDownload;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.mPushTransferTimeout != (pushTimeout = (pushTimeoutInt = (Integer)inputDic.get(PUSH_TIMEOUT_KEY)).intValue()) * 1000) {
            ServiceManager.sCfg.mPushTransferTimeout = pushTimeout * 1000;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.autoReadoutDownloadedMagma != (readoutMagmas = this.readoutMagmasChkbx.isSelected())) {
            ServiceManager.sCfg.mDownloadAutoRemoveCompleted = readoutMagmas;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.mDownloadAutoRemoveCompleted != (removeCompletedDownloads = this.removeCompletedDownloadsChkbx.isSelected())) {
            ServiceManager.sCfg.mDownloadAutoRemoveCompleted = removeCompletedDownloads;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.enableHitSnooping != (enableHitSnooping = this.enableHitSnoopingChkbx.isSelected())) {
            ServiceManager.sCfg.enableHitSnooping = enableHitSnooping;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
    }

    private void refreshEnableState() {
    }

    private void initConfigValues() {
    }
}

