/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import phex.common.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class DisplayPromptsPane
extends OptionsSettingsPane {
    private GUIRegistry guiRegistry = GUIRegistry.getInstance();
    private JCheckBox showCloseOptionsChkbx;
    private JCheckBox showBetaUpdateNotificationChkbx;
    private JCheckBox showCopyrightLawsWarningChkbx;

    public DisplayPromptsPane() {
        super("PromptSettings_Prompts");
    }

    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        this.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("10dlu, d, 6dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p");
        layout.setRowGroups(new int[][]{{3, 5}});
        contentPanel.setLayout(layout);
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("PromptSettings_PromptSettings"), cc.xywh(1, 1, 5, 1));
        this.showCloseOptionsChkbx = new JCheckBox(Localizer.getString("PromptSettings_ClosePhexOptions"), ServiceManager.sCfg.showCloseOptionsDialog);
        this.showCloseOptionsChkbx.setToolTipText(Localizer.getString("PromptSettings_TTTClosePhexOptions"));
        builder.add((Component)this.showCloseOptionsChkbx, cc.xy(2, 3));
        this.showBetaUpdateNotificationChkbx = new JCheckBox(Localizer.getString("PromptSettings_NotifyOnNewBeta"), ServiceManager.sCfg.showBetaUpdateNotification);
        this.showBetaUpdateNotificationChkbx.setToolTipText(Localizer.getString("PromptSettings_TTTNotifyOnNewBeta"));
        builder.add((Component)this.showBetaUpdateNotificationChkbx, cc.xy(2, 5));
        this.showCopyrightLawsWarningChkbx = new JCheckBox(Localizer.getString("PromptSettings_RespectCopyrightNotice"), this.guiRegistry.isRespectCopyrightNoticeShown());
        this.showCopyrightLawsWarningChkbx.setToolTipText(Localizer.getString("PromptSettings_TTTRespectCopyrightNotice"));
        builder.add((Component)this.showCopyrightLawsWarningChkbx, cc.xy(2, 7));
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        boolean betaUpdateNotify;
        boolean closeOptions = this.showCloseOptionsChkbx.isSelected();
        if (ServiceManager.sCfg.showCloseOptionsDialog != closeOptions) {
            ServiceManager.sCfg.showCloseOptionsDialog = closeOptions;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        if (ServiceManager.sCfg.showBetaUpdateNotification != (betaUpdateNotify = this.showBetaUpdateNotificationChkbx.isSelected())) {
            ServiceManager.sCfg.showBetaUpdateNotification = betaUpdateNotify;
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        boolean showCopyrightWarning = this.showCopyrightLawsWarningChkbx.isSelected();
        if (this.guiRegistry.isRespectCopyrightNoticeShown() != showCopyrightWarning) {
            this.guiRegistry.setRespectCopyrightNoticeShown(showCopyrightWarning);
        }
    }
}

