/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phex.common.ServiceManager;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;
import phex.utils.Logger;

public class DebugPane
extends OptionsSettingsPane {
    private JComboBox logLevelCbBx;
    private JCheckBox performanceTypeChkbx;
    private JCheckBox guiTypeChkbx;
    private JCheckBox netTypeChkbx;
    private JCheckBox searchTypeChkbx;
    private JCheckBox uploadTypeChkbx;
    private JCheckBox downloadTypeChkbx;
    private JCheckBox downloadNetTypeChkbx;

    public DebugPane() {
        super("DebugSettings_Debug");
    }

    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        this.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("10dlu, d, 6dlu, d, 6dlu, d, 6dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        layout.setColumnGroups(new int[][]{{2, 4, 6}});
        layout.setRowGroups(new int[][]{{3, 5, 7}});
        contentPanel.setLayout(layout);
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("DebugSettings_DebugSettings"), cc.xywh(1, 1, 7, 1));
        this.downloadTypeChkbx = new JCheckBox(Localizer.getString("Download"), Logger.isTypeLogged((short)2));
        this.downloadTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTDownloadType"));
        builder.add((Component)this.downloadTypeChkbx, cc.xy(2, 3));
        this.uploadTypeChkbx = new JCheckBox(Localizer.getString("Upload"), Logger.isTypeLogged((short)4));
        this.uploadTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTUploadType"));
        builder.add((Component)this.uploadTypeChkbx, cc.xy(4, 3));
        this.searchTypeChkbx = new JCheckBox(Localizer.getString("Search"), Logger.isTypeLogged((short)8));
        this.searchTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTSearchType"));
        builder.add((Component)this.searchTypeChkbx, cc.xy(6, 3));
        this.downloadNetTypeChkbx = new JCheckBox(Localizer.getString("DownloadNet"), Logger.isTypeLogged((short)128));
        this.downloadNetTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTDownloadNetType"));
        builder.add((Component)this.downloadNetTypeChkbx, cc.xy(8, 3));
        this.netTypeChkbx = new JCheckBox(Localizer.getString("Network"), Logger.isTypeLogged((short)16));
        this.netTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTNetworkType"));
        builder.add((Component)this.netTypeChkbx, cc.xy(2, 5));
        this.guiTypeChkbx = new JCheckBox(Localizer.getString("GUI"), Logger.isTypeLogged((short)32));
        this.guiTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTGuiType"));
        builder.add((Component)this.guiTypeChkbx, cc.xy(4, 5));
        this.performanceTypeChkbx = new JCheckBox(Localizer.getString("Performance"), Logger.isTypeLogged((short)64));
        this.performanceTypeChkbx.setToolTipText(Localizer.getString("DebugSettings_TTTPerformanceType"));
        builder.add((Component)this.performanceTypeChkbx, cc.xy(6, 5));
        JLabel label = builder.addLabel(Localizer.getString("DebugSettings_LogLevel") + ": ", cc.xy(2, 7));
        label.setToolTipText(Localizer.getString("DebugSettings_TTTLogLevel"));
        String[] logLevels = new String[]{"Finest", "Finer", "Fine", "Config", "Info", "Warning", "Severe"};
        this.logLevelCbBx = new JComboBox<String>(logLevels);
        this.logLevelCbBx.setSelectedIndex(Logger.getVerboseLevel());
        this.logLevelCbBx.setToolTipText(Localizer.getString("DebugSettings_TTTLogLevel"));
        builder.add((Component)this.logLevelCbBx, cc.xy(4, 7));
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        short logLevel = (short)this.logLevelCbBx.getSelectedIndex();
        if (ServiceManager.sCfg.loggerVerboseLevel != logLevel) {
            ServiceManager.sCfg.loggerVerboseLevel = logLevel;
            Logger.setVerboseLevel(ServiceManager.sCfg.loggerVerboseLevel);
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
        short logType = 1;
        if (this.downloadTypeChkbx.isSelected()) {
            logType |= 2;
        }
        if (this.uploadTypeChkbx.isSelected()) {
            logType |= 4;
        }
        if (this.searchTypeChkbx.isSelected()) {
            logType |= 8;
        }
        if (this.netTypeChkbx.isSelected()) {
            logType |= 0x10;
        }
        if (this.guiTypeChkbx.isSelected()) {
            logType |= 0x20;
        }
        if (this.performanceTypeChkbx.isSelected()) {
            logType |= 0x40;
        }
        if (this.downloadNetTypeChkbx.isSelected()) {
            logType |= 0x80;
        }
        if (ServiceManager.sCfg.logType != logType) {
            ServiceManager.sCfg.logType = logType;
            Logger.setLogType(ServiceManager.sCfg.logType);
            OptionsSettingsPane.triggerConfigSave(inputDic);
        }
    }
}

