/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.wizard.condition;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.filter.wizard.FilterWizardDialog;
import phex.gui.dialogs.filter.wizard.condition.ConditionCellRenderer;
import phex.gui.dialogs.filter.wizard.condition.ConditionTableModel;
import phex.rules.Rule;
import phex.rules.condition.Condition;
import phex.rules.condition.NotCondition;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class ConditionPanel
extends JPanel {
    private FilterWizardDialog parent;
    private ConditionTableModel conditionTableModel;
    private FWTable conditionsTable;
    private JLabel selectConditionLabel;

    public ConditionPanel(FilterWizardDialog parent) {
        this.parent = parent;
        this.prepareComponent();
    }

    private void prepareComponent() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "p, 2dlu, fill:75dlu:grow");
        PanelBuilder contentPB = new PanelBuilder(layout, this);
        this.selectConditionLabel = new JLabel(Localizer.getString("RuleWizard_SelectRuleCondition"));
        contentPB.add((Component)this.selectConditionLabel, cc.xywh(1, 1, 1, 1));
        this.conditionTableModel = new ConditionTableModel(this);
        this.conditionsTable = new FWTable(this.conditionTableModel);
        this.conditionsTable.setShowVerticalLines(false);
        JTableHeader tableHeader = this.conditionsTable.getTableHeader();
        tableHeader.setResizingAllowed(false);
        tableHeader.setReorderingAllowed(false);
        JCheckBox box = (JCheckBox)((Object)this.conditionsTable.getDefaultRenderer(Boolean.class));
        TableColumn column = this.conditionsTable.getColumnModel().getColumn(0);
        column.setMaxWidth(box.getPreferredSize().width + 2);
        column.setMinWidth(box.getPreferredSize().width + 2);
        this.conditionsTable.getColumnModel().getColumn(1).setCellRenderer(new ConditionCellRenderer());
        contentPB.add((Component)FWTable.createFWTableScrollPane(this.conditionsTable), cc.xywh(1, 3, 1, 1));
    }

    public void updateRuleData() {
        Rule rule = this.parent.getEditRule();
        int rowCount = this.conditionTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.conditionTableModel.conditions[i][0] = Boolean.FALSE;
        }
        List conditionsList = rule.getConditions();
        Iterator iterator = conditionsList.iterator();
        while (iterator.hasNext()) {
            Condition condition = (Condition)iterator.next();
            if (condition instanceof NotCondition) continue;
            int row = this.conditionTableModel.getRowOf(condition);
            this.conditionTableModel.conditions[row][0] = Boolean.TRUE;
        }
        this.conditionsTable.setEnabled(!rule.isDefaultRule());
        this.selectConditionLabel.setEnabled(!rule.isDefaultRule());
        this.conditionTableModel.fireTableDataChanged();
    }

    public void ruleStatusChanged(Class conditionClass, boolean status) {
        Rule editRule = this.parent.getEditRule();
        if (status) {
            try {
                Condition newCondition = (Condition)conditionClass.newInstance();
                editRule.addCondition(newCondition);
                this.parent.updateRuleData();
            }
            catch (InstantiationException exp) {
                NLogger.error(ConditionPanel.class, (Object)exp, (Throwable)exp);
            }
            catch (IllegalAccessException exp) {
                NLogger.error(ConditionPanel.class, (Object)exp, (Throwable)exp);
            }
        } else {
            List conditions = editRule.getConditions();
            for (int i = conditions.size() - 1; i >= 0; --i) {
                Condition condition = (Condition)conditions.get(i);
                if (condition.getClass() != conditionClass) continue;
                editRule.removeCondition(condition);
            }
            this.parent.updateRuleData();
        }
    }
}

