/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.gui.common.FWSizeDefComboBox;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.filter.ConditionVisualizer;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.rules.condition.FileSizeCondition;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class FileSizeCondEditor
extends JDialog {
    private RuleDescriptionPanel ruleDescPanel;
    private FileSizeCondition orgCondition;
    private FileSizeCondition condition;
    private JTextField minFileSizeTF;
    private FWSizeDefComboBox minFileSizeUnitComboBox;
    private JTextField maxFileSizeTF;
    private FWSizeDefComboBox maxFileSizeUnitComboBox;
    private JList rangeList;
    private FileSizeRangeModel fileSizeRangeModel;

    public FileSizeCondEditor(FileSizeCondition cond, RuleDescriptionPanel descPanel, JDialog parentDialog) {
        super(parentDialog, Localizer.getString("FileSizeCondEditor_DialogTitle"), true);
        this.ruleDescPanel = descPanel;
        this.orgCondition = cond;
        this.condition = new FileSizeCondition(cond);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, d, 2dlu, d, 2dlu, d, d:grow, 4dlu, d, 4dlu", "4dlu, p, 2dlu, p, 2dlu, p, 10dlu, p, 2dlu, p, fill:p:grow, 4dlu, p, 2dlu, p 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        JLabel label = new JLabel(Localizer.getString("FileSizeCondEditor_ConditionToAdd"));
        contentPB.add((Component)label, cc.xywh(2, 2, 5, 1));
        label = new JLabel(Localizer.getString("FileSizeCondEditor_Minimum"));
        label.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTMinimum"));
        contentPB.add((Component)label, cc.xywh(2, 4, 1, 1));
        this.minFileSizeTF = new IntegerTextField(9);
        this.minFileSizeTF.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTMinimum"));
        contentPB.add((Component)this.minFileSizeTF, cc.xywh(4, 4, 1, 1));
        this.minFileSizeUnitComboBox = new FWSizeDefComboBox();
        this.minFileSizeUnitComboBox.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTMinimum"));
        contentPB.add((Component)this.minFileSizeUnitComboBox, cc.xywh(6, 4, 1, 1));
        label = new JLabel(Localizer.getString("FileSizeCondEditor_Maximum"));
        contentPB.add((Component)label, cc.xywh(2, 6, 1, 1));
        this.maxFileSizeTF = new IntegerTextField(9);
        this.maxFileSizeTF.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTMaximum"));
        contentPB.add((Component)this.maxFileSizeTF, cc.xywh(4, 6, 1, 1));
        this.maxFileSizeUnitComboBox = new FWSizeDefComboBox();
        this.maxFileSizeUnitComboBox.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTMaximum"));
        contentPB.add((Component)this.maxFileSizeUnitComboBox, cc.xywh(6, 6, 1, 1));
        JButton addBtn = new JButton(Localizer.getString("FileSizeCondEditor_Add"));
        addBtn.addActionListener(new AddActionListener());
        addBtn.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTAdd"));
        contentPB.add((Component)addBtn, cc.xywh(9, 6, 1, 1));
        label = new JLabel(Localizer.getString("FileSizeCondEditor_FileSizeConditions"));
        contentPB.add((Component)label, cc.xywh(2, 8, 5, 1));
        this.fileSizeRangeModel = new FileSizeRangeModel();
        this.rangeList = new JList(this.fileSizeRangeModel);
        this.rangeList.setCellRenderer(new FileSizeRangeRenderer());
        contentPB.add((Component)new JScrollPane(this.rangeList), cc.xywh(2, 10, 6, 2));
        JButton removeBtn = new JButton(Localizer.getString("FileSizeCondEditor_Remove"));
        removeBtn.addActionListener(new RemoveActionListener());
        removeBtn.setToolTipText(Localizer.getString("FileSizeCondEditor_TTTRemove"));
        contentPB.add((Component)removeBtn, cc.xywh(9, 10, 1, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, rowCount - 3, columnCount, 1));
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.addActionListener(new OkBtnListener());
        okBtn.setDefaultCapable(true);
        okBtn.setRequestFocusEnabled(true);
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(closeEventHandler);
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(okBtn, cancelBtn);
        contentPB.add((Component)btnPanel, cc.xywh(2, rowCount - 1, columnCount - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(okBtn);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public final class FileSizeRangeRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
            } else {
                StringBuffer buffer = new StringBuffer();
                ConditionVisualizer.visualizeFileSizeRange(buffer, (FileSizeCondition.Range)value);
                this.setText(buffer.toString());
            }
            return this;
        }
    }

    public final class FileSizeRangeModel
    extends AbstractListModel {
        public int getSize() {
            return FileSizeCondEditor.this.condition.getRangesCount();
        }

        public Object getElementAt(int index) {
            return FileSizeCondEditor.this.condition.getRangesList().get(index);
        }

        public void fireChange() {
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            FileSizeCondEditor.this.closeDialog();
        }

        public void actionPerformed(ActionEvent e) {
            FileSizeCondEditor.this.closeDialog();
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FileSizeCondEditor.this.orgCondition.update(FileSizeCondEditor.this.condition);
                FileSizeCondEditor.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error("USER_INTERFACE", (Object)th, th);
            }
        }
    }

    private final class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int idx = FileSizeCondEditor.this.rangeList.getSelectedIndex();
            Object[] values = FileSizeCondEditor.this.rangeList.getSelectedValues();
            for (int i = 0; i < values.length; ++i) {
                FileSizeCondEditor.this.condition.removeRange((FileSizeCondition.Range)values[i]);
            }
            FileSizeCondEditor.this.fileSizeRangeModel.fireChange();
            int modelSize = FileSizeCondEditor.this.fileSizeRangeModel.getSize();
            if (modelSize == 0) {
                FileSizeCondEditor.this.minFileSizeTF.requestFocusInWindow();
            } else {
                FileSizeCondEditor.this.rangeList.setSelectedIndex(Math.max(0, Math.min(idx, modelSize - 1)));
            }
        }
    }

    private final class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String minSizeStr = FileSizeCondEditor.this.minFileSizeTF.getText().trim();
            String maxSizeStr = FileSizeCondEditor.this.maxFileSizeTF.getText().trim();
            long finalMinSize = -1L;
            try {
                if (minSizeStr.length() > 0) {
                    long minSize = Integer.parseInt(minSizeStr);
                    long minSizeMultiplier = FileSizeCondEditor.this.minFileSizeUnitComboBox.getDefMultiplier();
                    finalMinSize = minSizeMultiplier * minSize;
                }
            }
            catch (NumberFormatException exp) {
                this.displayWrongNumberFormatError(FileSizeCondEditor.this.minFileSizeTF);
                return;
            }
            long finalMaxSize = -1L;
            try {
                if (maxSizeStr.length() > 0) {
                    long maxSize = Integer.parseInt(maxSizeStr);
                    long maxSizeMultiplier = FileSizeCondEditor.this.maxFileSizeUnitComboBox.getDefMultiplier();
                    finalMaxSize = maxSizeMultiplier * maxSize;
                }
            }
            catch (NumberFormatException exp) {
                this.displayWrongNumberFormatError(FileSizeCondEditor.this.maxFileSizeTF);
                return;
            }
            if (finalMinSize == -1L && finalMaxSize == -1L) {
                return;
            }
            FileSizeCondEditor.this.condition.addRange(finalMinSize, finalMaxSize);
            FileSizeCondEditor.this.minFileSizeTF.setText("");
            FileSizeCondEditor.this.maxFileSizeTF.setText("");
            FileSizeCondEditor.this.fileSizeRangeModel.fireChange();
            FileSizeCondEditor.this.minFileSizeTF.requestFocusInWindow();
        }

        private void displayWrongNumberFormatError(JTextField textField) {
            textField.requestFocus();
            textField.selectAll();
            JOptionPane.showMessageDialog(FileSizeCondEditor.this, Localizer.getString("WrongNumberFormat"), Localizer.getString("FormatError"), 0);
        }
    }
}

