/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import phex.gui.dialogs.filter.RuleEditWrapper;
import phex.query.QueryManager;
import phex.rules.Rule;
import phex.rules.SearchFilterRules;

public class SearchFilterRulesEditModel
extends AbstractListModel
implements ListModel {
    protected EventListenerList listenerList = new EventListenerList();
    private List allRules;

    public SearchFilterRulesEditModel() {
        SearchFilterRules rules = QueryManager.getInstance().getSearchFilterRules();
        this.allRules = new ArrayList();
        this.allRules.addAll(rules.getAsList());
    }

    public void applyChangesToQueryManager() {
        ArrayList newRulesList = new ArrayList();
        Iterator iterator = this.allRules.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Rule) {
                newRulesList.add(obj);
                continue;
            }
            RuleEditWrapper wrapper = (RuleEditWrapper)obj;
            Rule modifiedRule = wrapper.getModifiedRule();
            if (modifiedRule == null) continue;
            newRulesList.add(modifiedRule);
        }
        QueryManager.getInstance().getSearchFilterRules().setRuleList(newRulesList);
    }

    public void addNewRule(Rule rule) {
        RuleEditWrapper wrapper = new RuleEditWrapper(rule);
        int pos = this.allRules.size();
        this.allRules.add(pos, wrapper);
        this.fireIntervalAdded(this, pos, pos);
    }

    public int moveRule(int idx, boolean moveUp) {
        Object rule = this.allRules.remove(idx);
        int newIdx = moveUp ? Math.max(0, idx - 1) : Math.min(idx + 1, this.allRules.size());
        this.allRules.add(newIdx, rule);
        int start = Math.min(idx, newIdx);
        int end = Math.max(idx, newIdx);
        this.fireContentsChanged(this, start, end);
        return newIdx;
    }

    public void removeRule(int idx) {
        RuleEditWrapper wrapper = this.getRuleEditWrapperAt(idx);
        wrapper.setModifiedRule(null);
        this.allRules.remove(idx);
        this.fireIntervalRemoved(this, idx, idx);
    }

    public void updateRule(int idx, Rule rule) {
        RuleEditWrapper wrapper = (RuleEditWrapper)this.allRules.get(idx);
        wrapper.setModifiedRule(rule);
        this.fireContentsChanged(this, idx, idx);
    }

    public Rule getDisplayRuleAt(int idx) {
        RuleEditWrapper wrapper;
        Object obj = this.allRules.get(idx);
        if (obj instanceof Rule) {
            wrapper = this.createRuleEditWrapper((Rule)obj);
            this.allRules.remove(idx);
            this.allRules.add(idx, wrapper);
        } else {
            wrapper = (RuleEditWrapper)obj;
        }
        return wrapper.getModifiedRule();
    }

    private RuleEditWrapper getRuleEditWrapperAt(int idx) {
        RuleEditWrapper wrapper;
        Object obj = this.allRules.get(idx);
        if (obj instanceof Rule) {
            wrapper = this.createRuleEditWrapper((Rule)obj);
            this.allRules.remove(idx);
            this.allRules.add(idx, wrapper);
        } else {
            wrapper = (RuleEditWrapper)obj;
        }
        return wrapper;
    }

    private RuleEditWrapper createRuleEditWrapper(Rule orgRule) {
        Rule modifiableRule = (Rule)orgRule.clone();
        RuleEditWrapper wrapper = new RuleEditWrapper(modifiableRule);
        return wrapper;
    }

    public int getSize() {
        return this.allRules.size();
    }

    public Object getElementAt(int index) {
        return this.allRules.get(index);
    }
}

