/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import phex.utils.JDKUtils;
import phex.utils.Localizer;

public class RuleDescriptionVisualizer {
    protected static final Pattern REPL_PATTERN = Pattern.compile("--__.*__--");

    public static String cleanDisplayString(String displayString) {
        int startIdx = displayString.indexOf("--__");
        int endIdx = displayString.indexOf("__--");
        if (startIdx == -1 || endIdx == -1) {
            return displayString;
        }
        return displayString.substring(0, startIdx) + displayString.substring(startIdx + 4, endIdx) + displayString.substring(endIdx + 4, displayString.length());
    }

    public static void insertDisplayString(String displayString, Object reference, Document doc) throws BadLocationException {
        int startIdx = displayString.indexOf("--__");
        int endIdx = displayString.indexOf("__--");
        if (startIdx == -1 || endIdx == -1) {
            RuleDescriptionVisualizer.insertStandardPart(displayString, reference, doc);
        } else {
            RuleDescriptionVisualizer.insertStandardPart(displayString.substring(0, startIdx), reference, doc);
            RuleDescriptionVisualizer.insertLinkPart(displayString.substring(startIdx + 4, endIdx), reference, doc);
            RuleDescriptionVisualizer.insertStandardPart(displayString.substring(endIdx + 4, displayString.length()), reference, doc);
        }
    }

    protected static void insertLinkPart(String text, Object reference, Document doc) throws BadLocationException {
        SimpleAttributeSet set = new SimpleAttributeSet();
        set.addAttribute("Link", reference);
        set.addAttribute("RuleObjReference", reference);
        StyleConstants.setUnderline(set, true);
        doc.insertString(doc.getLength(), text, set);
    }

    protected static void insertStandardPart(String text, Object reference, Document doc) throws BadLocationException {
        if (text.length() == 0) {
            return;
        }
        SimpleAttributeSet set = new SimpleAttributeSet();
        set.addAttribute("RuleObjReference", reference);
        doc.insertString(doc.getLength(), text, set);
    }

    public static void visualizeNext(boolean isAndConcat, Object reference, Document doc) throws BadLocationException {
        RuleDescriptionVisualizer.insertStandardPart("\n", reference, doc);
        if (isAndConcat) {
            RuleDescriptionVisualizer.insertStandardPart(Localizer.getString("RuleVisualization_And") + " ", reference, doc);
        }
    }

    public static String replacePlaceholderPattern(String source, String replacement) {
        Matcher matcher = REPL_PATTERN.matcher(source);
        replacement = JDKUtils.Matcher_quoteReplacement(replacement);
        return matcher.replaceAll("--__" + replacement + "__--");
    }
}

