/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.common.ExpiryDate;
import phex.common.address.AddressUtils;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IPTextField;
import phex.gui.common.IntegerTextField;
import phex.security.IPAccessRule;
import phex.security.PhexSecurityManager;
import phex.utils.Localizer;

public class SecurityRuleConfigDialog
extends JDialog {
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private IPAccessRule securityRule;
    private JTextField descriptionTF;
    private JCheckBox disableRuleCkBx;
    private JComboBox addressTypeCBox;
    private JLabel firstIPLabel;
    private IPTextField firstIPField;
    private JLabel secondIPLabel;
    private IPTextField secondIPField;
    private JComboBox expiresCBox;
    private JComboBox ruleTypeCBox;
    private IntegerTextField daysTF;
    private JLabel daysLabel;
    private IntegerTextField hoursTF;
    private JLabel hoursLabel;
    private IntegerTextField minutesTF;
    private JLabel minutesLabel;
    private JCheckBox isDeletedOnExpiryCkbx;

    public SecurityRuleConfigDialog() {
        this((IPAccessRule)null);
    }

    public SecurityRuleConfigDialog(IPAccessRule accessRule) {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("NewSecurityRule"), true);
        this.securityRule = accessRule;
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SecurityRuleConfigDialog.this.closeDialog();
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        JPanel pane = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 18;
        constraints.fill = 1;
        contentPane.add((Component)pane, constraints);
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("SecurityRule")));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 18;
        constraints.fill = 1;
        pane.add((Component)topPanel, constraints);
        JLabel descriptionLabel = new JLabel(Localizer.getString("Description") + Localizer.getString("ColonSign"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 2, 2, 4);
        constraints.anchor = 13;
        topPanel.add((Component)descriptionLabel, constraints);
        this.descriptionTF = new JTextField(20);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 2, 2);
        constraints.anchor = 17;
        topPanel.add((Component)this.descriptionTF, constraints);
        this.disableRuleCkBx = new JCheckBox(Localizer.getString("DisableSecurityRule"));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(0, 0, 2, 4);
        constraints.anchor = 17;
        topPanel.add((Component)this.disableRuleCkBx, constraints);
        JPanel middlePanel = new JPanel(new GridBagLayout());
        middlePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("NetworkAddress")));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 2, 2, 2);
        constraints.anchor = 18;
        constraints.fill = 2;
        pane.add((Component)middlePanel, constraints);
        JPanel groupBtnPane = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 18;
        constraints.fill = 2;
        middlePanel.add((Component)groupBtnPane, constraints);
        JLabel addTypeLabel = new JLabel(Localizer.getString("AddressType") + Localizer.getString("ColonSign"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 2, 0, 4);
        constraints.anchor = 13;
        groupBtnPane.add((Component)addTypeLabel, constraints);
        String[] addressTypeArr = new String[]{Localizer.getString("SingleAddress"), Localizer.getString("Network/Range"), Localizer.getString("Network/Mask")};
        this.addressTypeCBox = new JComboBox<String>(addressTypeArr);
        this.addressTypeCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SecurityRuleConfigDialog.this.refreshAddressDisplayState();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        groupBtnPane.add((Component)this.addressTypeCBox, constraints);
        JPanel ipFieldPane = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(8, 1, 0, 0);
        constraints.fill = 2;
        constraints.anchor = 18;
        middlePanel.add((Component)ipFieldPane, constraints);
        this.firstIPLabel = new JLabel(Localizer.getString("HostAddress") + Localizer.getString("ColonSign"));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 2, 2, 4);
        constraints.anchor = 13;
        ipFieldPane.add((Component)this.firstIPLabel, constraints);
        this.secondIPLabel = new JLabel(Localizer.getString("NetworkMask") + Localizer.getString("ColonSign"));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 2, 0, 4);
        constraints.anchor = 13;
        ipFieldPane.add((Component)this.secondIPLabel, constraints);
        this.firstIPField = new IPTextField();
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 2, 2);
        constraints.anchor = 17;
        ipFieldPane.add((Component)this.firstIPField, constraints);
        this.secondIPField = new IPTextField();
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 0, 2);
        constraints.anchor = 17;
        ipFieldPane.add((Component)this.secondIPField, constraints);
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("Options")));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 2, 2, 2);
        constraints.anchor = 18;
        constraints.fill = 1;
        pane.add((Component)bottomPanel, constraints);
        JLabel typeLabel = new JLabel(Localizer.getString("ActionType") + Localizer.getString("ColonSign"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 2, 6, 4);
        constraints.anchor = 13;
        bottomPanel.add((Component)typeLabel, constraints);
        String[] typeArr = new String[]{Localizer.getString("Deny"), Localizer.getString("Accept")};
        this.ruleTypeCBox = new JComboBox<String>(typeArr);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 6, 0);
        constraints.anchor = 17;
        bottomPanel.add((Component)this.ruleTypeCBox, constraints);
        JLabel expiresLabel = new JLabel(Localizer.getString("Expires") + Localizer.getString("ColonSign"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 2, 2, 4);
        constraints.anchor = 13;
        bottomPanel.add((Component)expiresLabel, constraints);
        String[] expireArr = new String[]{Localizer.getString("Never"), Localizer.getString("EndOfSession"), Localizer.getString("After") + Localizer.getString("ColonSign")};
        this.expiresCBox = new JComboBox<String>(expireArr);
        this.expiresCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SecurityRuleConfigDialog.this.refreshExpiryDisplayState();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 0, 2);
        constraints.fill = 2;
        constraints.anchor = 17;
        bottomPanel.add((Component)this.expiresCBox, constraints);
        JPanel afterTimePanel = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(2, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 1;
        bottomPanel.add((Component)afterTimePanel, constraints);
        this.daysTF = new IntegerTextField(4);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        afterTimePanel.add((Component)this.daysTF, constraints);
        this.daysLabel = new JLabel(Localizer.getString("Days"));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 2, 0, 0);
        constraints.anchor = 17;
        afterTimePanel.add((Component)this.daysLabel, constraints);
        this.hoursTF = new IntegerTextField(4);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 4, 0, 0);
        constraints.anchor = 17;
        afterTimePanel.add((Component)this.hoursTF, constraints);
        this.hoursLabel = new JLabel(Localizer.getString("Hours"));
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 2, 0, 0);
        constraints.anchor = 17;
        afterTimePanel.add((Component)this.hoursLabel, constraints);
        this.minutesTF = new IntegerTextField(4);
        constraints = new GridBagConstraints();
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 4, 0, 0);
        constraints.anchor = 17;
        afterTimePanel.add((Component)this.minutesTF, constraints);
        this.minutesLabel = new JLabel(Localizer.getString("Minutes"));
        constraints = new GridBagConstraints();
        constraints.gridx = 5;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 2, 0, 2);
        constraints.anchor = 17;
        afterTimePanel.add((Component)this.minutesLabel, constraints);
        this.isDeletedOnExpiryCkbx = new JCheckBox(Localizer.getString("DeleteRuleAfterExpiry"));
        this.isDeletedOnExpiryCkbx.setToolTipText(Localizer.getString("TTTDeleteRuleAfterExpiry"));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 0, 2);
        constraints.anchor = 18;
        bottomPanel.add((Component)this.isDeletedOnExpiryCkbx, constraints);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(2, 0, 2, 0);
        constraints.anchor = 16;
        constraints.fill = 1;
        pane.add((Component)buttonPanel, constraints);
        JSeparator sep = new JSeparator();
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(6, 0, 6, 0);
        constraints.anchor = 10;
        constraints.fill = 1;
        buttonPanel.add((Component)sep, constraints);
        ButtonActionHandler actionHandler = new ButtonActionHandler();
        JButton okButton = new JButton(Localizer.getString("OK"));
        okButton.setDefaultCapable(true);
        okButton.setRequestFocusEnabled(true);
        okButton.addActionListener(actionHandler);
        okButton.setActionCommand("OK");
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.anchor = 13;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.fill = 0;
        buttonPanel.add((Component)okButton, constraints);
        JButton cancelButton = new JButton(Localizer.getString("Cancel"));
        cancelButton.setRequestFocusEnabled(true);
        cancelButton.addActionListener(actionHandler);
        cancelButton.setActionCommand("CANCEL");
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = 13;
        constraints.fill = 0;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.weighty = 1.0;
        buttonPanel.add((Component)cancelButton, constraints);
        GUIUtils.adjustComboBoxHeight(this.expiresCBox);
        GUIUtils.adjustComboBoxHeight(this.ruleTypeCBox);
        GUIUtils.adjustComboBoxHeight(this.addressTypeCBox);
        this.initContent();
        this.refreshAddressDisplayState();
        this.refreshExpiryDisplayState();
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void initContent() {
        if (this.securityRule == null) {
            return;
        }
        this.descriptionTF.setText(this.securityRule.getDescription());
        byte addressType = this.securityRule.getAddressType();
        switch (addressType) {
            case 1: {
                this.addressTypeCBox.setSelectedIndex(0);
                this.firstIPField.setIPString(AddressUtils.ip2string(this.securityRule.getHostIP()));
                break;
            }
            case 3: {
                this.addressTypeCBox.setSelectedIndex(1);
                this.firstIPField.setIPString(AddressUtils.ip2string(this.securityRule.getHostIP()));
                this.secondIPField.setIPString(AddressUtils.ip2string(this.securityRule.getCompareIP()));
                break;
            }
            case 2: {
                this.addressTypeCBox.setSelectedIndex(2);
                this.firstIPField.setIPString(AddressUtils.ip2string(this.securityRule.getHostIP()));
                this.secondIPField.setIPString(AddressUtils.ip2string(this.securityRule.getCompareIP()));
            }
        }
        boolean isDenyingRule = this.securityRule.isDenyingRule();
        if (isDenyingRule) {
            this.ruleTypeCBox.setSelectedIndex(0);
        } else {
            this.ruleTypeCBox.setSelectedIndex(1);
        }
        this.disableRuleCkBx.setSelected(this.securityRule.isDisabled());
        ExpiryDate expiryDate = this.securityRule.getExpiryDate();
        if (expiryDate.isExpiringNever()) {
            this.expiresCBox.setSelectedIndex(0);
        } else if (expiryDate.isExpiringEndOfSession()) {
            this.expiresCBox.setSelectedIndex(1);
        } else {
            this.expiresCBox.setSelectedIndex(2);
            this.initAfterExpiryDateContent(expiryDate);
        }
        this.isDeletedOnExpiryCkbx.setSelected(this.securityRule.isDeletedOnExpiry());
    }

    public void customPrefillBanSingleIp(String description, byte[] hostIp) {
        this.descriptionTF.setText(description);
        this.addressTypeCBox.setSelectedIndex(0);
        this.firstIPField.setIPString(AddressUtils.ip2string(hostIp));
        this.ruleTypeCBox.setSelectedIndex(0);
        this.disableRuleCkBx.setSelected(false);
        this.expiresCBox.setSelectedIndex(1);
        this.isDeletedOnExpiryCkbx.setSelected(false);
    }

    private void refreshAddressDisplayState() {
        if (Localizer.getString("SingleAddress").equals(this.addressTypeCBox.getSelectedItem())) {
            this.firstIPLabel.setText(Localizer.getString("HostAddress") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setText(Localizer.getString("NetworkMask") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setEnabled(false);
            this.secondIPField.setEnabled(false);
            this.secondIPField.setIPString("255.255.255.255");
        } else if (Localizer.getString("Network/Range").equals(this.addressTypeCBox.getSelectedItem())) {
            this.firstIPLabel.setText(Localizer.getString("FirstAddress") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setText(Localizer.getString("LastAddress") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setEnabled(true);
            this.secondIPField.setEnabled(true);
        } else if (Localizer.getString("Network/Mask").equals(this.addressTypeCBox.getSelectedItem())) {
            this.firstIPLabel.setText(Localizer.getString("NetworkAddress") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setText(Localizer.getString("NetworkMask") + Localizer.getString("ColonSign"));
            this.secondIPLabel.setEnabled(true);
            this.secondIPField.setEnabled(true);
        }
    }

    private void refreshExpiryDisplayState() {
        if (Localizer.getString("Never").equals(this.expiresCBox.getSelectedItem())) {
            this.isDeletedOnExpiryCkbx.setEnabled(false);
            this.daysTF.setEnabled(false);
            this.daysLabel.setEnabled(false);
            this.hoursTF.setEnabled(false);
            this.hoursLabel.setEnabled(false);
            this.minutesTF.setEnabled(false);
            this.minutesLabel.setEnabled(false);
        } else if (Localizer.getString("EndOfSession").equals(this.expiresCBox.getSelectedItem())) {
            this.isDeletedOnExpiryCkbx.setEnabled(true);
            this.daysTF.setEnabled(false);
            this.daysLabel.setEnabled(false);
            this.hoursTF.setEnabled(false);
            this.hoursLabel.setEnabled(false);
            this.minutesTF.setEnabled(false);
            this.minutesLabel.setEnabled(false);
        } else if ((Localizer.getString("After") + Localizer.getString("ColonSign")).equals(this.expiresCBox.getSelectedItem())) {
            this.isDeletedOnExpiryCkbx.setEnabled(true);
            this.daysTF.setEnabled(true);
            this.daysLabel.setEnabled(true);
            this.hoursTF.setEnabled(true);
            this.hoursLabel.setEnabled(true);
            this.minutesTF.setEnabled(true);
            this.minutesLabel.setEnabled(true);
        }
    }

    private void validateAndSaveSecurityRule() {
        ExpiryDate expiryDate;
        byte[] compareIP;
        byte[] ip;
        byte addressType;
        String description = this.descriptionTF.getText();
        boolean isDenyingRule = this.ruleTypeCBox.getSelectedIndex() == 0;
        switch (this.addressTypeCBox.getSelectedIndex()) {
            case 0: {
                addressType = 1;
                ip = this.firstIPField.getIP();
                compareIP = null;
                break;
            }
            case 1: {
                addressType = 3;
                ip = this.firstIPField.getIP();
                compareIP = this.secondIPField.getIP();
                break;
            }
            case 2: {
                addressType = 2;
                ip = this.firstIPField.getIP();
                compareIP = this.secondIPField.getIP();
                break;
            }
            default: {
                throw new RuntimeException("Unknown address type: " + this.addressTypeCBox.getSelectedIndex());
            }
        }
        boolean isDisabled = this.disableRuleCkBx.isSelected();
        switch (this.expiresCBox.getSelectedIndex()) {
            case 0: {
                expiryDate = ExpiryDate.NEVER_EXPIRY_DATE;
                break;
            }
            case 1: {
                expiryDate = ExpiryDate.SESSION_EXPIRY_DATE;
                break;
            }
            case 2: {
                expiryDate = this.createAfterExpiryDate();
                break;
            }
            default: {
                throw new RuntimeException("Unknown expiry type: " + this.expiresCBox.getSelectedIndex());
            }
        }
        boolean isDeletedOnExpiry = this.isDeletedOnExpiryCkbx.isSelected();
        if (this.securityRule == null) {
            PhexSecurityManager.getInstance().createIPAccessRule(description, isDenyingRule, addressType, ip, compareIP, isDisabled, expiryDate, isDeletedOnExpiry);
        } else {
            this.securityRule.setHostIP(ip);
            this.securityRule.setCompareIP(compareIP);
            this.securityRule.setDescription(description);
            this.securityRule.setDenyingRule(isDenyingRule);
            this.securityRule.setAddressType(addressType);
            this.securityRule.setDisabled(isDisabled);
            this.securityRule.setExpiryDate(expiryDate);
            this.securityRule.setDeleteOnExpiry(isDeletedOnExpiry);
        }
    }

    private void initAfterExpiryDateContent(ExpiryDate expiryDate) {
        int minutes;
        int hours;
        int days;
        long currentTime;
        long time = expiryDate.getTime();
        long timeDiff = time - (currentTime = System.currentTimeMillis());
        if (timeDiff <= 0L) {
            days = 0;
            hours = 0;
            minutes = 0;
        } else {
            days = (int)Math.floor(timeDiff / 86400000L);
            hours = (int)Math.floor((timeDiff -= (long)days * 86400000L) / 3600000L);
            minutes = (int)Math.ceil((timeDiff -= (long)hours * 3600000L) / 60000L);
        }
        this.daysTF.setText(String.valueOf(days));
        this.hoursTF.setText(String.valueOf(hours));
        this.minutesTF.setText(String.valueOf(minutes));
    }

    private ExpiryDate createAfterExpiryDate() {
        Integer minutes;
        Integer hours;
        Integer days = this.daysTF.getIntegerValue();
        if (days == null) {
            days = new Integer(0);
        }
        if ((hours = this.hoursTF.getIntegerValue()) == null) {
            hours = new Integer(0);
        }
        if ((minutes = this.minutesTF.getIntegerValue()) == null) {
            minutes = new Integer(0);
        }
        long currentTime = System.currentTimeMillis();
        return ExpiryDate.getExpiryDate(currentTime += (long)days.intValue() * 86400000L + (long)hours.intValue() * 3600000L + (long)minutes.intValue() * 60000L);
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("OK")) {
                SecurityRuleConfigDialog.this.validateAndSaveSecurityRule();
            }
            SecurityRuleConfigDialog.this.closeDialog();
        }
    }
}

