/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.comparator;

import java.util.Comparator;
import phex.common.TransferDataProvider;

public class ETAComparator
implements Comparator {
    public int compare(Object obj1, Object obj2) {
        if (obj1 == obj2 || obj1.equals(obj2)) {
            return 0;
        }
        TransferDataProvider provider1 = (TransferDataProvider)obj1;
        TransferDataProvider provider2 = (TransferDataProvider)obj2;
        long diff = this.calcTimeRemaining(provider2) - this.calcTimeRemaining(provider1);
        if (diff == 0L) {
            diff = provider2.hashCode() - provider1.hashCode();
        }
        if (diff < 0L) {
            return -1;
        }
        return 1;
    }

    public long calcTimeRemaining(TransferDataProvider provider) {
        long transferredSize = provider.getTransferredDataSize();
        long totalTransferSize = provider.getTransferDataSize();
        long transferRate = provider.getLongTermTransferRate();
        if (totalTransferSize == -1L || provider.getDataTransferStatus() != 10) {
            return 31536000L;
        }
        if (transferRate == 0L) {
            return 31536000L;
        }
        long timeRemaining = (totalTransferSize - transferredSize) / transferRate;
        timeRemaining = Math.max(0L, timeRemaining);
        return timeRemaining;
    }
}

