/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import phex.gui.common.table.FWTableColumn;
import phex.gui.common.table.FWTableModel;
import phex.utils.NLogger;
import phex.xml.sax.gui.DTableColumn;
import phex.xml.sax.gui.DTableColumnList;

public class FWTableColumnModel
extends DefaultTableColumnModel {
    private ArrayList allTableColumns = new ArrayList();

    public FWTableColumnModel(FWTableModel tableModel, int[] columnIdArray) {
        this(tableModel, columnIdArray, null);
    }

    public FWTableColumnModel(FWTableModel tableModel, int[] columnIdArray, DTableColumnList dColumnList) {
        this.buildColumnsFromColumnIDs(columnIdArray, tableModel, dColumnList);
    }

    public List getColumns(boolean includeHidden) {
        if (includeHidden) {
            return new ArrayList(this.allTableColumns);
        }
        return Collections.list(this.getColumns());
    }

    public void addColumn(FWTableColumn aColumn) {
        if (aColumn.isVisible()) {
            super.addColumn(aColumn);
        }
        this.allTableColumns.add(aColumn);
    }

    public void showColumn(FWTableColumn aColumn) {
        if (!aColumn.isVisible()) {
            aColumn.setVisible(true);
            super.addColumn(aColumn);
            int pos = this.getColumnCount() - 1;
            int modelPos = aColumn.getModelIndex();
            if (pos == 0) {
                return;
            }
            TableColumn tempCol = this.getColumn(pos - 1);
            int tempIdx = tempCol.getModelIndex();
            while (tempIdx > modelPos && --pos != 0) {
                tempCol = this.getColumn(pos - 1);
                tempIdx = tempCol.getModelIndex();
            }
            if (pos < this.getColumnCount() - 1) {
                this.moveColumn(this.getColumnCount() - 1, pos);
            }
        }
    }

    public void hideColumn(FWTableColumn aColumn) {
        if (aColumn.isHideable() && aColumn.isVisible()) {
            this.removeColumn(aColumn);
            aColumn.setVisible(false);
        }
    }

    public FWTableColumn getColumn(Object identifier) {
        Iterator iterator = this.allTableColumns.iterator();
        while (iterator.hasNext()) {
            FWTableColumn aColumn = (FWTableColumn)iterator.next();
            if (!identifier.equals(aColumn.getIdentifier())) continue;
            return aColumn;
        }
        return null;
    }

    public Iterator createAllColumnsIterator() {
        return this.allTableColumns.iterator();
    }

    public DTableColumnList createDGuiTableColumnList() {
        DTableColumnList colList = new DTableColumnList();
        List list = colList.getSubElementList();
        Collections.sort(this.allTableColumns, new VisibleTableColumnComparator());
        Iterator iterator = this.allTableColumns.iterator();
        while (iterator.hasNext()) {
            FWTableColumn column = (FWTableColumn)iterator.next();
            DTableColumn dColumn = column.createDGuiTableColumn();
            if (column.isVisible()) {
                dColumn.setVisibleIndex(this.getColumnIndex(column.getIdentifier()));
            }
            list.add(dColumn);
        }
        return colList;
    }

    protected void buildColumnsFromColumnIDs(int[] columnIdArray, FWTableModel tableModel, DTableColumnList dColumnList) {
        ArrayList<FWTableColumn> newColumnList = new ArrayList<FWTableColumn>(columnIdArray.length);
        for (int i = 0; i < columnIdArray.length; ++i) {
            FWTableColumn column = null;
            if (dColumnList != null) {
                column = this.buildColumnFromXML(columnIdArray[i], tableModel, dColumnList);
            }
            if (column != null) continue;
            column = this.buildDefaultColumn(columnIdArray[i], tableModel);
            newColumnList.add(column);
        }
        this.arrangeColumns(dColumnList, newColumnList, tableModel);
    }

    protected FWTableColumn buildColumnFromXML(int columnId, FWTableModel tableModel, DTableColumnList dColumnList) {
        if (dColumnList == null) {
            return null;
        }
        try {
            FWTableColumn column = null;
            Iterator iterator = dColumnList.getSubElementList().iterator();
            while (iterator.hasNext()) {
                DTableColumn dColumn = (DTableColumn)iterator.next();
                if (columnId != dColumn.getColumnID()) continue;
                int modelIndex = tableModel.mapColumnIDToModelIndex(columnId);
                column = new FWTableColumn(modelIndex, tableModel.getColumnName(modelIndex), new Integer(columnId));
                column.setHideable(tableModel.isColumnHideable(columnId));
                column.setVisible(dColumn.isVisible());
                column.setPreferredWidth(dColumn.getWidth());
                this.addColumn(column);
                return column;
            }
            return null;
        }
        catch (Exception exp) {
            NLogger.error("USER_INTERFACE", (Object)exp, (Throwable)exp);
            return null;
        }
    }

    protected FWTableColumn buildDefaultColumn(int columnId, FWTableModel tableModel) {
        int columnIndex = tableModel.mapColumnIDToModelIndex(columnId);
        FWTableColumn column = new FWTableColumn(columnIndex, tableModel.getColumnName(columnIndex), new Integer(columnId));
        column.setHideable(tableModel.isColumnHideable(columnId));
        this.addColumn(column);
        return column;
    }

    protected void arrangeColumns(DTableColumnList dColumnList, ArrayList newColumnList, FWTableModel tableModel) {
        if (dColumnList != null) {
            Iterator iterator = dColumnList.getSubElementList().iterator();
            while (iterator.hasNext()) {
                try {
                    DTableColumn dColumn = (DTableColumn)iterator.next();
                    int columnId = dColumn.getColumnID();
                    int modelIndex = tableModel.mapColumnIDToModelIndex(columnId);
                    if (!dColumn.isVisible() || modelIndex < 0) continue;
                    int colIdx = this.getColumnIndex(new Integer(columnId));
                    int visibleIndex = dColumn.getVisibleIndex();
                    visibleIndex = Math.min(visibleIndex, this.getColumnCount() - 1);
                    this.moveColumn(colIdx, visibleIndex);
                }
                catch (Exception exp) {
                    NLogger.error("USER_INTERFACE", (Object)exp, (Throwable)exp);
                }
            }
        }
        Iterator iterator = newColumnList.iterator();
        while (iterator.hasNext()) {
            FWTableColumn column = (FWTableColumn)iterator.next();
            int currentIdx = this.getColumnIndex(column.getIdentifier());
            int newIdx = Math.min(tableModel.mapColumnIDToModelIndex((Integer)column.getIdentifier()), this.getColumnCount() - 1);
            this.moveColumn(currentIdx, newIdx);
        }
    }

    private class VisibleTableColumnComparator
    implements Comparator {
        private VisibleTableColumnComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            FWTableColumn col1 = (FWTableColumn)obj1;
            FWTableColumn col2 = (FWTableColumn)obj2;
            if (!col1.isVisible()) {
                return -1;
            }
            if (!col2.isVisible()) {
                return 1;
            }
            int col1Idx = FWTableColumnModel.this.getColumnIndex(col1.getIdentifier());
            int col2Idx = FWTableColumnModel.this.getColumnIndex(col2.getIdentifier());
            return col1Idx - col2Idx;
        }
    }
}

