/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import phex.xml.sax.gui.DTableColumn;

public class FWTableColumn
extends TableColumn {
    private boolean isVisible;
    private boolean isHideable;
    private boolean isSortingAscending;

    public FWTableColumn(int modelIndex, Object headerValue, Integer identifier) {
        super(modelIndex);
        this.setHeaderValue(headerValue);
        this.setIdentifier(identifier);
        this.isVisible = true;
        this.isHideable = true;
        this.isSortingAscending = false;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isHideable() {
        return this.isHideable;
    }

    public void setHideable(boolean state) {
        this.isHideable = state;
    }

    public void setVisible(boolean state) {
        this.isVisible = state;
    }

    public boolean reverseSortingOrder() {
        this.isSortingAscending = !this.isSortingAscending;
        return this.isSortingAscending;
    }

    public void sizeWidthToFitData(JTable table, TableModel model) {
        TableCellRenderer aCellRenderer = this.cellRenderer;
        if (this.cellRenderer == null) {
            aCellRenderer = table.getDefaultRenderer(model.getColumnClass(this.modelIndex));
        }
        int maxWidth = 0;
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object value = model.getValueAt(i, this.modelIndex);
            Component component = aCellRenderer.getTableCellRendererComponent(table, value, false, false, i, this.modelIndex);
            maxWidth = Math.max(component.getPreferredSize().width + 4, maxWidth);
        }
        this.setPreferredWidth(maxWidth);
    }

    public DTableColumn createDGuiTableColumn() {
        DTableColumn dColumn = new DTableColumn();
        dColumn.setColumnID((Integer)this.getIdentifier());
        dColumn.setVisible(this.isVisible);
        dColumn.setWidth(this.getWidth());
        return dColumn;
    }
}

