/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.statusbar;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.common.format.NumberFormatUtils;
import phex.gui.common.GUIRegistry;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.upload.UploadManager;
import phex.utils.Localizer;

public class UploadZone
extends JPanel {
    private UploadManager uploadMgr;
    private StatisticsManager statsMgr;
    private BandwidthManager bwMgr;
    private JLabel uploadLabel;
    private JLabel bwLabel;

    public UploadZone() {
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.uploadMgr = UploadManager.getInstance();
        this.statsMgr = StatisticsManager.getInstance();
        this.bwMgr = BandwidthManager.getInstance();
        this.uploadLabel = new JLabel();
        this.uploadLabel.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("UploadSmall"));
        this.add(this.uploadLabel);
        this.bwLabel = new JLabel();
        this.add(this.bwLabel);
        this.updateZone();
        layout.putConstraint("North", (Component)this.uploadLabel, 3, "North", (Component)this);
        layout.putConstraint("West", (Component)this.uploadLabel, 5, "West", (Component)this);
        layout.putConstraint("West", (Component)this.bwLabel, 5, "East", (Component)this.uploadLabel);
        layout.putConstraint("North", (Component)this.bwLabel, 3, "North", (Component)this);
        layout.putConstraint("East", (Component)this, 5, "East", (Component)this.bwLabel);
    }

    public void updateZone() {
        StatisticProvider uploadCountProvider = this.statsMgr.getStatisticProvider("SessionUploadCountProvider");
        Object[] args = new Object[]{new Integer(this.uploadMgr.getUploadingCount()), new Integer(this.uploadMgr.getUploadQueueSize()), uploadCountProvider.getValue()};
        String text = Localizer.getFormatedString("StatusBar_Uploads", args);
        this.uploadLabel.setText(text);
        this.uploadLabel.setToolTipText(Localizer.getString("StatusBar_TTTUploads"));
        BandwidthController bwController = this.bwMgr.getUploadBandwidthController();
        long transferRate = bwController.getShortTransferAvg().getAverage();
        long throttlingRate = bwController.getThrottlingRate();
        String transferRateStr = NumberFormatUtils.formatSignificantByteSize(transferRate);
        String throttlingRateStr = throttlingRate == Integer.MAX_VALUE ? Localizer.getDecimalFormatSymbols().getInfinity() : NumberFormatUtils.formatSignificantByteSize(throttlingRate);
        this.bwLabel.setText(transferRateStr + Localizer.getString("PerSec") + " (" + throttlingRateStr + ")");
        this.validate();
    }
}

