/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.statusbar;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import phex.connection.NetworkManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconFactory;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.utils.Localizer;

public class ConnectionsZone
extends JPanel {
    private NetworkHostsContainer hostsContainer;
    private NetworkManager networkMgr;
    private JLabel connectionLabel;
    private Icon connectedIcon;
    private Icon firewalledIcon;
    private Icon disconnectedIcon;

    public ConnectionsZone() {
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.networkMgr = NetworkManager.getInstance();
        HostManager hostMgr = HostManager.getInstance();
        this.hostsContainer = hostMgr.getNetworkHostsContainer();
        IconFactory factory = GUIRegistry.getInstance().getIconFactory();
        this.connectedIcon = factory.getIcon("Network");
        this.firewalledIcon = factory.getIcon("Firewalled");
        this.disconnectedIcon = factory.getIcon("Disconnect");
        this.connectionLabel = new JLabel();
        this.connectionLabel.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("UploadSmall"));
        this.add(this.connectionLabel);
        this.updateZone();
        layout.putConstraint("North", (Component)this.connectionLabel, 2, "North", (Component)this);
        layout.putConstraint("West", (Component)this.connectionLabel, 5, "West", (Component)this);
        layout.putConstraint("East", (Component)this, 5, "East", (Component)this.connectionLabel);
        layout.putConstraint("South", (Component)this, 2, "South", (Component)this.connectionLabel);
    }

    public void updateZone() {
        int hostCount = this.hostsContainer.getTotalConnectionCount();
        if (hostCount > 0) {
            if (this.networkMgr.hasConnectedIncoming()) {
                this.connectionLabel.setIcon(this.connectedIcon);
            } else {
                this.connectionLabel.setIcon(this.firewalledIcon);
            }
        } else {
            this.connectionLabel.setIcon(this.disconnectedIcon);
        }
        Object[] args = new Object[]{new Integer(hostCount)};
        String text = Localizer.getFormatedString("StatusBar_Connections", args);
        this.connectionLabel.setText(text);
        this.connectionLabel.setToolTipText(Localizer.getString("StatusBar_TTTConnections"));
        this.validate();
    }
}

