/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.UIManager;
import phex.gui.actions.FWAction;
import phex.gui.common.PhexColors;

public class LinkLabel
extends JLabel
implements MouseListener {
    private boolean isFontBold;
    private boolean isRollover;
    private Action action;

    public LinkLabel(FWAction linkAction) {
        super((String)linkAction.getValue("Name"));
        this.action = linkAction;
        this.registerActionChangeListener(this.action);
        this.setToolTipText((String)this.action.getValue("ToolTipText"));
        this.setEnabled(this.action.isEnabled());
        this.isRollover = false;
        this.isFontBold = false;
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEnabled()) {
            g.drawLine(0, this.getHeight() - 2, this.getWidth(), this.getHeight() - 2);
        }
    }

    public void setFontBold(boolean isBold) {
        this.isFontBold = isBold;
        Font currentFont = this.getFont();
        if (currentFont.isBold() != this.isFontBold) {
            if (this.isFontBold) {
                this.setFont(UIManager.getFont("Label.font").deriveFont(1));
            } else {
                this.setFont(UIManager.getFont("Label.font"));
            }
        }
    }

    public void initialize() {
        this.setFontBold(this.isFontBold);
    }

    public void updateUI() {
        super.updateUI();
        this.initialize();
    }

    public Color getForeground() {
        if (this.isRollover) {
            return PhexColors.getLinkLabelRolloverForeground();
        }
        return super.getForeground();
    }

    private void registerActionChangeListener(Action a) {
        ActionChangedListener actionPropertyChangeListener = new ActionChangedListener();
        a.addPropertyChangeListener(actionPropertyChangeListener);
    }

    public void mouseEntered(MouseEvent e) {
        this.isRollover = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.isRollover = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (this.action != null) {
            this.action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        ActionChangedListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("Name")) {
                String text = (String)e.getNewValue();
                LinkLabel.this.setText(text);
                LinkLabel.this.repaint();
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                LinkLabel.this.setEnabled(enabledState);
                LinkLabel.this.repaint();
            } else if (propertyName.equals("ToolTipText")) {
                String text = (String)e.getNewValue();
                LinkLabel.this.setToolTipText(text);
                LinkLabel.this.repaint();
            }
        }
    }
}

