/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class LazyEventQueue {
    public static final int MAX_EVENT_COUNT = 20;
    public ArrayList tableModelEventList = new ArrayList(20);
    public ArrayList listDataEventList = new ArrayList(20);
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public LazyEventQueue() {
        ActionListener fireLazyEventAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LazyEventQueue.this.fireLazyEvents();
            }
        };
        Timer timer = new Timer(1000, fireLazyEventAction);
        timer.start();
    }

    public synchronized void addTableModelEvent(TableModelEvent event) {
        boolean isNew = true;
        Object source = event.getSource();
        int type = event.getType();
        int firstRow = event.getFirstRow();
        int lastRow = event.getLastRow();
        int column = event.getColumn();
        for (int i = 0; i < this.tableModelEventList.size(); ++i) {
            TableModelEvent inEvent = (TableModelEvent)this.tableModelEventList.get(i);
            Object inSource = inEvent.getSource();
            if (source != inSource || type != inEvent.getType() || column != inEvent.getColumn()) continue;
            if (firstRow >= inEvent.getFirstRow() && lastRow <= inEvent.getLastRow()) {
                isNew = false;
                break;
            }
            if (firstRow + 1 != inEvent.getFirstRow() && lastRow - 1 != inEvent.getLastRow()) continue;
            int newFirstRow = Math.min(firstRow, inEvent.getFirstRow());
            int newLastRow = Math.max(lastRow, inEvent.getLastRow());
            TableModelEvent newEvent = new TableModelEvent((TableModel)source, newFirstRow, newLastRow, column, type);
            this.tableModelEventList.remove(inEvent);
            this.addTableModelEvent(newEvent);
            isNew = false;
            break;
        }
        if (isNew) {
            this.tableModelEventList.add(event);
            if (this.tableModelEventList.size() > 20) {
                this.fireTableModelEvents();
            }
        }
    }

    public synchronized void addListDataEvent(ListDataEvent event) {
        boolean isNew = true;
        Object source = event.getSource();
        int type = event.getType();
        int firstRow = event.getIndex0();
        int lastRow = event.getIndex1();
        for (int i = 0; i < this.listDataEventList.size(); ++i) {
            ListDataEvent inEvent = (ListDataEvent)this.listDataEventList.get(i);
            Object inSource = inEvent.getSource();
            if (source != inSource || type != inEvent.getType()) continue;
            if (firstRow >= inEvent.getIndex0() && lastRow <= inEvent.getIndex1()) {
                isNew = false;
                break;
            }
            if (firstRow + 1 != inEvent.getIndex0() && lastRow - 1 != inEvent.getIndex1()) continue;
            int newFirstRow = Math.min(firstRow, inEvent.getIndex0());
            int newLastRow = Math.max(lastRow, inEvent.getIndex1());
            ListDataEvent newEvent = new ListDataEvent((ListModel)source, type, newFirstRow, newLastRow);
            this.listDataEventList.remove(inEvent);
            this.addListDataEvent(newEvent);
            isNew = false;
            break;
        }
        if (isNew) {
            this.listDataEventList.add(event);
            if (this.listDataEventList.size() > 20) {
                this.fireListDataEvents();
            }
        }
    }

    public synchronized void fireLazyEvents() {
        this.fireTableModelEvents();
        this.fireListDataEvents();
    }

    private synchronized void fireListDataEvents() {
        int size = this.listDataEventList.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            ListDataEvent event = (ListDataEvent)this.listDataEventList.get(i);
            AbstractListModel model = (AbstractListModel)event.getSource();
            EventListener[] listeners = model.getListeners(class$javax$swing$event$ListDataListener == null ? LazyEventQueue.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener);
            for (int x = listeners.length - 1; x >= 0; --x) {
                ListDataListener listener = (ListDataListener)listeners[x];
                if (event.getType() == 0) {
                    listener.contentsChanged(event);
                    continue;
                }
                if (event.getType() == 1) {
                    listener.intervalAdded(event);
                    continue;
                }
                if (event.getType() != 2) continue;
                listener.intervalRemoved(event);
            }
        }
        this.listDataEventList.clear();
    }

    private synchronized void fireTableModelEvents() {
        int size = this.tableModelEventList.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            TableModelEvent event = (TableModelEvent)this.tableModelEventList.get(i);
            AbstractTableModel model = (AbstractTableModel)event.getSource();
            model.fireTableChanged(event);
        }
        this.tableModelEventList.clear();
    }
}

