/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerTextField
extends JTextField {
    private int maxChar;

    public IntegerTextField(int charLimit) {
        this(null, charLimit, charLimit);
    }

    public IntegerTextField(int columns, int charLimit) {
        this(null, columns, charLimit);
    }

    public IntegerTextField(String string, int columns, int charLimit) {
        super(columns);
        this.setHorizontalAlignment(4);
        this.maxChar = charLimit;
        this.setText(string);
    }

    public Integer getIntegerValue() {
        String text = this.getText();
        try {
            Integer integer = new Integer(text);
            return integer;
        }
        catch (NumberFormatException exp) {
            return null;
        }
    }

    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    class IntegerDocument
    extends PlainDocument {
        IntegerDocument() {
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            int tomuch = str.length() + this.getLength() - IntegerTextField.this.maxChar;
            if (tomuch > 0) {
                str = str.substring(0, str.length() - tomuch);
                Toolkit.getDefaultToolkit().beep();
            }
            char[] orgCharArr = str.toCharArray();
            char[] addCharArr = new char[orgCharArr.length];
            int j = 0;
            for (int i = 0; i < orgCharArr.length; ++i) {
                if (!Character.isDigit(orgCharArr[i])) continue;
                addCharArr[j] = orgCharArr[i];
                ++j;
            }
            super.insertString(offset, new String(addCharArr, 0, j), a);
        }
    }
}

