/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.util.ArrayList;
import java.util.Iterator;
import phex.gui.actions.ExitPhexAction;
import phex.gui.common.DesktopIndicatorListener;
import phex.utils.Localizer;

public class DesktopIndicator {
    private static boolean isNativeLibLoaded = true;
    private int image;
    private String tooltip;
    private final ArrayList listeners = new ArrayList();
    private int handler = 0;

    public DesktopIndicator() throws UnsupportedOperationException {
        if (!isNativeLibLoaded) {
            throw new UnsupportedOperationException("Cant load Phex.dll");
        }
        this.image = DesktopIndicator.nativeLoadImageIDStrFromResource("Phex");
        this.tooltip = Localizer.getString("TTTSysTray");
        this.showIndicator();
        this.hideIndicator();
    }

    public static void freeImage(int image) {
        try {
            DesktopIndicator.nativeFreeImage(image);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public static int loadImage(String filename) {
        try {
            return DesktopIndicator.nativeLoadImage(filename);
        }
        catch (UnsatisfiedLinkError x) {
            return -1;
        }
    }

    public void showIndicator() {
        this.setNativeMenuText(Localizer.getString("OpenPhex"), Localizer.getString("ExitPhex"));
        this.nativeEnable(this.image, this.tooltip);
    }

    public void hideIndicator() {
        this.nativeHide();
    }

    public void removeIndicator() {
        this.nativeDisable();
    }

    public void update(int image, String tooltip) {
        this.image = image;
        this.tooltip = tooltip;
        try {
            this.nativeEnable(image, tooltip);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private synchronized native void setNativeMenuText(String var1, String var2) throws UnsatisfiedLinkError;

    private synchronized native void nativeEnable(int var1, String var2) throws UnsatisfiedLinkError;

    private synchronized native void nativeHide() throws UnsatisfiedLinkError;

    private synchronized native void nativeDisable() throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImage(String var0) throws UnsatisfiedLinkError;

    private static synchronized native void nativeFreeImage(int var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImageIDFromResource(int var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImageIDStrFromResource(String var0) throws UnsatisfiedLinkError;

    public void addDesktopIndicatorListener(DesktopIndicatorListener listener) {
        this.listeners.add(listener);
    }

    public void removeDesktopIndicatorListener(DesktopIndicatorListener listener) {
        this.listeners.remove(listener);
    }

    public void fireClicked() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DesktopIndicatorListener listener = (DesktopIndicatorListener)iterator.next();
            listener.onDesktopIndicatorClicked(this);
        }
    }

    public void exitApplication() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        ExitPhexAction.shutdown();
    }

    static {
        try {
            System.loadLibrary("Phex");
        }
        catch (UnsatisfiedLinkError x) {
            isNativeLibLoaded = false;
        }
    }
}

