/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import phex.gui.common.PhexColors;
import phex.utils.NLogger;

public class BoxPanel
extends JPanel {
    private BoxHeader boxHeader;
    private JPanel contentPanel;
    private boolean isContentShown = true;

    public BoxPanel(String headerText) {
        super(new BorderLayout());
        this.boxHeader = new BoxHeader(headerText, this);
        this.add((Component)this.boxHeader, "North");
        this.contentPanel = new JPanel();
        this.add((Component)this.contentPanel, "Center");
        this.initialize();
    }

    private void initialize() {
        UIDefaults defaults = UIManager.getDefaults();
        if (defaults == null) {
            NLogger.error("USER_INTERFACE", "UIManager defaults are null!");
            return;
        }
        Color color = (Color)defaults.get("window");
        if (color == null) {
            NLogger.error("USER_INTERFACE", "Failed to get default color: window. Using White.");
            color = Color.WHITE;
        }
        Color newColor = new Color(color.getRGB());
        Color boxPanelBorderColor = PhexColors.getBoxPanelBorderColor();
        if (boxPanelBorderColor == null) {
            NLogger.error("USER_INTERFACE", "Failed to get Phex color: BoxPanelBorderColor.");
            boxPanelBorderColor = Color.BLACK;
        }
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(6, 6, 6, 6, newColor), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, boxPanelBorderColor), BorderFactory.createMatteBorder(1, 1, 1, 1, newColor))));
        Color boxPanelBackground = PhexColors.getBoxPanelBackground();
        if (boxPanelBackground == null) {
            NLogger.error("USER_INTERFACE", "Failed to get Phex color: BoxPanelBackground.");
            boxPanelBackground = Color.GRAY;
        }
        int rgbValue = boxPanelBackground.getRGB();
        newColor = new Color(rgbValue);
        this.setBackground(newColor);
        if (this.contentPanel != null) {
            this.contentPanel.setBackground(newColor);
            this.contentPanel.repaint();
        }
    }

    public void setHeaderText(String headerText) {
        this.boxHeader.setHeaderText(headerText);
    }

    public void setShowContent(boolean showContent) {
        if (this.isContentShown != showContent) {
            this.isContentShown = showContent;
            this.contentPanel.setVisible(this.isContentShown);
            this.repaint();
        }
    }

    public void setContentLayout(LayoutManager mgr) {
        this.contentPanel.setLayout(mgr);
    }

    public void addContent(Component comp, GridBagConstraints constraints) {
        this.contentPanel.add(comp, constraints);
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void updateUI() {
        super.updateUI();
        if (this.contentPanel != null) {
            this.initialize();
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension max = this.getMaximumSize();
        Dimension pref = super.getPreferredSize();
        pref.height = Math.min(pref.height, max.height);
        pref.width = Math.min(pref.width, max.width);
        return pref;
    }

    static class BoxHeader
    extends JComponent
    implements MouseListener {
        private String headerText;
        private boolean isRollover;
        private BoxPanel boxPanel;
        private static Rectangle viewRect = new Rectangle();
        private static Rectangle textRect = new Rectangle();
        private static Rectangle iconRect = new Rectangle();

        public BoxHeader(String headerText, BoxPanel boxPanel) {
            this.headerText = headerText;
            this.boxPanel = boxPanel;
            this.isRollover = false;
            this.addMouseListener(this);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.initialize();
        }

        public void initialize() {
            this.setBackground(PhexColors.getBoxHeaderBackground());
            this.setFont(UIManager.getFont("Label.font").deriveFont(1));
        }

        public void updateUI() {
            super.updateUI();
            this.initialize();
        }

        public void setHeaderText(String headerText) {
            this.headerText = headerText;
            this.invalidate();
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Font font = this.getFont();
            FontMetrics fm = this.getFontMetrics(font);
            BoxHeader.viewRect.width = Short.MAX_VALUE;
            BoxHeader.viewRect.height = Short.MAX_VALUE;
            SwingUtilities.layoutCompoundLabel(this, fm, this.headerText, null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
            Insets insets = this.getInsets();
            BoxHeader.textRect.width += insets.left + insets.right + 10;
            BoxHeader.textRect.height += insets.top + insets.bottom + 8;
            return textRect.getSize();
        }

        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Insets i = this.getInsets();
            BoxHeader.viewRect.x = i.left;
            BoxHeader.viewRect.y = i.top;
            BoxHeader.viewRect.width = this.getWidth() - (i.right + BoxHeader.viewRect.x);
            BoxHeader.viewRect.height = this.getHeight() - (i.bottom + BoxHeader.viewRect.y);
            Graphics2D g2 = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, PhexColors.getBoxHeaderGradientFrom(), 0.0f, this.getHeight(), PhexColors.getBoxHeaderGradientTo());
            g2.setPaint(gradient);
            g2.fillRect(BoxHeader.viewRect.x, BoxHeader.viewRect.y, BoxHeader.viewRect.width, BoxHeader.viewRect.height - 2);
            UIDefaults defaults = UIManager.getDefaults();
            Color color = (Color)defaults.get("window");
            g2.setColor(color);
            g2.fillRect(i.left, this.getHeight() - (i.bottom + i.top + 2), this.getWidth() - (i.right + i.left), 1);
            FontMetrics fm = g.getFontMetrics();
            BoxHeader.textRect.height = 0;
            BoxHeader.textRect.width = 0;
            BoxHeader.textRect.y = 0;
            BoxHeader.textRect.x = 0;
            BoxHeader.iconRect.height = 0;
            BoxHeader.iconRect.width = 0;
            BoxHeader.iconRect.y = 0;
            BoxHeader.iconRect.x = 0;
            String text = SwingUtilities.layoutCompoundLabel(this, fm, this.headerText, null, 0, 0, 0, 0, viewRect, iconRect, textRect, 0);
            this.paintText(g, textRect, text);
        }

        protected void paintText(Graphics g, Rectangle textRect, String text) {
            FontMetrics fm = g.getFontMetrics();
            if (this.isRollover) {
                g.setColor(PhexColors.getLinkLabelRolloverForeground());
            } else {
                g.setColor(this.getForeground());
            }
            g.drawString(text, textRect.x, textRect.y + fm.getAscent());
        }

        public void mouseEntered(MouseEvent e) {
            this.isRollover = true;
            this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.isRollover = false;
            this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            this.boxPanel.setShowContent(!this.boxPanel.isContentShown);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

