/*
 * Decompiled with CFR 0.152.
 */
package phex.event;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;

public class EventListenerList
implements Serializable {
    private static final Object[] NULL_ARRAY = new Object[0];
    protected transient Object[] listenerList = NULL_ARRAY;

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public EventListener[] getListeners(Class t) {
        Object[] lList = this.listenerList;
        int n = this.getListenerCount(lList, t);
        EventListener[] result = (EventListener[])Array.newInstance(t, n);
        int j = 0;
        for (int i = lList.length - 2; i >= 0; i -= 2) {
            if (lList[i] != t) continue;
            result[j++] = (EventListener)lList[i + 1];
        }
        return result;
    }

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class t) {
        Object[] lList = this.listenerList;
        return this.getListenerCount(lList, t);
    }

    private int getListenerCount(Object[] list, Class t) {
        int count = 0;
        for (int i = 0; i < list.length; i += 2) {
            if (t != (Class)list[i]) continue;
            ++count;
        }
        return count;
    }

    public synchronized void add(Class t, EventListener l) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{t, l};
        } else {
            int i = this.listenerList.length;
            Object[] tmp = new Object[i + 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, i);
            tmp[i] = t;
            tmp[i + 1] = l;
            this.listenerList = tmp;
        }
    }

    public synchronized void remove(Class t, EventListener l) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        int index = -1;
        for (int i = this.listenerList.length - 2; i >= 0; i -= 2) {
            if (this.listenerList[i] != t || !this.listenerList[i + 1].equals(l)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            Object[] tmp = new Object[this.listenerList.length - 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.listenerList, index + 2, tmp, index, tmp.length - index);
            }
            this.listenerList = tmp.length == 0 ? NULL_ARRAY : tmp;
        }
    }

    public String toString() {
        Object[] lList = this.listenerList;
        String s = "EventListenerList: ";
        s = s + lList.length / 2 + " listeners: ";
        for (int i = 0; i <= lList.length - 2; i += 2) {
            s = s + " type " + ((Class)lList[i]).getName();
            s = s + " listener " + lList[i + 1];
        }
        return s;
    }
}

