/*
 * Decompiled with CFR 0.152.
 */
package phex.event;

import java.awt.EventQueue;
import java.util.Stack;
import phex.common.ThreadTracking;
import phex.utils.NLogger;

public final class AsynchronousDispatcher {
    private static DispatcherRunnable dispatcherRunnable;

    private AsynchronousDispatcher() {
    }

    public static void invokeLater(Runnable runnable) {
        if (dispatcherRunnable == null) {
            EventQueue.invokeLater(runnable);
        } else {
            dispatcherRunnable.invokeLater(runnable);
        }
    }

    public static void enableDispatcherThread() {
        if (dispatcherRunnable != null) {
            dispatcherRunnable = new DispatcherRunnable();
            Thread thread = new Thread(ThreadTracking.rootThreadGroup, dispatcherRunnable, "DispatcherRunnable-" + Integer.toHexString(dispatcherRunnable.hashCode()));
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static class DispatcherRunnable
    implements Runnable {
        private Stack stack;

        private DispatcherRunnable() {
        }

        public void run() {
            this.stack = new Stack();
            while (true) {
                try {
                    while (true) {
                        if (!this.stack.empty()) {
                            Runnable runnable = (Runnable)this.stack.pop();
                            runnable.run();
                            continue;
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException exp) {
                    continue;
                }
                catch (Throwable th) {
                    NLogger.error("USER_INTERFACE", (Object)th, th);
                    continue;
                }
                break;
            }
        }

        public synchronized void invokeLater(Runnable runnable) {
            this.stack.add(runnable);
            this.notify();
        }
    }
}

