/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.Environment;
import phex.common.FileHandlingException;
import phex.common.IntObj;
import phex.common.MediaType;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.TransferDataProvider;
import phex.common.URN;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.MagnetData;
import phex.download.RatedDownloadScopeList;
import phex.download.RemoteFile;
import phex.download.strategy.ScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategyProvider;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadWorker;
import phex.download.swarming.SwarmingManager;
import phex.event.AsynchronousDispatcher;
import phex.event.DownloadCandidatesChangeListener;
import phex.event.DownloadSegmentsChangeListener;
import phex.event.EventListenerList;
import phex.http.HTTPRangeSet;
import phex.query.ResearchSetting;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticsManager;
import phex.utils.Executer;
import phex.utils.FileUtils;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBDownloadScope;
import phex.xml.XJBSWDownloadCandidate;
import phex.xml.XJBSWDownloadFile;
import phex.xml.XJBSWDownloadSegment;

public class SWDownloadFile
implements TransferDataProvider,
SWDownloadConstants {
    private static Random random;
    private DownloadScopeList missingScopeList;
    private DownloadScopeList blockedScopeList;
    private DownloadScopeList finishedScopeList;
    private RatedDownloadScopeList ratedScopeList;
    private long ratedScopeListBuildTime;
    private AltLocContainer goodAltLocContainer;
    private AltLocContainer badAltLocContainer;
    private Object candidatesLock = new Object();
    private ArrayList allCandidatesList;
    private ArrayList goodCandidatesList;
    private ArrayList mediumCandidatesList;
    private ArrayList badCandidatesList;
    private int goodCandidatePosition = 0;
    private int mediumCandidatePosition = 0;
    private int badCandidatePosition = 0;
    private ArrayList transferCandidatesList;
    private Set queuedCandidatesSet;
    private LinkedMap allocatedCandidateWorkerMap;
    private IntObj candidateCountObj;
    private int downloadingCandidateCount = 0;
    private int queuedCandidateCount = 0;
    private int connectingCandidateCount = 0;
    private long lastCandidateWorkerCountUpdate = 0L;
    private static final int CANDIDATE_WORKER_COUNT_TIMEOUT = 2000;
    private long fileSize;
    private File destinationFile;
    private boolean isDestStreamable;
    private File incompleteFile;
    private Date createdDate;
    private Date modifiedDate;
    private short status = 1;
    private long transferStartTime;
    private long transferStopTime;
    private long transferredDataSize;
    private long transferDataUpdateTime;
    private Integer currentProgress;
    private short workerCount;
    private URN fileURN;
    private URI downloadURI;
    private ResearchSetting researchSetting;
    private long previewSize;
    private BandwidthController bandwidthController;
    private ScopeSelectionStrategy scopeSelectionStrategy;
    private EventListenerList listenerList = new EventListenerList();
    static final /* synthetic */ boolean $assertionsDisabled;

    private SWDownloadFile() {
        this.allCandidatesList = new ArrayList();
        this.goodCandidatesList = new ArrayList();
        this.mediumCandidatesList = new ArrayList();
        this.badCandidatesList = new ArrayList();
        this.transferCandidatesList = new ArrayList();
        this.queuedCandidatesSet = new HashSet();
        this.allocatedCandidateWorkerMap = new LinkedMap();
        this.candidateCountObj = new IntObj(0);
        this.currentProgress = new Integer(0);
        this.createdDate = this.modifiedDate = new Date(System.currentTimeMillis());
        this.bandwidthController = BandwidthController.acquireBandwidthController("DownloadFile-" + this.toString(), Long.MAX_VALUE);
        this.bandwidthController.activateShortTransferAvg(1000, 15);
        this.bandwidthController.linkControllerIntoChain(BandwidthManager.getInstance().getDownloadBandwidthController());
    }

    public SWDownloadFile(String fullLocalFilename, String searchString, long aFileSize, URN aFileURN) {
        this();
        this.initialize(fullLocalFilename, aFileURN, aFileSize, searchString, true);
        try {
            this.initIncompleteFile();
        }
        catch (FileHandlingException exp) {
            NLogger.error("Download", (Object)exp, (Throwable)exp);
        }
    }

    public SWDownloadFile(URI downloadUri) throws URIException {
        this();
        this.downloadURI = downloadUri;
        String protocol = this.downloadURI.getScheme();
        if ("magnet".equals(protocol)) {
            MagnetData magnetData = MagnetData.parseFromURI(this.downloadURI);
            URN urn = MagnetData.lookupSHA1URN(magnetData);
            String fileName = MagnetData.lookupFileName(magnetData);
            String fullfileName = ServiceManager.sCfg.mDownloadDir + File.separator + FileUtils.convertToLocalSystemFilename(fileName);
            String searchTerm = magnetData.getKeywordTopic() != null ? magnetData.getKeywordTopic() : StringUtils.createNaturalSearchTerm(MagnetData.lookupSearchName(magnetData));
            this.initialize(fullfileName, urn, -1L, searchTerm, true);
            try {
                this.initIncompleteFile();
            }
            catch (FileHandlingException exp) {
                NLogger.error("Download", (Object)exp, (Throwable)exp);
            }
            List urlList = MagnetData.lookupHttpURIs(magnetData);
            Iterator iterator = urlList.iterator();
            while (iterator.hasNext()) {
                URI uri = (URI)iterator.next();
                String host = uri.getHost();
                int port = uri.getPort();
                if (port == -1) {
                    port = 80;
                }
                DefaultDestAddress address = new DefaultDestAddress(host, port);
                SWDownloadCandidate candidate = new SWDownloadCandidate(address, uri, this);
                this.addDownloadCandidate(candidate);
            }
            if (urn != null || this.getCandidatesCount() == 0) {
                this.startSearchForCandidates();
            }
        } else {
            String fileName = URLUtil.getFileNameFromUri(this.downloadURI);
            String fullfileName = ServiceManager.sCfg.mDownloadDir + File.separator + FileUtils.convertToLocalSystemFilename(fileName);
            String searchTerm = StringUtils.createNaturalSearchTerm(fileName);
            this.initialize(fullfileName, null, -1L, searchTerm, true);
            try {
                this.initIncompleteFile();
            }
            catch (FileHandlingException exp) {
                NLogger.error("Download", (Object)exp, (Throwable)exp);
            }
            String host = this.downloadURI.getHost();
            if (host != null) {
                int port = this.downloadURI.getPort();
                if (port == -1) {
                    port = 80;
                }
                DefaultDestAddress address = new DefaultDestAddress(host, port);
                SWDownloadCandidate candidate = new SWDownloadCandidate(address, this.downloadURI, this);
                this.addDownloadCandidate(candidate);
            }
        }
    }

    public SWDownloadFile(XJBSWDownloadFile xjbFile) {
        this();
        URN fileUrn = null;
        if (xjbFile.getFileURN() != null) {
            fileUrn = new URN(xjbFile.getFileURN());
        }
        this.initialize(ServiceManager.sCfg.mDownloadDir + File.separator + xjbFile.getLocalFileName(), fileUrn, xjbFile.getFileSize(), xjbFile.getSearchTerm(), false);
        String incompleteFileName = xjbFile.getIncompleteFileName();
        if (!StringUtils.isEmpty(incompleteFileName)) {
            this.incompleteFile = new File(incompleteFileName);
        }
        this.setCreatedDate(new Date(xjbFile.getCreatedTime()));
        this.setDownloadedDate(new Date(xjbFile.getModifiedTime()));
        this.setScopeSelectionStrategy(ScopeSelectionStrategyProvider.getByClassName(xjbFile.getScopeSelectionStrategy()));
        this.status = xjbFile.getStatus();
        this.createDownloadScopes(xjbFile);
        this.createDownloadCandidates(xjbFile);
        this.forceCollectionOfTransferData();
        this.verifyStatus();
        if (this.isFileCompletedOrMoved()) {
            this.transferredDataSize = this.fileSize;
            if (this.isFileCompleted() && this.finishedScopeList.getAggregatedLength() == 0L) {
                this.setStatus((short)6);
            }
        }
    }

    private void initialize(String fullLocalFilename, URN aFileURN, long aFileSize, String searchTerm, boolean createSegments) {
        this.destinationFile = new File(fullLocalFilename);
        this.updateDestinationData();
        this.scopeSelectionStrategy = ScopeSelectionStrategyProvider.getAvailBeginRandSelectionStrategy();
        if (aFileURN != null) {
            this.fileURN = aFileURN;
            this.initAltLocContainers();
        }
        this.fileSize = aFileSize;
        this.previewSize = this.fileSize / 10L;
        this.researchSetting = new ResearchSetting(this);
        this.researchSetting.setSearchTerm(searchTerm);
        this.missingScopeList = new DownloadScopeList();
        this.blockedScopeList = new DownloadScopeList();
        this.finishedScopeList = new DownloadScopeList();
        if (this.fileSize == -1L) {
            this.missingScopeList.add(new DownloadScope(0L, Long.MAX_VALUE));
        } else {
            this.missingScopeList.add(new DownloadScope(0L, this.fileSize - 1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            this.missingScopeList.remove(new DownloadScope(fileSize, Long.MAX_VALUE));
        }
        downloadScopeList = this.blockedScopeList;
        synchronized (downloadScopeList) {
            this.blockedScopeList.remove(new DownloadScope(fileSize, Long.MAX_VALUE));
        }
        this.previewSize = fileSize / 10L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadFinished() {
        DownloadScopeList downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            return this.isFileCompletedOrMoved() || this.finishedScopeList.getAggregatedLength() == this.fileSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScopeAllocateable(DownloadScopeList candidateScopeList) {
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            if (this.missingScopeList.size() == 0) {
                return false;
            }
            if (this.fileSize != -1L && candidateScopeList != null) {
                DownloadScopeList wantedScopeList = (DownloadScopeList)this.missingScopeList.clone();
                wantedScopeList.retainAll(candidateScopeList);
                return wantedScopeList.size() > 0;
            }
            return true;
        }
    }

    public SWDownloadCandidate allocateDownloadCandidate(SWDownloadWorker worker) {
        int val = random.nextInt(10);
        SWDownloadCandidate candidate = null;
        if (val < 6) {
            candidate = this.allocateGoodCandidate(worker);
            if (candidate == null) {
                candidate = this.allocateMediumCandidate(worker);
            }
            if (candidate == null) {
                candidate = this.allocateBadCandidate(worker);
            }
        } else if (val < 9) {
            candidate = this.allocateMediumCandidate(worker);
            if (candidate == null) {
                candidate = this.allocateBadCandidate(worker);
            }
            if (candidate == null) {
                candidate = this.allocateGoodCandidate(worker);
            }
        } else {
            candidate = this.allocateBadCandidate(worker);
            if (candidate == null) {
                candidate = this.allocateMediumCandidate(worker);
            }
            if (candidate == null) {
                candidate = this.allocateGoodCandidate(worker);
            }
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadCandidate allocateGoodCandidate(SWDownloadWorker worker) {
        SWDownloadCandidate candidate = null;
        Object object = this.candidatesLock;
        synchronized (object) {
            int numCandidates = this.goodCandidatesList.size();
            if (numCandidates == 0) {
                return null;
            }
            if (this.goodCandidatePosition >= numCandidates) {
                this.goodCandidatePosition = 0;
            }
            for (int i = 0; i < numCandidates; ++i) {
                int currentIndex = i + this.goodCandidatePosition;
                if (currentIndex >= numCandidates) {
                    currentIndex -= numCandidates;
                }
                if (!(candidate = (SWDownloadCandidate)this.goodCandidatesList.get(currentIndex)).isAbleToBeAllocated() || this.allocatedCandidateWorkerMap.containsKey(candidate)) continue;
                NLogger.debug("Download.Candidate.Allocate", (Object)("Allocating good candidate " + candidate + " from " + worker));
                candidate.addToCandidateLog("Allocating as good candidate.");
                this.allocatedCandidateWorkerMap.put(candidate, worker);
                this.goodCandidatePosition = currentIndex + 1;
                return candidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadCandidate allocateMediumCandidate(SWDownloadWorker worker) {
        SWDownloadCandidate candidate = null;
        Object object = this.candidatesLock;
        synchronized (object) {
            int numCandidates = this.mediumCandidatesList.size();
            if (numCandidates == 0) {
                return null;
            }
            if (this.mediumCandidatePosition >= numCandidates) {
                this.mediumCandidatePosition = 0;
            }
            for (int i = 0; i < numCandidates; ++i) {
                int currentIndex = i + this.mediumCandidatePosition;
                if (currentIndex >= numCandidates) {
                    currentIndex -= numCandidates;
                }
                if (!(candidate = (SWDownloadCandidate)this.mediumCandidatesList.get(currentIndex)).isAbleToBeAllocated() || this.allocatedCandidateWorkerMap.containsKey(candidate)) continue;
                NLogger.debug("Download.Candidate.Allocate", (Object)("Allocating medium candidate " + candidate + " from " + worker));
                candidate.addToCandidateLog("Allocating as medium candidate.");
                this.allocatedCandidateWorkerMap.put(candidate, worker);
                this.mediumCandidatePosition = currentIndex + 1;
                return candidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadCandidate allocateBadCandidate(SWDownloadWorker worker) {
        SWDownloadCandidate candidate = null;
        Object object = this.candidatesLock;
        synchronized (object) {
            int numCandidates = this.badCandidatesList.size();
            if (numCandidates == 0) {
                return null;
            }
            if (this.badCandidatePosition >= numCandidates) {
                this.badCandidatePosition = 0;
            }
            for (int i = 0; i < numCandidates; ++i) {
                int currentIndex = i + this.badCandidatePosition;
                if (currentIndex >= numCandidates) {
                    currentIndex -= numCandidates;
                }
                if (!(candidate = (SWDownloadCandidate)this.badCandidatesList.get(currentIndex)).isAbleToBeAllocated() || this.allocatedCandidateWorkerMap.containsKey(candidate)) continue;
                NLogger.debug("Download.Candidate.Allocate", (Object)("Allocating bad candidate " + candidate + " from " + worker));
                candidate.addToCandidateLog("Allocating as bad candidate.");
                this.allocatedCandidateWorkerMap.put(candidate, worker);
                this.badCandidatePosition = currentIndex + 1;
                return candidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDownloadCandidate(SWDownloadCandidate candidate) {
        Object object = this.candidatesLock;
        synchronized (object) {
            SwarmingManager.getInstance().releaseCandidateIP(candidate);
            NLogger.debug("Download.Candidate.Allocate", (Object)("Release allocation " + candidate + "."));
            this.allocatedCandidateWorkerMap.remove(candidate);
        }
    }

    public boolean addDownloadCandidate(RemoteFile remoteFile) {
        SWDownloadCandidate candidate = new SWDownloadCandidate(remoteFile, this);
        return this.addDownloadCandidate(candidate);
    }

    public boolean addDownloadCandidate(AlternateLocation altLoc) {
        URN altLocURN = altLoc.getURN();
        if (this.fileURN != null && !altLocURN.equals(this.fileURN)) {
            NLogger.debug("Download_File", (Object)"AlternateLocation URN does not match!");
            return false;
        }
        DestAddress hostAddress = altLoc.getHostAddress();
        if (hostAddress.isLocalHost()) {
            return false;
        }
        SWDownloadCandidate candidate = new SWDownloadCandidate(hostAddress, 0L, null, altLocURN, this);
        return this.addDownloadCandidate(candidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addDownloadCandidate(SWDownloadCandidate candidate) {
        URN candidateURN = candidate.getResourceURN();
        if (this.fileURN == null && candidateURN != null) {
            this.fileURN = candidateURN;
            this.initAltLocContainers();
        }
        if (this.fileURN != null && candidateURN != null && !this.fileURN.equals(candidateURN)) {
            NLogger.debug("Download_File", (Object)"Candidate URN to add does not match!");
            return false;
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            if (this.allCandidatesList.contains(candidate)) {
                return false;
            }
            NLogger.debug("Download_File", (Object)("Adding download candidate " + candidate));
            int pos = this.allCandidatesList.size();
            this.allCandidatesList.add(candidate);
            this.fireDownloadCandidateAdded(pos);
            this.mediumCandidatesList.add(candidate);
        }
        SwarmingManager.getInstance().notifyWaitingWorkers();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateGood(SWDownloadCandidate candidate) {
        if (candidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int pos = this.badCandidatesList.indexOf(candidate);
            if (pos >= 0) {
                this.badCandidatesList.remove(pos);
            }
            if ((pos = this.mediumCandidatesList.indexOf(candidate)) >= 0) {
                this.mediumCandidatesList.remove(pos);
            }
            if (!this.goodCandidatesList.contains(candidate)) {
                this.goodCandidatesList.add(candidate);
                NLogger.debug("Download_File", (Object)("Moving candidate to good list: " + candidate.getHostAddress()));
                candidate.addToCandidateLog("Moving candidate to good list.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateMedium(SWDownloadCandidate candidate) {
        if (candidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int pos = this.badCandidatesList.indexOf(candidate);
            if (pos >= 0) {
                this.badCandidatesList.remove(pos);
            }
            if ((pos = this.goodCandidatesList.indexOf(candidate)) >= 0) {
                this.goodCandidatesList.remove(pos);
            }
            if (!this.mediumCandidatesList.contains(candidate)) {
                this.mediumCandidatesList.add(candidate);
                NLogger.debug("Download_File", (Object)("Moving candidate to medium list: " + candidate.getHostAddress()));
                candidate.addToCandidateLog("Moving candidate to medium list.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateBad(SWDownloadCandidate candidate) {
        if (candidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int pos = this.goodCandidatesList.indexOf(candidate);
            if (pos >= 0) {
                this.goodCandidatesList.remove(pos);
            }
            if ((pos = this.mediumCandidatesList.indexOf(candidate)) >= 0) {
                this.mediumCandidatesList.remove(pos);
            }
            if (!this.badCandidatesList.contains(candidate)) {
                this.badCandidatesList.add(candidate);
                NLogger.debug("Download_File", (Object)("Moving candidate to bad list: " + candidate.getHostAddress()));
                candidate.addToCandidateLog("Moving candidate to bad list.");
            }
        }
        candidate.setStatus((short)11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateIgnored(SWDownloadCandidate candidate, String reason) {
        if (candidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int pos = this.goodCandidatesList.indexOf(candidate);
            if (pos >= 0) {
                this.goodCandidatesList.remove(pos);
            }
            if ((pos = this.mediumCandidatesList.indexOf(candidate)) >= 0) {
                this.mediumCandidatesList.remove(pos);
            }
            if (!this.badCandidatesList.contains(candidate)) {
                this.badCandidatesList.add(candidate);
                NLogger.debug("Download_File", (Object)("Moving candidate to bad list: " + candidate.getHostAddress()));
                candidate.addToCandidateLog("Moving candidate to bad list (ignoring).");
            }
        }
        candidate.setStatus((short)10, -1, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void candidateStatusChanged(SWDownloadCandidate candidate, int oldStatus, int newStatus) {
        Object object = this.candidatesLock;
        synchronized (object) {
            switch (oldStatus) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    this.transferCandidatesList.remove(candidate);
                }
            }
            switch (newStatus) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    this.transferCandidatesList.add(candidate);
                }
            }
        }
        this.fireDownloadCandidateChanged(candidate);
    }

    public void addBadAltLoc(SWDownloadCandidate candidate) {
        URN candidateURN = candidate.getResourceURN();
        if (candidateURN != null && this.fileURN != null) {
            AlternateLocation altLoc = new AlternateLocation(candidate.getHostAddress(), candidateURN);
            this.goodAltLocContainer.removeAlternateLocation(altLoc);
            this.badAltLocContainer.addAlternateLocation(altLoc);
        }
        NLogger.debug("Download_File", (Object)("Adding bad alt loc: " + candidate.getHostAddress()));
    }

    public void addGoodAltLoc(SWDownloadCandidate candidate) {
        URN candidateURN = candidate.getResourceURN();
        if (candidateURN != null && this.fileURN != null) {
            AlternateLocation altLoc = new AlternateLocation(candidate.getHostAddress(), candidateURN);
            this.badAltLocContainer.removeAlternateLocation(altLoc);
            this.goodAltLocContainer.addAlternateLocation(altLoc);
        }
        NLogger.debug("Download_File", (Object)("Adding good alt loc: " + candidate.getHostAddress()));
    }

    public BandwidthController getBandwidthController() {
        return this.bandwidthController;
    }

    public void setDownloadThrottlingRate(int speedInBytes) {
        this.bandwidthController.setThrottlingRate(speedInBytes);
    }

    public long getDownloadThrottlingRate() {
        return this.bandwidthController.getThrottlingRate();
    }

    public long getTransferSpeed() {
        return this.bandwidthController.getShortTransferAvg().getAverage();
    }

    public int getCandidatesCount() {
        return this.allCandidatesList.size();
    }

    public IntObj getCandidatesCountObject() {
        if (this.candidateCountObj.intValue() != this.allCandidatesList.size()) {
            this.candidateCountObj.setValue(this.allCandidatesList.size());
        }
        return this.candidateCountObj;
    }

    public int getDownloadingCandidatesCount() {
        this.updateCandidateWorkerCounts();
        return this.downloadingCandidateCount;
    }

    public int getQueuedCandidatesCount() {
        this.updateCandidateWorkerCounts();
        return this.queuedCandidateCount;
    }

    public int getConnectingCandidatesCount() {
        this.updateCandidateWorkerCounts();
        return this.connectingCandidateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCandidateWorkerCounts() {
        Object object = this.candidatesLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (this.lastCandidateWorkerCountUpdate + 2000L > now) {
                return;
            }
            int downloadingCount = 0;
            int queuedCount = 0;
            int connectingCount = 0;
            Iterator iterator = this.transferCandidatesList.iterator();
            while (iterator.hasNext()) {
                SWDownloadCandidate candidate = (SWDownloadCandidate)iterator.next();
                short status = candidate.getStatus();
                switch (status) {
                    case 20: {
                        ++downloadingCount;
                        break;
                    }
                    case 18: {
                        ++queuedCount;
                        break;
                    }
                    case 16: {
                        ++connectingCount;
                    }
                }
            }
            this.queuedCandidateCount = queuedCount;
            this.downloadingCandidateCount = downloadingCount;
            this.connectingCandidateCount = connectingCount;
            this.lastCandidateWorkerCountUpdate = System.currentTimeMillis();
        }
    }

    public int getGoodCandidateCount() {
        return this.goodCandidatesList.size();
    }

    public int getBadCandidateCount() {
        return this.badCandidatesList.size();
    }

    public SWDownloadCandidate getCandidate(int index) {
        if (index < 0 || index >= this.allCandidatesList.size()) {
            return null;
        }
        return (SWDownloadCandidate)this.allCandidatesList.get(index);
    }

    public AltLocContainer getGoodAltLocContainer() {
        return this.goodAltLocContainer;
    }

    public AltLocContainer getBadAltLocContainer() {
        return this.badAltLocContainer;
    }

    public int getTransferCandidateCount() {
        return this.transferCandidatesList.size();
    }

    public SWDownloadCandidate getTransferCandidate(int index) {
        if (index < 0 || index >= this.transferCandidatesList.size()) {
            return null;
        }
        return (SWDownloadCandidate)this.transferCandidatesList.get(index);
    }

    public void setScopeSelectionStrategy(ScopeSelectionStrategy strategy) {
        this.scopeSelectionStrategy = strategy;
    }

    public ScopeSelectionStrategy getScopeSelectionStrategy() {
        return this.scopeSelectionStrategy;
    }

    public URI getURI() {
        return this.downloadURI;
    }

    public URN getFileURN() {
        return this.fileURN;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    protected void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getDownloadedDate() {
        return this.modifiedDate;
    }

    protected void setDownloadedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPRangeSet createAvailableRangeSet() {
        HTTPRangeSet rangeSet = new HTTPRangeSet();
        DownloadScopeList downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            Iterator iterator = this.finishedScopeList.getScopeIterator();
            while (iterator.hasNext()) {
                DownloadScope scope = (DownloadScope)iterator.next();
                rangeSet.addRange(scope.getStart(), scope.getEnd());
            }
        }
        return rangeSet;
    }

    public ResearchSetting getResearchSetting() {
        return this.researchSetting;
    }

    public void startSearchForCandidates() {
        if (this.isFileCompletedOrMoved()) {
            return;
        }
        this.researchSetting.stopSearch();
        this.researchSetting.startSearch(300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(short newStatus) {
        if (this.status == newStatus) {
            return;
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            NLogger.debug("Download_File", (Object)("DownloadFile Status: " + SWDownloadInfo.getDownloadFileStatusString(newStatus) + " (" + newStatus + ")."));
            switch (newStatus) {
                case 3: {
                    SimpleStatisticProvider provider = (SimpleStatisticProvider)StatisticsManager.getInstance().getStatisticProvider("SessionDownloadCountProvider");
                    provider.increment(1);
                }
                case 1: 
                case 4: {
                    this.downloadStopNotify();
                    break;
                }
                case 2: {
                    this.downloadStartNotify();
                }
            }
            this.status = newStatus;
            SwarmingManager.getInstance().fireDownloadFileChanged(this);
        }
    }

    public short getStatus() {
        return this.status;
    }

    public boolean isAbleToBeAllocated() {
        return !this.isDownloadStopped() && !this.isFileCompletedOrMoved() && this.workerCount <= ServiceManager.sCfg.maxWorkerPerDownload;
    }

    public void incrementWorkerCount() {
        this.workerCount = (short)(this.workerCount + 1);
    }

    public void decrementWorkerCount() {
        this.workerCount = (short)(this.workerCount - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyStatus() {
        this.forceCollectionOfTransferData();
        Object object = this.candidatesLock;
        synchronized (object) {
            if (!this.isFileCompletedOrMoved() && this.getTransferDataSize() == this.getTransferredDataSize()) {
                this.setStatus((short)3);
                this.researchSetting.stopSearch();
                return;
            }
            Iterator iterator = this.allocatedCandidateWorkerMap.keySet().iterator();
            int highestStatus = 12;
            while (iterator.hasNext() && highestStatus != 20) {
                SWDownloadCandidate candidate = (SWDownloadCandidate)iterator.next();
                switch (candidate.getStatus()) {
                    case 20: {
                        highestStatus = 20;
                        break;
                    }
                    case 18: {
                        highestStatus = 18;
                    }
                }
            }
            if (!this.isDownloadStopped() && !this.isFileCompletedOrMoved()) {
                switch (highestStatus) {
                    case 18: {
                        this.setStatus((short)5);
                        break;
                    }
                    case 20: {
                        this.setStatus((short)2);
                        break;
                    }
                    default: {
                        this.setStatus((short)1);
                    }
                }
            }
        }
    }

    public boolean isFileCompleted() {
        return this.status == 3;
    }

    public boolean isFileCompletedMoved() {
        return this.status == 6;
    }

    public boolean isFileCompletedOrMoved() {
        return this.status == 6 || this.status == 3;
    }

    public boolean isDownloadInProgress() {
        return this.status == 2;
    }

    public boolean isDownloadStopped() {
        return this.status == 4;
    }

    public ManagedFile getIncompleteDownloadFile() throws ManagedFileException, FileHandlingException {
        this.initIncompleteFile();
        return FileManager.getInstance().getReadWriteManagedFile(this.incompleteFile);
    }

    public File getIncompleteFile() {
        return this.incompleteFile;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public String getDestinationFileName() {
        return this.destinationFile.getName();
    }

    public boolean isDestinationStreamable() {
        return this.isDestStreamable;
    }

    public void setDestinationFile(File aDestinationFile, boolean rename) throws FileHandlingException {
        if (aDestinationFile.compareTo(this.destinationFile) == 0) {
            return;
        }
        if (rename) {
            if (SwarmingManager.getInstance().isNewLocalFilenameUsed(this, aDestinationFile)) {
                throw new FileHandlingException(1);
            }
            this.initIncompleteFile();
            File newIncompleteFile = SWDownloadFile.createIncompleteFile(aDestinationFile);
            if (this.incompleteFile.exists()) {
                FileUtils.renameLocalFile(this.incompleteFile, newIncompleteFile);
            }
            this.incompleteFile = newIncompleteFile;
            FileUtils.renameLocalFile(this.destinationFile, aDestinationFile);
        }
        this.destinationFile = aDestinationFile;
        this.updateDestinationData();
    }

    private void updateDestinationData() {
        this.isDestStreamable = MediaType.getStreamableMediaType().isFilenameOf(this.getDestinationFileName());
    }

    public File getPreviewFile() {
        if (this.isFileCompletedOrMoved()) {
            return this.destinationFile;
        }
        if (this.finishedScopeList.size() == 0) {
            return null;
        }
        DownloadScope scope = this.finishedScopeList.getScopeAt(0);
        if (scope.getStart() != 0L) {
            return null;
        }
        long previewLength = scope.getEnd();
        StringBuffer fullFileNameBuf = new StringBuffer();
        fullFileNameBuf.append(ServiceManager.sCfg.incompleteDir);
        fullFileNameBuf.append(File.separatorChar);
        fullFileNameBuf.append("PREVIEW");
        fullFileNameBuf.append("-");
        fullFileNameBuf.append(this.destinationFile.getName());
        File previewFile = new File(fullFileNameBuf.toString());
        previewFile.deleteOnExit();
        try {
            FileUtils.copyFile(this.incompleteFile, previewFile, previewLength);
            return previewFile;
        }
        catch (IOException exp) {
            return null;
        }
    }

    public boolean isPreviewPossible() {
        if (this.isFileCompletedOrMoved()) {
            return true;
        }
        if (this.finishedScopeList.size() == 0) {
            return false;
        }
        DownloadScope scope = this.finishedScopeList.getScopeAt(0);
        return scope.getStart() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToDestinationFile() {
        boolean isRenamed = false;
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            if (this.isFileCompletedMoved()) {
                return;
            }
            if (this.missingScopeList.size() > 0 && this.status == 3) {
                throw new RuntimeException("There must be exactly one download segment (found " + this.missingScopeList.size() + ") and the download must be completed to move to destination file '" + this.destinationFile.getName() + "'");
            }
            File destFile = this.destinationFile;
            if (!destFile.isAbsolute()) {
                destFile = new File(ServiceManager.sCfg.mDownloadDir, this.destinationFile.getName());
            }
            int tryCount = 0;
            while (destFile.exists()) {
                ++tryCount;
                StringBuffer newName = new StringBuffer();
                newName.append(this.destinationFile.getParent());
                newName.append(File.separatorChar);
                newName.append('(');
                newName.append(tryCount);
                newName.append(") ");
                newName.append(this.destinationFile.getName());
                destFile = new File(newName.toString());
            }
            NLogger.debug("Download_File", (Object)("Renaming final segment from " + this.incompleteFile.getAbsolutePath() + " to " + destFile.getAbsoluteFile() + "."));
            isRenamed = this.incompleteFile.renameTo(destFile);
            if (isRenamed) {
                NLogger.debug("Download_File", (Object)("File " + this.destinationFile.getName() + " has been moved to its final location"));
            } else {
                NLogger.debug("Download_File", (Object)("Renaming from " + this.incompleteFile.getAbsolutePath() + " to " + destFile.getAbsolutePath() + " failed."));
            }
            this.setStatus((short)6);
            if (isRenamed) {
                Executer exec = new Executer(this.destinationFile, ServiceManager.sCfg.completionNotifyMethod);
                ThreadPool.getInstance().addJob(exec, "DownloadExecuter");
            }
            if (isRenamed && ServiceManager.sCfg.autoReadoutDownloadedMagma && destFile.getName().endsWith(".magma")) {
                try {
                    SwarmingManager.getInstance().addMagmaToDownload(destFile);
                }
                catch (IOException exp) {
                    NLogger.error("MAGMA", (Object)exp.getMessage(), (Throwable)exp);
                }
            }
        }
        if (ServiceManager.sCfg.mDownloadAutoRemoveCompleted) {
            SwarmingManager.getInstance().removeDownloadFile(this);
        } else {
            SwarmingManager.getInstance().notifyDownloadListChange();
        }
    }

    public Integer getProgress() {
        long tmpTransferDataSize;
        int percentage = this.isFileCompletedOrMoved() ? 100 : ((tmpTransferDataSize = this.fileSize) == -1L || tmpTransferDataSize == 0L ? -1 : (int)(this.transferredDataSize * 100L / tmpTransferDataSize));
        if (this.currentProgress != percentage) {
            this.currentProgress = new Integer(percentage);
        }
        return this.currentProgress;
    }

    public void startDownload() {
        this.setStatus((short)1);
        this.verifyStatus();
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDownload(SWDownloadCandidate candidate) {
        SWDownloadWorker worker;
        Object object = this.candidatesLock;
        synchronized (object) {
            worker = (SWDownloadWorker)this.allocatedCandidateWorkerMap.get(candidate);
        }
        if (worker != null) {
            worker.stopWorker();
            worker.waitTillFinished();
        }
    }

    public void stopDownload() {
        this.setStatus((short)4);
        this.stopAllWorkers(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllWorkers(boolean waitTillFinished) {
        SWDownloadWorker[] workers;
        Object object = this.candidatesLock;
        synchronized (object) {
            Collection workerColl = this.allocatedCandidateWorkerMap.values();
            workers = new SWDownloadWorker[workerColl.size()];
            workerColl.toArray(workers);
            for (int i = 0; i < workers.length; ++i) {
                SWDownloadWorker worker = workers[i];
                worker.stopWorker();
            }
        }
        if (!waitTillFinished) {
            return;
        }
        for (int i = 0; i < workers.length; ++i) {
            SWDownloadWorker worker = workers[i];
            if (!worker.isInsideCriticalSection()) continue;
            worker.waitTillFinished();
        }
    }

    public void removeIncompleteDownloadFile() {
        boolean succ;
        if (this.isFileCompletedOrMoved()) {
            return;
        }
        if (this.status != 4) {
            NLogger.error("Download_File", "Can't clean temp files of not stopped download file.");
            return;
        }
        this.stopAllWorkers(true);
        if (this.incompleteFile != null && this.incompleteFile.exists() && !(succ = this.incompleteFile.delete())) {
            NLogger.debug("Download.Segment", (Object)("Segment " + this.toString() + ": Failed to delete " + this.incompleteFile + "."));
        }
    }

    private void downloadStartNotify() {
        this.transferStartTime = System.currentTimeMillis();
        this.modifiedDate = new Date(this.transferStartTime);
        this.transferStopTime = 0L;
    }

    private void downloadStopNotify() {
        if (this.transferStopTime == 0L) {
            this.transferStopTime = System.currentTimeMillis();
            if (this.status == 2) {
                this.modifiedDate = new Date(this.transferStopTime);
            }
        }
        SwarmingManager.getInstance().notifyDownloadListChange();
        try {
            this.getIncompleteDownloadFile().closeFile();
        }
        catch (FileHandlingException exp) {
            NLogger.error("Download_File", (Object)exp, (Throwable)exp);
        }
        catch (ManagedFileException exp) {
            if (exp.getCause() instanceof InterruptedException) {
                NLogger.debug("Download_File", (Object)exp);
            }
            NLogger.error("Download_File", (Object)exp, (Throwable)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceCollectionOfTransferData() {
        long tmpTransferredDataSize = 0L;
        DownloadScopeList downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            tmpTransferredDataSize = this.finishedScopeList.getAggregatedLength();
        }
        Iterator iterator = this.transferCandidatesList.iterator();
        while (iterator.hasNext()) {
            SWDownloadCandidate candidate = (SWDownloadCandidate)iterator.next();
            SWDownloadSegment segment = candidate.getDownloadSegment();
            if (segment == null) continue;
            tmpTransferredDataSize += segment.getTransferredDataSize();
        }
        this.transferredDataSize = tmpTransferredDataSize;
        this.transferDataUpdateTime = System.currentTimeMillis() + 1000L;
    }

    private void lazyCollectTransferData() {
        long now = System.currentTimeMillis();
        if (this.isFileCompletedOrMoved() || this.transferDataUpdateTime > now) {
            return;
        }
        this.forceCollectionOfTransferData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScopeList getMissingScopeList() {
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            return this.missingScopeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScopeList getFinishedScopeList() {
        DownloadScopeList downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            return this.finishedScopeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScopeList getBlockedScopeList() {
        DownloadScopeList downloadScopeList = this.blockedScopeList;
        synchronized (downloadScopeList) {
            return this.blockedScopeList;
        }
    }

    public RatedDownloadScopeList getRatedScopeList() {
        long now = System.currentTimeMillis();
        if (this.ratedScopeListBuildTime + 120000L > now) {
            return this.ratedScopeList;
        }
        if (this.ratedScopeList == null) {
            this.ratedScopeList = new RatedDownloadScopeList();
        } else {
            this.ratedScopeList.clear();
        }
        this.ratedScopeList.addAll(this.missingScopeList);
        this.rateDownloadScopeList(this.ratedScopeList);
        this.ratedScopeListBuildTime = System.currentTimeMillis();
        return this.ratedScopeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rateDownloadScopeList(RatedDownloadScopeList ratedScopeList) {
        long oldestConnectTime = System.currentTimeMillis() - 10800000L;
        Object object = this.candidatesLock;
        synchronized (object) {
            Iterator iterator = this.goodCandidatesList.iterator();
            while (iterator.hasNext()) {
                SWDownloadCandidate candidate = (SWDownloadCandidate)iterator.next();
                if (candidate.getLastConnectionTime() == 0L || candidate.getLastConnectionTime() < oldestConnectTime) continue;
                DownloadScopeList availableScopeList = candidate.getAvailableScopeList();
                if (availableScopeList == null) {
                    availableScopeList = new DownloadScopeList();
                    availableScopeList.add(new DownloadScope(0L, this.fileSize - 1L));
                }
                ratedScopeList.rateDownloadScopeList(availableScopeList, candidate.getSpeed());
            }
        }
    }

    public DownloadScope allocateDownloadScope(DownloadScopeList candidateScopeList, long preferredSegmentSize, long speed) {
        boolean retry;
        DownloadScope result = null;
        do {
            retry = false;
            if (this.fileSize != -1L) {
                result = this.allocateSegmentForRangeSet(candidateScopeList, preferredSegmentSize);
                NLogger.debug("Download.Segment.Allocate", (Object)("Allocated: " + result));
                continue;
            }
            result = this.allocateSegment(preferredSegmentSize);
            NLogger.debug("Download.Segment.Allocate", (Object)("Allocated: " + result));
        } while (retry);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadScope allocateSegment(long preferredSize) {
        NLogger.debug("Download.Segment.Allocate", (Object)("allocateSegment() size:" + preferredSize));
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            Iterator iterator = this.missingScopeList.getScopeIterator();
            if (iterator.hasNext()) {
                DownloadScope scope = (DownloadScope)iterator.next();
                this.missingScopeList.remove(scope);
                Object object = scope;
                synchronized (object) {
                    if (this.fileSize != -1L && scope.getLength() > preferredSize) {
                        DownloadScope beforeScope = new DownloadScope(scope.getStart(), scope.getStart() + preferredSize - 1L);
                        DownloadScope afterScope = new DownloadScope(scope.getStart() + preferredSize, scope.getEnd());
                        this.missingScopeList.add(afterScope);
                        scope = beforeScope;
                    }
                }
                object = this.blockedScopeList;
                synchronized (object) {
                    this.blockedScopeList.add(scope);
                }
                return scope;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadScope allocateSegmentForRangeSet(DownloadScopeList candidateScopeList, long preferredSize) {
        if (!$assertionsDisabled && this.fileSize == -1L) {
            throw new AssertionError((Object)"Cant allocate segment for range set with unknown end.");
        }
        NLogger.debug("Download.Segment.Allocate", (Object)("allocateSegmentForRangeSet() size: " + preferredSize));
        if (candidateScopeList == null) {
            candidateScopeList = new DownloadScopeList();
            candidateScopeList.add(new DownloadScope(0L, this.fileSize - 1L));
        }
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            DownloadScopeList wantedScopeList = (DownloadScopeList)this.missingScopeList.clone();
            wantedScopeList.addAll(this.missingScopeList);
            wantedScopeList.retainAll(candidateScopeList);
            if (wantedScopeList.size() == 0) {
                return null;
            }
            DownloadScope scope = this.scopeSelectionStrategy.selectDownloadScope(this, wantedScopeList, preferredSize);
            if (scope == null) {
                return null;
            }
            this.missingScopeList.remove(scope);
            DownloadScopeList downloadScopeList2 = this.blockedScopeList;
            synchronized (downloadScopeList2) {
                this.blockedScopeList.add(scope);
            }
            return scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDownloadScope(DownloadScope downloadScope, SWDownloadSegment downloadSegment) {
        if (downloadScope.getEnd() == Long.MAX_VALUE && this.fileSize != -1L) {
            downloadScope = new DownloadScope(downloadScope.getStart(), this.fileSize - 1L);
        }
        DownloadScope finishedScope = null;
        DownloadScope missingScope = null;
        long transferredSize = downloadSegment.getTransferredDataSize();
        if (transferredSize == 0L) {
            missingScope = downloadScope;
        } else {
            finishedScope = new DownloadScope(downloadScope.getStart(), downloadScope.getStart() + transferredSize - 1L);
            if (transferredSize < downloadScope.getLength()) {
                missingScope = new DownloadScope(downloadScope.getStart() + transferredSize, downloadScope.getEnd());
            }
        }
        DownloadScopeList downloadScopeList = this.blockedScopeList;
        synchronized (downloadScopeList) {
            this.blockedScopeList.remove(downloadScope);
        }
        downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            if (missingScope != null) {
                this.missingScopeList.add(missingScope);
            }
        }
        downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            if (finishedScope != null) {
                this.finishedScopeList.add(finishedScope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAndValidateQueuedCandidate(SWDownloadCandidate candidate) {
        int maxWorkers = Math.min(ServiceManager.sCfg.maxTotalDownloadWorker, ServiceManager.sCfg.maxWorkerPerDownload);
        int maxQueuedWorkers = (int)Math.max(Math.floor((double)maxWorkers - (double)maxWorkers * 0.2), 1.0);
        Object object = this.candidatesLock;
        synchronized (object) {
            int queuedCount = this.queuedCandidatesSet.size();
            if (queuedCount < maxQueuedWorkers) {
                candidate.addToCandidateLog("Accept queued candidate (" + queuedCount + "/" + maxQueuedWorkers + ")");
                this.queuedCandidatesSet.add(candidate);
                return true;
            }
            if (this.queuedCandidatesSet.contains(candidate)) {
                return true;
            }
            SWDownloadCandidate highestCandidate = null;
            int highestPos = -1;
            Iterator iterator = this.queuedCandidatesSet.iterator();
            while (iterator.hasNext()) {
                SWDownloadCandidate altCandidate = (SWDownloadCandidate)iterator.next();
                int altPos = altCandidate.getXQueueParameters().getPosition();
                if (altPos <= highestPos) continue;
                highestCandidate = altCandidate;
                highestPos = altPos;
            }
            int candidatePos = candidate.getXQueueParameters().getPosition();
            if (highestCandidate != null && highestPos > candidatePos) {
                highestCandidate.addToCandidateLog("Drop queued candidate - new alternative: " + highestPos + " - " + candidatePos + ")");
                highestCandidate.setStatus((short)14, -1);
                SWDownloadWorker worker = (SWDownloadWorker)this.allocatedCandidateWorkerMap.get(highestCandidate);
                if (worker != null) {
                    worker.stopWorker();
                }
                this.queuedCandidatesSet.add(candidate);
                return true;
            }
            candidate.addToCandidateLog("Drop queued candidate - existing alternative: " + candidatePos + " - " + highestPos);
            candidate.setStatus((short)14, -1);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueuedCandidate(SWDownloadCandidate candidate) {
        Object object = this.candidatesLock;
        synchronized (object) {
            this.queuedCandidatesSet.remove(candidate);
        }
    }

    private void initAltLocContainers() {
        this.goodAltLocContainer = new AltLocContainer(this.fileURN);
        this.badAltLocContainer = new AltLocContainer(this.fileURN);
    }

    private void initIncompleteFile() throws FileHandlingException {
        if (this.incompleteFile != null) {
            return;
        }
        File destFile = this.getDestinationFile();
        try {
            this.incompleteFile = SWDownloadFile.createIncompleteFile(destFile);
        }
        catch (FileHandlingException exp) {
            String filename = exp.getFileName();
            Throwable cause = exp.getCause();
            String errorStr = cause != null ? cause.toString() : "Unknown";
            this.stopDownload();
            Environment.getInstance().fireDisplayUserMessage("SegmentCreateIncompleteFileFailed", new String[]{filename, errorStr});
            throw exp;
        }
    }

    public static File createIncompleteFile(File destinationFile) throws FileHandlingException {
        File tryFile;
        boolean succ;
        int tryCount = 0;
        IOException lastExp = null;
        do {
            StringBuffer fullFileNameBuf = new StringBuffer();
            fullFileNameBuf.append(ServiceManager.sCfg.incompleteDir);
            fullFileNameBuf.append(File.separatorChar);
            fullFileNameBuf.append("INCOMPLETE");
            if (tryCount > 0) {
                fullFileNameBuf.append('(');
                fullFileNameBuf.append(String.valueOf(tryCount));
                fullFileNameBuf.append(')');
            }
            fullFileNameBuf.append("-");
            fullFileNameBuf.append(destinationFile.getName());
            tryFile = new File(fullFileNameBuf.toString());
            tryFile.getParentFile().mkdirs();
            ++tryCount;
            try {
                succ = tryFile.createNewFile();
            }
            catch (IOException exp) {
                lastExp = exp;
                succ = false;
            }
        } while (!succ && tryCount < 50);
        if (lastExp != null) {
            NLogger.error("Download", (Object)lastExp, (Throwable)lastExp);
        }
        if (!succ) {
            NLogger.error("Download", "Tryied " + tryCount + " times to create a segment file. Giving up");
            throw new FileHandlingException(2, tryFile.getAbsolutePath(), lastExp);
        }
        return tryFile;
    }

    private void createDownloadScopes(XJBSWDownloadFile xjbFile) {
        this.missingScopeList.clear();
        this.blockedScopeList.clear();
        this.finishedScopeList.clear();
        Iterator iterator = xjbFile.getFinishedScopesList().iterator();
        while (iterator.hasNext()) {
            XJBDownloadScope xjbScope = (XJBDownloadScope)iterator.next();
            DownloadScope downloadScope = new DownloadScope(xjbScope.getStart(), xjbScope.getEnd());
            this.finishedScopeList.add(downloadScope);
        }
        if (this.fileSize == -1L) {
            this.missingScopeList.add(new DownloadScope(0L, Long.MAX_VALUE));
        } else {
            this.missingScopeList.add(new DownloadScope(0L, this.fileSize - 1L));
        }
        this.missingScopeList.removeAll(this.finishedScopeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDownloadCandidates(XJBSWDownloadFile xjbFile) {
        Object object = this.candidatesLock;
        synchronized (object) {
            long before24h = System.currentTimeMillis() - 86400000L;
            this.allCandidatesList.clear();
            this.goodCandidatesList.clear();
            this.mediumCandidatesList.clear();
            this.badCandidatesList.clear();
            Iterator iterator = xjbFile.getCandidateList().iterator();
            while (iterator.hasNext()) {
                try {
                    XJBSWDownloadCandidate xjbCandidate = (XJBSWDownloadCandidate)iterator.next();
                    SWDownloadCandidate candidate = new SWDownloadCandidate(xjbCandidate, this);
                    NLogger.debug("Download_File", (Object)("Adding download candidate " + candidate));
                    int pos = this.allCandidatesList.size();
                    this.allCandidatesList.add(candidate);
                    this.fireDownloadCandidateAdded(pos);
                    if (xjbCandidate.getConnectionFailedRepetition() >= 3) {
                        this.badCandidatesList.add(candidate);
                        continue;
                    }
                    if (xjbCandidate.getLastConnectionTime() > before24h) {
                        this.goodCandidatesList.add(candidate);
                        continue;
                    }
                    this.mediumCandidatesList.add(candidate);
                }
                catch (MalformedDestAddressException exp) {
                    NLogger.warn("Download_File", (Object)exp, (Throwable)exp);
                }
                catch (Exception exp) {
                    NLogger.error("Download_File", (Object)"Error loading a download candidate from XML.", (Throwable)exp);
                }
            }
            Collections.sort(this.goodCandidatesList, new InitialCandidatesComparator());
            Collections.sort(this.mediumCandidatesList, new InitialCandidatesComparator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XJBSWDownloadFile createXJBSWDownloadFile() throws JAXBException {
        List list;
        ObjectFactory objFactory = new ObjectFactory();
        XJBSWDownloadFile xjbFile = objFactory.createXJBSWDownloadFile();
        xjbFile.setLocalFileName(this.destinationFile.getName());
        xjbFile.setIncompleteFileName(this.incompleteFile.getAbsolutePath());
        xjbFile.setFileSize(this.fileSize);
        xjbFile.setSearchTerm(this.researchSetting.getSearchTerm());
        xjbFile.setCreatedTime(this.createdDate.getTime());
        xjbFile.setModifiedTime(this.modifiedDate.getTime());
        if (this.fileURN != null) {
            xjbFile.setFileURN(this.fileURN.getAsString());
        }
        xjbFile.setScopeSelectionStrategy(this.scopeSelectionStrategy.getClass().getName());
        xjbFile.setStatus(this.status);
        Object object = this.candidatesLock;
        synchronized (object) {
            XJBSWDownloadCandidate xjbCandidate;
            SWDownloadCandidate candidate;
            list = xjbFile.getCandidateList();
            Iterator iterator = this.goodCandidatesList.iterator();
            while (iterator.hasNext()) {
                candidate = (SWDownloadCandidate)iterator.next();
                xjbCandidate = candidate.createXJBSWDownloadCandidate();
                list.add(xjbCandidate);
            }
            iterator = this.mediumCandidatesList.iterator();
            while (iterator.hasNext()) {
                candidate = (SWDownloadCandidate)iterator.next();
                xjbCandidate = candidate.createXJBSWDownloadCandidate();
                list.add(xjbCandidate);
            }
            iterator = this.badCandidatesList.iterator();
            while (iterator.hasNext()) {
                candidate = (SWDownloadCandidate)iterator.next();
                if (candidate.getStatus() == 10) continue;
                xjbCandidate = candidate.createXJBSWDownloadCandidate();
                list.add(xjbCandidate);
            }
        }
        Iterator iterator = this.finishedScopeList.getScopeIterator();
        list = xjbFile.getFinishedScopesList();
        while (iterator.hasNext()) {
            DownloadScope scope = (DownloadScope)iterator.next();
            XJBDownloadScope xjbScope = objFactory.createXJBDownloadScope();
            xjbScope.setStart(scope.getStart());
            xjbScope.setEnd(scope.getEnd());
            list.add(xjbScope);
        }
        return xjbFile;
    }

    public void setTransferRateTimestamp(long timestamp) {
        throw new UnsupportedOperationException();
    }

    public int getShortTermTransferRate() {
        throw new UnsupportedOperationException();
    }

    public int getLongTermTransferRate() {
        return (int)this.getTransferSpeed();
    }

    public short getDataTransferStatus() {
        switch (this.status) {
            case 2: {
                return 10;
            }
            case 3: 
            case 6: {
                return 12;
            }
        }
        return 11;
    }

    public long getTransferDataSize() {
        return this.getTotalDataSize();
    }

    public long getTotalDataSize() {
        return this.fileSize;
    }

    public long getTransferredDataSize() {
        this.lazyCollectTransferData();
        return this.transferredDataSize;
    }

    public void addDownloadCandidatesChangeListener(DownloadCandidatesChangeListener listener) {
        this.listenerList.add(DownloadCandidatesChangeListener.class, listener);
    }

    public void removeDownloadCandidatesChangeListener(DownloadCandidatesChangeListener listener) {
        this.listenerList.remove(DownloadCandidatesChangeListener.class, listener);
    }

    private void fireDownloadCandidateChanged(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener listener = (DownloadCandidatesChangeListener)listeners[i];
                    listener.downloadCandidateChanged(position);
                }
            }
        });
    }

    private void fireDownloadCandidateAdded(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener listener = (DownloadCandidatesChangeListener)listeners[i];
                    listener.downloadCandidateAdded(position);
                }
            }
        });
    }

    private void fireDownloadCandidateRemoved(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener listener = (DownloadCandidatesChangeListener)listeners[i];
                    listener.downloadCandidateRemoved(position);
                }
            }
        });
    }

    public void fireDownloadCandidateChanged(SWDownloadCandidate candidate) {
        int position = this.allCandidatesList.indexOf(candidate);
        if (position >= 0) {
            this.fireDownloadCandidateChanged(position);
        }
    }

    public void addDownloadSegmentChangeListener(DownloadSegmentsChangeListener listener) {
        this.listenerList.add(DownloadSegmentsChangeListener.class, listener);
    }

    public void removeDownloadSegmentChangeListener(DownloadSegmentsChangeListener listener) {
        this.listenerList.remove(DownloadSegmentsChangeListener.class, listener);
    }

    private void fireDownloadSegmentChanged(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    DownloadSegmentsChangeListener listener = (DownloadSegmentsChangeListener)listeners[i];
                    listener.downloadSegmentChanged(position);
                }
            }
        });
    }

    private void fireDownloadSegmentAdded(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    DownloadSegmentsChangeListener listener = (DownloadSegmentsChangeListener)listeners[i];
                    listener.downloadSegmentAdded(position);
                }
            }
        });
    }

    private void fireDownloadSegmentRemoved(final int position) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    DownloadSegmentsChangeListener listener = (DownloadSegmentsChangeListener)listeners[i];
                    listener.downloadSegmentRemoved(position);
                }
            }
        });
    }

    static {
        $assertionsDisabled = !SWDownloadFile.class.desiredAssertionStatus();
        random = new Random();
    }

    private static class SWDownloadSegmentComparatorByStartPosition
    implements Comparator {
        private SWDownloadSegmentComparatorByStartPosition() {
        }

        public int compare(Object obj1, Object obj2) {
            XJBSWDownloadSegment segment1 = (XJBSWDownloadSegment)obj1;
            XJBSWDownloadSegment segment2 = (XJBSWDownloadSegment)obj2;
            long diff = segment1.getStartPosition() - segment2.getStartPosition();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private static class InitialCandidatesComparator
    implements Comparator {
        private InitialCandidatesComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2 || obj1.equals(obj2)) {
                return 0;
            }
            SWDownloadCandidate candidate1 = (SWDownloadCandidate)obj1;
            SWDownloadCandidate candidate2 = (SWDownloadCandidate)obj2;
            long diff = candidate1.getLastConnectionTime() - candidate2.getLastConnectionTime();
            if (diff < 0L) {
                return 1;
            }
            if (diff > 0L) {
                return -1;
            }
            return candidate1.hashCode() - candidate2.hashCode();
        }
    }
}

