/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.ServiceManager;
import phex.common.ShortObj;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.LogRecord;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SwarmingManager;
import phex.http.HTTPRangeSet;
import phex.http.Range;
import phex.http.XQueueParameters;
import phex.msg.GUID;
import phex.net.presentation.PresentationManager;
import phex.query.QueryHitHost;
import phex.utils.NLogger;
import phex.utils.URLCodecUtils;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBSWDownloadCandidate;
import phex.xml.XMLUtils;

public class SWDownloadCandidate
implements SWDownloadConstants {
    private long lastConnectionTime;
    private int failedConnectionTries;
    private GUID guid;
    private long fileIndex;
    private URN resourceURN;
    private URI downloadURI;
    private String fileName;
    private int lastTransferRateBPS;
    private DestAddress hostAddress;
    private ShortObj statusObj;
    private String statusReason;
    private short errorStatus;
    private long statusTimeout;
    private int errorStatusRepetition;
    private String vendor;
    private boolean isG2FeatureAdded;
    private boolean isPushNeeded;
    private DestAddress[] pushProxyAddresses;
    private boolean isChatSupported;
    private DownloadScopeList availableScopeList = null;
    private long availableRangeSetTime = 0L;
    private SWDownloadFile downloadFile;
    private SWDownloadSegment downloadSegment;
    private XQueueParameters xQueueParameters;
    private Set sendAltLocSet;
    private long totalDownloadSize;

    public SWDownloadCandidate(RemoteFile remoteFile, SWDownloadFile aDownloadFile) {
        this.downloadFile = aDownloadFile;
        this.fileIndex = remoteFile.getFileIndex();
        this.fileName = remoteFile.getFilename();
        this.resourceURN = remoteFile.getURN();
        this.guid = remoteFile.getRemoteClientID();
        QueryHitHost qhHost = remoteFile.getQueryHitHost();
        this.vendor = qhHost.getVendor();
        this.isPushNeeded = qhHost.isPushNeeded();
        this.hostAddress = remoteFile.getHostAddress();
        this.isChatSupported = qhHost.isChatSupported();
        this.pushProxyAddresses = qhHost.getPushProxyAddresses();
        this.statusObj = new ShortObj(12);
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        this.lastConnectionTime = 0L;
    }

    public SWDownloadCandidate(DestAddress aHostAddress, long aFileIndex, String aFileName, URN aResourceURN, SWDownloadFile aDownloadFile) {
        this.downloadFile = aDownloadFile;
        this.fileIndex = aFileIndex;
        this.fileName = aFileName;
        this.resourceURN = aResourceURN;
        this.guid = null;
        this.vendor = null;
        this.isPushNeeded = false;
        this.isChatSupported = true;
        this.hostAddress = aHostAddress;
        this.statusObj = new ShortObj(12);
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        this.lastConnectionTime = 0L;
    }

    public SWDownloadCandidate(DestAddress address, URI downloadUri, SWDownloadFile file) throws URIException {
        this.downloadFile = file;
        this.fileName = URLUtil.getPathQueryFromUri(downloadUri);
        this.downloadURI = downloadUri;
        this.resourceURN = URLUtil.getQueryURN(downloadUri);
        this.guid = null;
        this.vendor = null;
        this.isPushNeeded = false;
        this.isChatSupported = true;
        this.hostAddress = address;
        this.statusObj = new ShortObj(12);
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        this.lastConnectionTime = 0L;
    }

    public SWDownloadCandidate(XJBSWDownloadCandidate xjbCandidate, SWDownloadFile aDownloadFile) throws MalformedDestAddressException {
        String downloadUriStr;
        this.downloadFile = aDownloadFile;
        this.fileIndex = xjbCandidate.getFileIndex();
        this.fileName = xjbCandidate.getFileName();
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        String guidHexStr = xjbCandidate.getGUID();
        if (guidHexStr != null) {
            this.guid = new GUID(guidHexStr);
        }
        if ((downloadUriStr = xjbCandidate.getDownloadURI()) != null) {
            try {
                this.downloadURI = new URI(xjbCandidate.getDownloadURI(), true);
            }
            catch (URIException exp) {
                NLogger.warn("Download.Candidate", (Object)("Malformed URI in: " + aDownloadFile.toString() + " - " + xjbCandidate.getDownloadURI() + " - " + this.toString()), (Throwable)exp);
            }
        }
        this.vendor = xjbCandidate.getVendor();
        this.isPushNeeded = xjbCandidate.isPushNeeded();
        this.isChatSupported = xjbCandidate.isChatSupported();
        this.lastConnectionTime = xjbCandidate.isSetLastConnectionTime() ? xjbCandidate.getLastConnectionTime() : 0L;
        try {
            this.hostAddress = PresentationManager.getInstance().createHostAddress(xjbCandidate.getRemoteHost(), 6346);
        }
        catch (MalformedDestAddressException exp) {
            NLogger.warn("Download.Candidate", (Object)("Malformed host address in: " + aDownloadFile.toString() + " - " + xjbCandidate.getRemoteHost() + " - " + this.toString()), (Throwable)exp);
            throw exp;
        }
        this.resourceURN = aDownloadFile.getFileURN();
        if (xjbCandidate.getConnectionFailedRepetition() > 0) {
            this.errorStatus = (short)13;
            this.statusObj = new ShortObj(13);
            this.failedConnectionTries = this.errorStatusRepetition = xjbCandidate.getConnectionFailedRepetition();
        } else {
            this.statusObj = new ShortObj(12);
        }
    }

    public String getDownloadRequestUrl() {
        String requestUrl2;
        if (this.downloadURI != null) {
            try {
                String requestUrl2 = URLUtil.getPathQueryFromUri(this.downloadURI);
                return requestUrl2;
            }
            catch (URIException e) {
                NLogger.warn("Download.Candidate", (Object)e, (Throwable)e);
            }
        }
        if (this.resourceURN != null) {
            requestUrl2 = URLUtil.buildName2ResourceURL(this.resourceURN);
        } else {
            String fileIndexStr = String.valueOf(this.fileIndex);
            StringBuffer urlBuffer = new StringBuffer(6 + fileIndexStr.length() + this.fileName.length());
            urlBuffer.append("/get/");
            urlBuffer.append(fileIndexStr);
            urlBuffer.append('/');
            urlBuffer.append(URLCodecUtils.encodeURL(this.fileName));
            requestUrl2 = urlBuffer.toString();
        }
        return requestUrl2;
    }

    public SWDownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    public long getSpeed() {
        return this.lastTransferRateBPS;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URN getResourceURN() {
        return this.resourceURN;
    }

    public GUID getGUID() {
        return this.guid;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public long getTotalDownloadSize() {
        return this.totalDownloadSize;
    }

    public void incTotalDownloadSize(int val) {
        this.totalDownloadSize += (long)val;
    }

    public long getStatusTimeLeft() {
        long timeLeft = this.statusTimeout - System.currentTimeMillis();
        if (timeLeft < 0L) {
            timeLeft = 0L;
        }
        return timeLeft;
    }

    public short getStatus() {
        return this.statusObj.getValue();
    }

    public ShortObj getStatusObj() {
        return this.statusObj;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public int getFailedConnectionTries() {
        return this.failedConnectionTries;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String aVendor) {
        if (this.vendor == null || !this.vendor.equals(aVendor)) {
            for (int i = 0; i < aVendor.length(); ++i) {
                if (XMLUtils.isXmlChar(aVendor.charAt(i))) continue;
                return;
            }
            this.vendor = aVendor;
            this.addToCandidateLog("Set vendor to: " + this.vendor);
            this.downloadFile.fireDownloadCandidateChanged(this);
        }
    }

    public boolean isG2FeatureAdded() {
        return this.isG2FeatureAdded;
    }

    public void setG2FeatureAdded(boolean state) {
        this.isG2FeatureAdded = state;
    }

    public void updateXQueueParameters(XQueueParameters newXQueueParameters) {
        if (this.xQueueParameters == null) {
            this.xQueueParameters = newXQueueParameters;
        } else {
            this.xQueueParameters.update(newXQueueParameters);
        }
    }

    public XQueueParameters getXQueueParameters() {
        return this.xQueueParameters;
    }

    public boolean isPushNeeded() {
        return this.isPushNeeded;
    }

    public DestAddress[] getPushProxyAddresses() {
        return this.pushProxyAddresses;
    }

    public void setPushProxyAddresses(DestAddress[] addresses) {
        this.pushProxyAddresses = addresses;
    }

    public long getLastConnectionTime() {
        return this.lastConnectionTime;
    }

    public void setLastConnectionTime(long lastConnectionTime) {
        this.lastConnectionTime = lastConnectionTime;
    }

    public boolean isChatSupported() {
        return this.isChatSupported;
    }

    public void setChatSupported(boolean state) {
        this.isChatSupported = state;
    }

    public boolean isRemotlyQueued() {
        return this.statusObj.value == 18;
    }

    public boolean isRangeUnavailable() {
        return this.statusObj.value == 15;
    }

    public boolean isDownloading() {
        return this.statusObj.value == 20;
    }

    public Set getSendAltLocsSet() {
        if (this.sendAltLocSet == null) {
            this.sendAltLocSet = new HashSet();
        }
        return this.sendAltLocSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailableRangeSet(HTTPRangeSet newRangeSet) {
        if ((newRangeSet == null || newRangeSet.getRangeSet().size() == 0) && this.availableScopeList == null) {
            return;
        }
        if (newRangeSet == null) {
            this.availableScopeList = null;
            return;
        }
        SWDownloadCandidate sWDownloadCandidate = this;
        synchronized (sWDownloadCandidate) {
            this.availableScopeList = new DownloadScopeList();
            long fileSize = this.downloadFile.getTotalDataSize();
            Iterator iterator = newRangeSet.getIterator();
            while (iterator.hasNext()) {
                Range range = (Range)iterator.next();
                DownloadScope scope = new DownloadScope(range.getStartOffset(fileSize), range.getEndOffset(fileSize));
                this.availableScopeList.add(scope);
            }
            this.availableRangeSetTime = System.currentTimeMillis();
        }
        NLogger.debug("Download.File.RangePriority", (Object)("Added new rangeset for " + this.downloadFile.getDestinationFileName() + ": " + newRangeSet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScopeList getAvailableScopeList() {
        if (System.currentTimeMillis() > this.availableRangeSetTime + 600000L) {
            this.setAvailableRangeSet(null);
        }
        SWDownloadCandidate sWDownloadCandidate = this;
        synchronized (sWDownloadCandidate) {
            return this.availableScopeList;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SWDownloadCandidate) {
            return this.equals((SWDownloadCandidate)obj);
        }
        return false;
    }

    public boolean equals(SWDownloadCandidate candidate) {
        return this.hostAddress.equals(candidate.hostAddress);
    }

    public void setStatus(short newStatus) {
        this.setStatus(newStatus, -1, null);
    }

    public void setStatus(short newStatus, int statusSeconds) {
        this.setStatus(newStatus, statusSeconds, null);
    }

    public void setStatus(short newStatus, int statusSeconds, String aStatusReason) {
        long newStatusTimeout;
        if (this.statusObj.value == newStatus) {
            return;
        }
        short oldStatus = this.statusObj.value;
        this.statusObj.value = newStatus;
        this.statusTimeout = newStatusTimeout = System.currentTimeMillis();
        switch (this.statusObj.value) {
            case 11: {
                newStatusTimeout += 10800000L;
                break;
            }
            case 10: {
                newStatusTimeout = Long.MAX_VALUE;
                break;
            }
            case 16: {
                break;
            }
            case 13: {
                ++this.failedConnectionTries;
                if (this.failedConnectionTries >= 12) {
                    this.downloadFile.markCandidateIgnored(this, "CandidateStatusReason_ConnectionFailed");
                    newStatusTimeout = this.statusTimeout;
                    aStatusReason = this.statusReason;
                    break;
                }
                if (this.failedConnectionTries >= 3) {
                    this.downloadFile.markCandidateBad(this);
                    newStatusTimeout = this.statusTimeout;
                    break;
                }
                this.downloadFile.markCandidateMedium(this);
                newStatusTimeout += this.calculateConnectionFailedTimeout();
                break;
            }
            case 19: {
                this.failedConnectionTries = 0;
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                this.failedConnectionTries = 0;
                if (statusSeconds > 0) {
                    newStatusTimeout += (long)(statusSeconds * 1000);
                    break;
                }
                newStatusTimeout += this.determineErrorStatusTimeout(this.statusObj.value);
                break;
            }
            case 17: {
                newStatusTimeout += (long)ServiceManager.sCfg.mPushTransferTimeout;
                break;
            }
            case 20: {
                this.errorStatus = 0;
                this.failedConnectionTries = 0;
            }
        }
        this.statusReason = aStatusReason;
        NLogger.debug("Download.Candidate", (Object)("Setting status to " + newStatus + " and raise timeout from " + this.statusTimeout + " to " + newStatusTimeout + "(" + (newStatusTimeout - this.statusTimeout) + ") Reason:" + aStatusReason + "."));
        this.addToCandidateLog("Setting status to " + SWDownloadInfo.getDownloadCandidateStatusString(this) + " and raise timeout from " + this.statusTimeout + " to " + newStatusTimeout + "(" + (newStatusTimeout - this.statusTimeout) + ") Reason:" + aStatusReason + ".");
        this.statusTimeout = newStatusTimeout;
        this.downloadFile.candidateStatusChanged(this, oldStatus, newStatus);
    }

    private long calculateConnectionFailedTimeout() {
        return 120000L * (long)Math.pow(2.0, Math.min(this.failedConnectionTries - 1, 7)) + (long)((this.failedConnectionTries - 1) * 2);
    }

    private long determineErrorStatusTimeout(short aErrorStatus) {
        if (this.errorStatus == aErrorStatus) {
            ++this.errorStatusRepetition;
        } else {
            this.errorStatus = aErrorStatus;
            this.errorStatusRepetition = 0;
        }
        switch (this.errorStatus) {
            case 14: {
                return 60000L;
            }
            case 15: {
                return 60000L * (long)Math.pow(2.0, this.errorStatusRepetition);
            }
            case 18: {
                if (this.xQueueParameters == null) {
                    return 0L;
                }
                return this.xQueueParameters.getRequestSleepTime();
            }
        }
        NLogger.warn("Download.Candidate", (Object)("Unknown error status: " + this.errorStatus));
        return 0L;
    }

    public void manualConnectionRetry() {
        if (this.statusObj.value != 14 && this.statusObj.value != 13 && this.statusObj.value != 15 && this.statusObj.value != 11 && this.statusObj.value != 10) {
            return;
        }
        this.setStatus((short)12);
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    public boolean isAbleToBeAllocated() {
        if ((long)this.lastTransferRateBPS < ServiceManager.sCfg.minimumAllowedTransferRate && this.lastTransferRateBPS > 0) {
            this.addToCandidateLog("Refusing candidate allocation as last transfer rate was only " + this.lastTransferRateBPS + " bps");
            NLogger.debug("Download.Candidate.Allocate", (Object)("Refusing candidate allocation as last transfer rate was only " + this.lastTransferRateBPS + " bps"));
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return this.statusTimeout <= currentTime;
    }

    public void associateDownloadSegment(SWDownloadSegment aSegment) {
        this.downloadSegment = aSegment;
    }

    public long getPreferredSegmentSize() {
        long result;
        if (this.lastTransferRateBPS == 0) {
            result = ServiceManager.sCfg.initialSegmentSize;
        } else {
            long remainder;
            result = Math.max((long)(this.lastTransferRateBPS * ServiceManager.sCfg.segmentTransferTime), ServiceManager.sCfg.segmentMultiple);
            if ((result += (remainder = -result % ServiceManager.sCfg.segmentMultiple)) > ServiceManager.sCfg.maximumSegmentSize) {
                result = ServiceManager.sCfg.maximumSegmentSize;
            }
        }
        if (result < 1L) {
            NLogger.warn("Download.Candidate", (Object)("Preferred size looks strange. bps=" + this.lastTransferRateBPS + " and stt=" + ServiceManager.sCfg.segmentTransferTime + " res " + result + " res1 " + this.lastTransferRateBPS * ServiceManager.sCfg.segmentTransferTime + " res2 " + -result % ServiceManager.sCfg.segmentMultiple));
            result = ServiceManager.sCfg.initialSegmentSize;
        }
        NLogger.debug("Download.Candidate", (Object)("Preferred segment size is " + result));
        return result;
    }

    public void releaseDownloadSegment() {
        if (this.downloadSegment != null) {
            this.lastTransferRateBPS = this.downloadSegment.getLongTermTransferRate();
            this.downloadSegment = null;
        }
    }

    public SWDownloadSegment getDownloadSegment() {
        return this.downloadSegment;
    }

    public XJBSWDownloadCandidate createXJBSWDownloadCandidate() throws JAXBException {
        ObjectFactory objFactory = new ObjectFactory();
        XJBSWDownloadCandidate xjbCandidate = objFactory.createXJBSWDownloadCandidate();
        xjbCandidate.setFileIndex(this.fileIndex);
        xjbCandidate.setFileName(this.fileName);
        if (this.guid != null) {
            xjbCandidate.setGUID(this.guid.toHexString());
        }
        if (this.downloadURI != null) {
            xjbCandidate.setDownloadURI(this.downloadURI.getEscapedURI());
        }
        xjbCandidate.setPushNeeded(this.isPushNeeded);
        xjbCandidate.setChatSupported(this.isChatSupported);
        xjbCandidate.setRemoteHost(this.hostAddress.getFullHostName());
        xjbCandidate.setVendor(this.vendor);
        if (this.lastConnectionTime > 0L) {
            xjbCandidate.setLastConnectionTime(this.lastConnectionTime);
        }
        if (this.failedConnectionTries > 0) {
            xjbCandidate.setConnectionFailedRepetition(this.failedConnectionTries);
        }
        return xjbCandidate;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[Candidate: ");
        if (this.vendor != null) {
            buffer.append(this.vendor);
            buffer.append(',');
        }
        buffer.append("Adr:");
        buffer.append(this.hostAddress);
        buffer.append(" ->");
        buffer.append(super.toString());
        buffer.append("]");
        return buffer.toString();
    }

    public void addToCandidateLog(String message) {
        if (ServiceManager.sCfg.downloadCandidateLogBufferSize > 0L) {
            LogRecord record = new LogRecord(this, message);
            SwarmingManager.getInstance().getCandidateLogBuffer().addLogRecord(record);
        }
    }
}

