/*
 * Decompiled with CFR 0.152.
 */
package phex.download.strategy;

import java.util.Random;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.strategy.ScopeSelectionStrategy;
import phex.download.swarming.SWDownloadFile;

public class RandomScopeSelectionStrategy
implements ScopeSelectionStrategy {
    private static final Random random = new Random();

    public DownloadScope selectDownloadScope(SWDownloadFile downloadFile, DownloadScopeList wantedScopeList, long preferredSize) {
        int size = wantedScopeList.size();
        int pos = random.nextInt(size);
        DownloadScope bestScope = wantedScopeList.getScopeAt(pos);
        if (bestScope.getLength() > preferredSize) {
            if (downloadFile.getFinishedScopeList().size() > 20) {
                bestScope = new DownloadScope(bestScope.getStart(), bestScope.getStart() + preferredSize - 1L);
            } else {
                int parts = (int)Math.floor((double)bestScope.getLength() / (double)preferredSize);
                int startPart = random.nextInt(parts);
                long startPos = Math.min(bestScope.getStart() + (long)startPart * preferredSize, bestScope.getEnd() - preferredSize + 1L);
                bestScope = new DownloadScope(startPos, startPos + preferredSize - 1L);
            }
        }
        return bestScope;
    }
}

