/*
 * Decompiled with CFR 0.152.
 */
package phex.download.strategy;

import java.util.Random;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.strategy.ScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategyProvider;
import phex.download.swarming.SWDownloadFile;

public class AvailBeginRandSelectionStrategy
implements ScopeSelectionStrategy {
    private static final Random random = new Random();
    private static ScopeSelectionStrategy availStrategy = ScopeSelectionStrategyProvider.AVAILABILITY_SCOPE_SELECTION_STRATEGY;
    private static ScopeSelectionStrategy beginStrategy = ScopeSelectionStrategyProvider.PREFERE_BEGINING_SCOPE_SELECTION_STRATEGY;
    private static ScopeSelectionStrategy randStrategy = ScopeSelectionStrategyProvider.RANDOM_SCOPE_SELECTION_STRATEGY;

    public DownloadScope selectDownloadScope(SWDownloadFile downloadFile, DownloadScopeList wantedScopeList, long preferredSize) {
        boolean useBegin;
        DownloadScope scope = availStrategy.selectDownloadScope(downloadFile, wantedScopeList, preferredSize);
        if (scope == null && downloadFile.isDestinationStreamable() && (useBegin = random.nextBoolean())) {
            scope = beginStrategy.selectDownloadScope(downloadFile, wantedScopeList, preferredSize);
        }
        if (scope == null) {
            scope = randStrategy.selectDownloadScope(downloadFile, wantedScopeList, preferredSize);
        }
        return scope;
    }
}

