/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import java.util.Iterator;
import phex.common.address.DestAddress;
import phex.download.PushRequestSleeper;
import phex.download.swarming.SWDownloadCandidate;
import phex.msg.GUID;
import phex.net.presentation.SocketFacade;
import phex.statistic.UploadDownloadCountStatistic;
import phex.utils.NLogger;

public class PushHandler {
    private static PushHandler singleton = new PushHandler();
    private ArrayList pushSleeperList = new ArrayList(5);

    private PushHandler() {
    }

    public static void handleIncommingGIV(SocketFacade aGivenSocket, GUID givenGUID, String givenFileName) {
        singleton.internalHandleIncommingGIV(aGivenSocket, givenGUID, givenFileName);
    }

    public static SocketFacade requestSocketViaPush(SWDownloadCandidate downloadCandidate) {
        if (downloadCandidate.getGUID() == null) {
            return null;
        }
        return singleton.internalRequestSocketViaPush(downloadCandidate.getGUID(), downloadCandidate.getFileIndex(), downloadCandidate.getPushProxyAddresses());
    }

    public static SocketFacade requestSocketViaPush(GUID aClientGUID, long aFileIndex) {
        return singleton.internalRequestSocketViaPush(aClientGUID, aFileIndex, null);
    }

    public static void unregisterPushRequestSleeper(PushRequestSleeper sleeper) {
        singleton.internalUnregisterPushRequestSleeper(sleeper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalHandleIncommingGIV(SocketFacade aGivenSocket, GUID givenGUID, String givenFileName) {
        if (NLogger.isDebugEnabled("PUSH")) {
            NLogger.debug("PUSH", (Object)("Handle incomming GIV response:  - " + givenFileName));
        }
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            Iterator iterator = this.pushSleeperList.iterator();
            while (iterator.hasNext()) {
                boolean succ = ((PushRequestSleeper)iterator.next()).acceptGIVConnection(aGivenSocket, givenGUID);
                if (!succ) continue;
                if (NLogger.isDebugEnabled("PUSH")) {
                    NLogger.debug("PUSH", (Object)("Accepted GIV response:  - " + givenFileName));
                }
                return;
            }
        }
        if (NLogger.isDebugEnabled("PUSH")) {
            NLogger.debug("PUSH", (Object)("No Push request for GIV found: " + givenFileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketFacade internalRequestSocketViaPush(GUID aClientGUID, long aFileIndex, DestAddress[] pushProxyAddresses) {
        if (NLogger.isDebugEnabled("PUSH")) {
            NLogger.debug("PUSH", (Object)"Perform PUSH request...");
        }
        UploadDownloadCountStatistic.pushDownloadAttempts.increment(1);
        PushRequestSleeper pushSleeper = new PushRequestSleeper(aClientGUID, aFileIndex, pushProxyAddresses);
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            this.pushSleeperList.add(pushSleeper);
        }
        SocketFacade socket = pushSleeper.requestSocketViaPush();
        if (socket == null) {
            if (NLogger.isDebugEnabled("PUSH")) {
                NLogger.debug("PUSH", (Object)"PUSH request failed.");
            }
            UploadDownloadCountStatistic.pushDownloadFailure.increment(1);
        } else {
            if (NLogger.isDebugEnabled("PUSH")) {
                NLogger.debug("PUSH", (Object)"PUSH request successful.");
            }
            UploadDownloadCountStatistic.pushDownloadSuccess.increment(1);
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregisterPushRequestSleeper(PushRequestSleeper sleeper) {
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            this.pushSleeperList.remove(sleeper);
        }
    }
}

