/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

public class DownloadScope {
    private long start;
    private long end;

    public DownloadScope(long startOffset, long endOffset) {
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset : " + startOffset + " " + endOffset);
        }
        this.start = startOffset;
        this.end = endOffset;
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.end - this.start + 1L;
    }

    public boolean contains(DownloadScope scope) {
        return this.start <= scope.start && this.end >= scope.end;
    }

    public boolean isNeighborBefore(DownloadScope scope) {
        return this.start <= scope.end + 1L && this.start > scope.start;
    }

    public boolean isNeighborAfter(DownloadScope scope) {
        return this.end >= scope.start - 1L && this.end < scope.end;
    }

    public boolean isOverlapping(DownloadScope scope) {
        return this.end >= scope.start && this.start <= scope.end;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DownloadScope)) {
            return false;
        }
        DownloadScope scope = (DownloadScope)obj;
        return scope.start == this.start && scope.end == this.end;
    }

    public String toString() {
        return "[DownloadScope: start:" + this.start + ",end:" + this.end + "@" + Integer.toHexString(this.hashCode()) + "]";
    }
}

