/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.ChunkedInputStream;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.FileHandlingException;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.bandwidth.BandwidthController;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.connection.ConnectionFailedException;
import phex.connection.NetworkManager;
import phex.download.DownloadStoppedException;
import phex.download.FileNotAvailableException;
import phex.download.HostBusyException;
import phex.download.RangeUnavailableException;
import phex.download.ReconnectException;
import phex.download.RemotelyQueuedException;
import phex.download.WrongHTTPHeaderException;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.host.UnusableHostException;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRangeSet;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.HTTPRetryAfter;
import phex.http.XQueueParameters;
import phex.net.connection.Connection;
import phex.net.connection.OIOSocketFactory;
import phex.net.presentation.PresentationManager;
import phex.net.presentation.SocketFacade;
import phex.utils.DirectByteBuffer;
import phex.utils.DirectByteBufferProvider;
import phex.utils.IOUtil;
import phex.utils.LengthLimitedInputStream;
import phex.utils.NLogger;

public class DownloadEngine {
    private static final int BUFFER_LENGTH = 16384;
    private SWDownloadCandidate candidate;
    private SWDownloadSegment segment;
    private SWDownloadFile downloadFile;
    private Connection connection;
    private SocketFacade socket;
    private InputStream inStream;
    private boolean isKeepAliveSupported;
    private boolean isDownloadSuccessful;
    private boolean isDownloadStopped;
    private ContentRange replyContentRange;
    private long replyContentLength;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DownloadEngine(SWDownloadFile aDownloadFile, SWDownloadCandidate aCandidate) {
        this.downloadFile = aDownloadFile;
        this.candidate = aCandidate;
    }

    public void setSocket(SocketFacade socket) throws IOException {
        if (!$assertionsDisabled && this.socket == null) {
            throw new AssertionError();
        }
        this.socket = socket;
        this.prepareConnection();
    }

    public void connect(int timeout) throws IOException {
        if (!$assertionsDisabled && this.socket != null) {
            throw new AssertionError();
        }
        DestAddress address = this.candidate.getHostAddress();
        try {
            this.candidate.addToCandidateLog("Wait for connect slot " + address.getHostName() + ":" + address.getPort());
            NLogger.debug("Download.Engine", (Object)("Wait for connect slot " + address.getHostName() + ":" + address.getPort()));
            Runnable acquireCallback = new Runnable(){

                public void run() {
                    DestAddress address = DownloadEngine.this.candidate.getHostAddress();
                    DownloadEngine.this.candidate.addToCandidateLog("Connecting to " + address.getHostName() + ":" + address.getPort());
                    NLogger.debug("Download.Engine", (Object)("Connecting to " + address.getHostName() + ":" + address.getPort()));
                    DownloadEngine.this.candidate.setStatus((short)16);
                }
            };
            this.socket = OIOSocketFactory.connect(address, timeout, acquireCallback);
        }
        catch (SocketException exp) {
            throw new ConnectionFailedException(exp.getMessage());
        }
        this.prepareConnection();
    }

    private void prepareConnection() throws IOException {
        BandwidthController bwController = this.downloadFile.getBandwidthController();
        this.connection = new Connection(this.socket, bwController);
        this.candidate.addToCandidateLog("Connected successfully to " + this.candidate.getHostAddress() + ".");
        this.candidate.setLastConnectionTime(System.currentTimeMillis());
        NLogger.debug("Download.Engine", (Object)("Download Engine @" + Integer.toHexString(this.hashCode()) + " connected successfully to " + this.candidate.getHostAddress() + "."));
        if (this.isDownloadStopped) {
            throw new DownloadStoppedException();
        }
    }

    public void exchangeHTTPHandshake(SWDownloadSegment aSegment) throws IOException, UnusableHostException, HTTPMessageException {
        byte[] remoteIP;
        HTTPHeader header;
        DestAddress ha;
        IpAddress myIp;
        NetworkManager networkMgr = NetworkManager.getInstance();
        this.isDownloadSuccessful = false;
        this.segment = aSegment;
        long downloadOffset = this.segment.getTransferStartPosition();
        OutputStreamWriter writer = new OutputStreamWriter(this.connection.getOutputStream());
        this.inStream = this.connection.getInputStream();
        String requestUrl = this.candidate.getDownloadRequestUrl();
        HTTPRequest request = new HTTPRequest("GET", requestUrl, true);
        request.addHeader(new HTTPHeader("Host", this.candidate.getHostAddress().getFullHostName()));
        request.addHeader(new HTTPHeader("Listen-IP", networkMgr.getLocalAddress().getFullHostName()));
        long segmentEndOffset = this.segment.getEnd();
        if (segmentEndOffset == -1L) {
            request.addHeader(new HTTPHeader("Range", "bytes=" + downloadOffset + "-"));
        } else {
            request.addHeader(new HTTPHeader("Range", "bytes=" + downloadOffset + "-" + segmentEndOffset));
        }
        request.addHeader(new HTTPHeader("X-Queue", "0.1"));
        request.addHeader(new HTTPHeader("Connection", "Keep-Alive"));
        if (this.candidate.isG2FeatureAdded()) {
            request.addHeader(new HTTPHeader("X-Features", "g2/1.0"));
        }
        this.buildAltLocRequestHeader(request);
        if (ServiceManager.sCfg.isChatEnabled && ((myIp = (ha = networkMgr.getLocalAddress()).getIpAddress()) == null || !myIp.isSiteLocalIP())) {
            request.addHeader(new HTTPHeader("Chat", ha.getFullHostName()));
        }
        String httpRequestStr = request.buildHTTPRequestString();
        NLogger.debug("Download.Engine", (Object)("HTTP Request to: " + this.candidate.getHostAddress() + "\n" + httpRequestStr));
        this.candidate.addToCandidateLog("HTTP Request:\n" + httpRequestStr);
        writer.write(httpRequestStr);
        writer.flush();
        HTTPResponse response = HTTPProcessor.parseHTTPResponse(this.connection);
        if (NLogger.isDebugEnabled("Download.Engine")) {
            NLogger.debug("Download.Engine", (Object)("HTTP Response from: " + this.candidate.getHostAddress() + "\n" + response.buildHTTPResponseString()));
        }
        if (ServiceManager.sCfg.downloadCandidateLogBufferSize > 0L) {
            this.candidate.addToCandidateLog("HTTP Response:\n" + response.buildHTTPResponseString());
        }
        if ((header = response.getHeader("Server")) != null) {
            this.candidate.setVendor(header.getValue());
        }
        if ((header = response.getHeader("Transfer-Encoding")) != null && header.getValue().equals("chunked")) {
            this.inStream = new ChunkedInputStream((InputStream)this.connection.getInputStream());
        }
        this.replyContentRange = null;
        header = response.getHeader("Content-Range");
        if (header != null) {
            this.replyContentRange = this.parseContentRange(header.getValue());
            if (this.replyContentRange.startPos != -1L && this.replyContentRange.startPos != downloadOffset) {
                throw new IOException("Invalid 'CONTENT-RANGE' start offset.");
            }
        }
        this.replyContentLength = -1L;
        header = response.getHeader("Content-Length");
        if (header != null) {
            try {
                this.replyContentLength = header.longValue();
            }
            catch (NumberFormatException exp) {
                // empty catch block
            }
        }
        URN downloadFileURN = this.downloadFile.getFileURN();
        ArrayList<HTTPHeader> contentURNHeaders = new ArrayList<HTTPHeader>();
        header = response.getHeader("X-Gnutella-Content-URN");
        if (header != null) {
            contentURNHeaders.add(header);
        }
        Object[] headers = response.getHeaders("X-Content-URN");
        CollectionUtils.addAll(contentURNHeaders, headers);
        if (downloadFileURN != null) {
            Iterator contentURNIterator = contentURNHeaders.iterator();
            while (contentURNIterator.hasNext()) {
                URN contentURN;
                header = (HTTPHeader)contentURNIterator.next();
                String contentURNStr = header.getValue();
                if (!URN.isValidURN(contentURNStr) || downloadFileURN.equals(contentURN = new URN(contentURNStr))) continue;
                throw new IOException("Required URN and content URN do not match.");
            }
        }
        if ((header = response.getHeader("Chat")) != null) {
            this.candidate.setChatSupported(true);
        }
        if ((header = response.getHeader("Remote-IP")) != null && (remoteIP = AddressUtils.parseIP(header.getValue())) != null) {
            IpAddress ip = new IpAddress(remoteIP);
            DestAddress address = PresentationManager.getInstance().createHostAddress(ip, -1);
            networkMgr.updateLocalAddress(address);
        }
        int httpCode = response.getStatusCode();
        header = response.getHeader("X-Available-Ranges");
        if (header != null) {
            HTTPRangeSet availableRanges = HTTPRangeSet.parseHTTPRangeSet(header.getValue(), false);
            if (availableRanges == null) {
                NLogger.error("Download.Engine", "Failed to parse X-Available-Ranges in " + this.candidate.getVendor() + " request: " + response.buildHTTPResponseString());
            }
            this.candidate.setAvailableRangeSet(availableRanges);
        } else if (httpCode >= 200 && httpCode < 300 && this.downloadFile.getTotalDataSize() != -1L) {
            this.candidate.setAvailableRangeSet(new HTTPRangeSet(0L, this.downloadFile.getTotalDataSize() - 1L));
        }
        ArrayList altLocList = new ArrayList();
        headers = response.getHeaders("Alt-Location");
        List altLocTmpList = AltLocContainer.parseUriResAltLocFromHeaders((HTTPHeader[])headers);
        altLocList.addAll(altLocTmpList);
        headers = response.getHeaders("X-Gnutella-Alternate-Location");
        altLocTmpList = AltLocContainer.parseUriResAltLocFromHeaders((HTTPHeader[])headers);
        altLocList.addAll(altLocTmpList);
        headers = response.getHeaders("X-Alt");
        altLocTmpList = AltLocContainer.parseCompactIpAltLocFromHeaders((HTTPHeader[])headers, downloadFileURN);
        altLocList.addAll(altLocTmpList);
        Iterator iterator = altLocList.iterator();
        while (iterator.hasNext()) {
            this.downloadFile.addDownloadCandidate((AlternateLocation)iterator.next());
        }
        headers = response.getHeaders("X-Pushproxies");
        this.handlePushProxyHeaders((HTTPHeader[])headers);
        headers = response.getHeaders("X-Push-Proxies");
        this.handlePushProxyHeaders((HTTPHeader[])headers);
        headers = response.getHeaders("X-Push-Proxy");
        this.handlePushProxyHeaders((HTTPHeader[])headers);
        this.updateKeepAliveSupport(response);
        if (httpCode >= 200 && httpCode < 300) {
            if (contentURNHeaders.size() == 0 && requestUrl.startsWith("/uri-res/N2R?")) {
                throw new IOException("Response to uri-res request without valid Content-URN header.");
            }
            if (this.downloadFile.getTotalDataSize() == -1L) {
                if (!$assertionsDisabled && this.segment.getTotalDataSize() != -1L) {
                    throw new AssertionError();
                }
                if (this.replyContentRange != null && this.replyContentRange.totalLength != -1L) {
                    this.downloadFile.setFileSize(this.replyContentRange.totalLength);
                    this.stopDownload();
                    throw new ReconnectException();
                }
            }
            NLogger.debug("Download.Engine", (Object)"HTTP Handshake successfull.");
            return;
        }
        if (httpCode == 503) {
            int delta;
            header = response.getHeader("X-Queue");
            XQueueParameters xQueueParameters = null;
            if (header != null) {
                xQueueParameters = XQueueParameters.parseHTTPRangeSet(header.getValue());
            }
            if (xQueueParameters != null && this.isKeepAliveSupported) {
                throw new RemotelyQueuedException(xQueueParameters);
            }
            header = response.getHeader("Retry-After");
            if (header != null && (delta = HTTPRetryAfter.parseDeltaInSeconds(header)) > 0) {
                throw new HostBusyException(delta);
            }
            throw new HostBusyException();
        }
        if (httpCode == 401 || httpCode == 403) {
            if ("Network Disabled".equals(response.getStatusReason())) {
                if (this.candidate.isG2FeatureAdded()) {
                    throw new UnusableHostException("Request Forbidden");
                }
                this.candidate.setG2FeatureAdded(true);
                throw new HostBusyException(300);
            }
            throw new UnusableHostException("Request Forbidden");
        }
        if (httpCode == 408) {
            throw new HostBusyException();
        }
        if (httpCode == 404 || httpCode == 410) {
            throw new FileNotAvailableException();
        }
        if (httpCode == 416) {
            int delta;
            header = response.getHeader("Retry-After");
            if (header != null && (delta = HTTPRetryAfter.parseDeltaInSeconds(header)) > 0) {
                throw new RangeUnavailableException(delta);
            }
            throw new RangeUnavailableException();
        }
        throw new IOException("Unknown HTTP code: " + httpCode);
    }

    private void buildAltLocRequestHeader(HTTPRequest request) {
        HTTPHeader header;
        DestAddress ha;
        IpAddress myIp;
        URN downloadFileURN = this.downloadFile.getFileURN();
        if (downloadFileURN == null) {
            return;
        }
        AltLocContainer altLocContainer = new AltLocContainer(downloadFileURN);
        altLocContainer.addContainer(this.downloadFile.getGoodAltLocContainer());
        if (ServiceManager.sCfg.arePartialFilesShared && NetworkManager.getInstance().hasConnectedIncoming() && ((myIp = (ha = NetworkManager.getInstance().getLocalAddress()).getIpAddress()) == null || !myIp.isSiteLocalIP())) {
            AlternateLocation newAltLoc = new AlternateLocation(ha, downloadFileURN);
            altLocContainer.addAlternateLocation(newAltLoc);
        }
        if ((header = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", this.candidate.getHostAddress(), this.candidate.getSendAltLocsSet())) != null) {
            request.addHeader(header);
        }
        if ((header = (altLocContainer = this.downloadFile.getBadAltLocContainer()).getAltLocHTTPHeaderForAddress("X-NAlt", this.candidate.getHostAddress(), this.candidate.getSendAltLocsSet())) != null) {
            request.addHeader(header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDownload() throws IOException {
        NLogger.debug("Download.Engine", (Object)"Download Engine starts download.");
        DirectByteBuffer directByteBuffer = null;
        LengthLimitedInputStream downloadStream = null;
        try {
            int len;
            long segmentDataSizeLeft;
            ManagedFile destFile = this.downloadFile.getIncompleteDownloadFile();
            directByteBuffer = DirectByteBufferProvider.requestBuffer(65536);
            this.segment.downloadStartNotify();
            String snapshotOfSegment = this.segment.toString();
            long downloadLengthLeft = Long.MAX_VALUE;
            if (this.replyContentRange != null && this.replyContentRange.totalLength != -1L) {
                downloadLengthLeft = this.replyContentRange.totalLength;
            }
            if (this.replyContentLength != -1L) {
                downloadLengthLeft = Math.min(this.replyContentLength, downloadLengthLeft);
            }
            if ((segmentDataSizeLeft = this.segment.getTransferDataSizeLeft()) != -1L) {
                downloadLengthLeft = Math.min(segmentDataSizeLeft, downloadLengthLeft);
            }
            downloadStream = new LengthLimitedInputStream(this.inStream, downloadLengthLeft);
            long fileOffset = this.segment.getStart() + this.segment.getTransferredDataSize();
            long lengthDownloaded = this.segment.getTransferredDataSize();
            byte[] buffer = new byte[16384];
            while ((len = downloadStream.read(buffer, 0, 16384)) > 0) {
                SWDownloadSegment sWDownloadSegment = this.segment;
                synchronized (sWDownloadSegment) {
                    long tmpCheckLength = lengthDownloaded + (long)len;
                    if (tmpCheckLength < this.segment.getTransferredDataSize()) {
                        NLogger.error("Download.Engine", "TransferredDataSize would be going down!  ll " + downloadLengthLeft + " l " + len + " ld " + lengthDownloaded + " gtds " + this.segment.getTransferredDataSize() + " seg: " + this.segment + " originally: " + snapshotOfSegment);
                        throw new IOException("TransferredDataSize would be going down!");
                    }
                    if (this.segment.getTransferDataSize() > -1L && tmpCheckLength > this.segment.getTransferDataSize()) {
                        NLogger.error("Download.Engine", "TransferredDataSize would be larger then segment!  ll " + downloadLengthLeft + " l " + len + " ld " + lengthDownloaded + " gtds " + this.segment.getTransferredDataSize() + " seg: " + this.segment + " originally: " + snapshotOfSegment);
                        throw new IOException("TransferredDataSize would be larger then segment!");
                    }
                    directByteBuffer.put(buffer, 0, len);
                    directByteBuffer.flip();
                    destFile.write(directByteBuffer, fileOffset);
                    fileOffset += (long)directByteBuffer.limit();
                    directByteBuffer.clear();
                    this.segment.setTransferredDataSize(lengthDownloaded += (long)len);
                    this.candidate.incTotalDownloadSize(len);
                    segmentDataSizeLeft = this.segment.getTransferDataSizeLeft();
                    if (segmentDataSizeLeft != -1L) {
                        downloadLengthLeft = Math.min(segmentDataSizeLeft, downloadLengthLeft);
                        downloadStream.setLengthLimit(downloadLengthLeft);
                    }
                }
            }
            this.isDownloadSuccessful = true;
            if (this.downloadFile.getTotalDataSize() == -1L) {
                if (!$assertionsDisabled && this.segment.getTotalDataSize() != -1L) {
                    throw new AssertionError();
                }
                this.downloadFile.setFileSize(this.segment.getTransferredDataSize());
            }
        }
        catch (FileHandlingException exp) {
            NLogger.error("Download.Engine", (Object)exp, (Throwable)exp);
            IOException ioExp = new IOException(exp.getMessage());
            ioExp.initCause(exp);
            throw ioExp;
        }
        catch (ManagedFileException exp) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            NLogger.error("Download.Engine", (Object)exp, (Throwable)exp);
            IOException ioExp = new IOException(exp.getMessage());
            ioExp.initCause(exp);
            throw ioExp;
        }
        finally {
            if (directByteBuffer != null) {
                directByteBuffer.release();
            }
            boolean isAcceptingNextSegment = this.isAcceptingNextSegment();
            this.candidate.addToCandidateLog("Is accepting next segment: " + isAcceptingNextSegment);
            if (isAcceptingNextSegment) {
                downloadStream.close();
            } else {
                this.stopDownload();
            }
        }
    }

    public void stopDownload() {
        NLogger.debug("Download.Engine", (Object)"Closing pipe and socket and telling segment we've stopped.");
        this.isDownloadStopped = true;
        this.candidate.addToCandidateLog("Stop download.");
        IOUtil.closeQuietly(this.inStream);
        if (this.segment != null) {
            this.segment.downloadStopNotify();
        }
        if (this.connection != null) {
            this.connection.disconnect();
        }
        IOUtil.closeQuietly(this.socket);
    }

    public boolean isAcceptingNextSegment() {
        return this.isDownloadSuccessful && this.isKeepAliveSupported && this.replyContentLength != -1L;
    }

    private ContentRange parseContentRange(String contentRangeLine) throws WrongHTTPHeaderException {
        try {
            long fileLength;
            ContentRange range = new ContentRange();
            contentRangeLine = contentRangeLine.toLowerCase();
            int idx = contentRangeLine.indexOf("bytes") + 6;
            String rangeStr = contentRangeLine.substring(idx).trim();
            int slashIdx = rangeStr.indexOf(47);
            String leadingPart = rangeStr.substring(0, slashIdx);
            String trailingPart = rangeStr.substring(slashIdx + 1);
            range.totalLength = trailingPart.charAt(0) == '*' ? -1L : (fileLength = Long.parseLong(trailingPart));
            if (leadingPart.charAt(0) == '*') {
                range.startPos = -1L;
                range.endPos = range.totalLength;
            } else {
                int dashIdx = rangeStr.indexOf(45);
                String startOffsetStr = leadingPart.substring(0, dashIdx);
                long startOffset = Long.parseLong(startOffsetStr);
                String endOffsetStr = leadingPart.substring(dashIdx + 1);
                long endOffset = Long.parseLong(endOffsetStr);
                range.startPos = startOffset;
                range.endPos = endOffset;
            }
            return range;
        }
        catch (NumberFormatException exp) {
            NLogger.warn("Download.Engine", (Object)exp, (Throwable)exp);
            throw new WrongHTTPHeaderException("Number error while parsing content range: " + contentRangeLine);
        }
        catch (IndexOutOfBoundsException exp) {
            throw new WrongHTTPHeaderException("Error while parsing content range: " + contentRangeLine);
        }
    }

    private void updateKeepAliveSupport(HTTPResponse response) {
        HTTPHeader header = response.getHeader("Connection");
        if (header != null) {
            if (header.getValue().equalsIgnoreCase("close")) {
                this.isKeepAliveSupported = false;
                return;
            }
            if (header.getValue().equalsIgnoreCase("keep-alive")) {
                this.isKeepAliveSupported = true;
                return;
            }
        }
        this.isKeepAliveSupported = response.getHTTPVersion().equals("HTTP/1.1");
    }

    public void handlePushProxyHeaders(HTTPHeader[] headers) {
        if (headers == null || headers.length == 0) {
            return;
        }
        ArrayList<DestAddress> proxyList = new ArrayList<DestAddress>();
        for (int i = 0; i < headers.length; ++i) {
            HTTPHeader header = headers[i];
            StringTokenizer tokenizer = new StringTokenizer(header.getValue(), ",");
            while (tokenizer.hasMoreTokens()) {
                String addressStr = tokenizer.nextToken().trim();
                try {
                    DestAddress address = AddressUtils.parseAndValidateAddress(addressStr, false);
                    proxyList.add(address);
                }
                catch (MalformedDestAddressException exp) {
                    NLogger.debug("Download.Engine", (Object)("Malformed alt-location URL: " + exp.getMessage()));
                }
            }
        }
        if (proxyList.size() == 0) {
            return;
        }
        DestAddress[] pushProxyAddresses = new DestAddress[proxyList.size()];
        proxyList.toArray(pushProxyAddresses);
        this.candidate.setPushProxyAddresses(pushProxyAddresses);
    }

    static {
        $assertionsDisabled = !DownloadEngine.class.desiredAssertionStatus();
    }

    private class ContentRange {
        long startPos;
        long endPos;
        long totalLength;

        private ContentRange() {
        }
    }
}

