/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import phex.common.ServiceManager;
import phex.connection.ConnectionConstants;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;

public class UltrapeerHandshakeHandler
extends HandshakeHandler
implements ConnectionConstants {
    private HostManager hostMgr = HostManager.getInstance();
    private NetworkHostsContainer hostContainer = this.hostMgr.getNetworkHostsContainer();

    public UltrapeerHandshakeHandler(Host connectedHost) {
        super(connectedHost);
    }

    protected HTTPHeaderGroup createDefaultHandshakeHeaders() {
        HTTPHeaderGroup openHeaders = super.createDefaultHandshakeHeaders();
        openHeaders.addHeader(new HTTPHeader("X-Ultrapeer", "true"));
        openHeaders.addHeader(new HTTPHeader("X-Query-Routing", "0.1"));
        openHeaders.addHeader(new HTTPHeader("X-Ultrapeer-Query-Routing", "0.1"));
        openHeaders.addHeader(new HTTPHeader("X-Dynamic-Querying", "0.1"));
        openHeaders.addHeader(new HTTPHeader("X-Degree", String.valueOf(ServiceManager.sCfg.up2upConnections)));
        openHeaders.addHeader(new HTTPHeader("X-Max-TTL", String.valueOf(4)));
        return openHeaders;
    }

    public HandshakeStatus createHandshakeResponse(HandshakeStatus hostResponse, boolean isOutgoing) {
        if (isOutgoing) {
            return this.createOutgoingResponse(hostResponse);
        }
        return this.createIncomingResponse(hostResponse);
    }

    private HandshakeStatus createIncomingResponse(HandshakeStatus hostResponse) {
        HTTPHeaderGroup headers = hostResponse.getResponseHeaders();
        boolean isCrawler = this.isCrawlerConnection(headers);
        if (isCrawler) {
            return this.createCrawlerHandshakeStatus();
        }
        HTTPHeader upHeader = headers.getHeader("X-Ultrapeer");
        if (!this.isConnectionAccepted(upHeader)) {
            return new HandshakeStatus(503, "I am busy.", this.createRejectIncomingHeaders());
        }
        HTTPHeaderGroup myHeaders = this.createDefaultHandshakeHeaders();
        if (upHeader != null && Boolean.valueOf(upHeader.getValue()).booleanValue()) {
            boolean isUltrapeerNeeded = this.hostContainer.hasUltrapeerSlotsAvailable();
            String isUltrapeedNeededStr = isUltrapeerNeeded ? "true" : "false";
            myHeaders.addHeader(new HTTPHeader("X-Ultrapeer-Needed", isUltrapeedNeededStr));
        }
        if (hostResponse.isDeflateAccepted()) {
            myHeaders.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
        }
        return new HandshakeStatus(200, "OK", myHeaders);
    }

    private HandshakeStatus createOutgoingResponse(HandshakeStatus hostResponse) {
        HTTPHeaderGroup headers = hostResponse.getResponseHeaders();
        HTTPHeader upHeader = headers.getHeader("X-Ultrapeer");
        if (!this.isConnectionAccepted(upHeader)) {
            return new HandshakeStatus(503, "I am busy.", this.createRejectOutgoingHeaders());
        }
        HTTPHeaderGroup myHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        HTTPHeader upNeededHeader = headers.getHeader("X-Ultrapeer-Needed");
        if (upNeededHeader != null && !upNeededHeader.booleanValue() && !this.isBearshare(headers) && this.hostMgr.isAbleToBecomeLeafNode()) {
            myHeaders = new HTTPHeaderGroup(false);
            myHeaders.addHeader(new HTTPHeader("X-Ultrapeer", "false"));
        }
        if (hostResponse.isDeflateAccepted()) {
            myHeaders.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
        }
        return new HandshakeStatus(200, "OK", myHeaders);
    }

    private boolean isConnectionAccepted(HTTPHeader upHeader) {
        if (upHeader == null) {
            return this.hostContainer.hasPeerSlotsAvailable();
        }
        return Boolean.valueOf(upHeader.getValue()) != false ? this.hostContainer.hasUltrapeerSlotsAvailable() || this.hostContainer.hasLeafSlotForUltrapeerAvailable() : this.hostContainer.hasLeafSlotsAvailable();
    }

    private boolean isBearshare(HTTPHeaderGroup headers) {
        HTTPHeader header = headers.getHeader("User-Agent");
        return header != null && header.getValue().startsWith("BearShare");
    }
}

