/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import phex.common.ServiceManager;
import phex.connection.ConnectionConstants;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;

public class LeafHandshakeHandler
extends HandshakeHandler
implements ConnectionConstants {
    private HostManager hostMgr = HostManager.getInstance();
    private NetworkHostsContainer hostContainer = this.hostMgr.getNetworkHostsContainer();

    public LeafHandshakeHandler(Host connectedHost) {
        super(connectedHost);
    }

    protected HTTPHeaderGroup createDefaultHandshakeHeaders() {
        HTTPHeaderGroup openHeaders = super.createDefaultHandshakeHeaders();
        openHeaders.addHeader(new HTTPHeader("X-Ultrapeer", "false"));
        openHeaders.addHeader(new HTTPHeader("X-Query-Routing", "0.1"));
        openHeaders.addHeader(new HTTPHeader("X-Ultrapeer-Query-Routing", "0.1"));
        openHeaders.addHeader(new HTTPHeader("X-Dynamic-Querying", "0.1"));
        openHeaders.addHeader(new HTTPHeader("X-Degree", String.valueOf(ServiceManager.sCfg.up2upConnections)));
        openHeaders.addHeader(new HTTPHeader("X-Max-TTL", String.valueOf(4)));
        return openHeaders;
    }

    public HandshakeStatus createHandshakeResponse(HandshakeStatus hostResponse, boolean isOutgoing) {
        boolean isUltrapeer;
        HTTPHeaderGroup headers = hostResponse.getResponseHeaders();
        if (isOutgoing && this.isCrawlerConnection(headers)) {
            return this.createCrawlerHandshakeStatus();
        }
        HTTPHeader header = headers.getHeader("X-Ultrapeer");
        boolean bl = isUltrapeer = header != null && Boolean.valueOf(header.getValue()) != false;
        if (isUltrapeer) {
            this.connectedHost.setConnectionType((byte)1);
        } else {
            this.connectedHost.setConnectionType((byte)0);
            if (!this.areNoneUPConnectionsAllowed()) {
                if (isOutgoing) {
                    return new HandshakeStatus(503, "I accept only Ultrapeers");
                }
                return new HandshakeStatus(503, "I accept only Ultrapeers", this.createRejectIncomingHeaders());
            }
            if (!this.hostContainer.hasPeerSlotsAvailable()) {
                if (isOutgoing) {
                    return new HandshakeStatus(503, "I am busy.", this.createRejectOutgoingHeaders());
                }
                return new HandshakeStatus(503, "I am busy.", this.createRejectIncomingHeaders());
            }
        }
        if (isOutgoing) {
            HTTPHeaderGroup myHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
            if (hostResponse.isDeflateAccepted()) {
                myHeaders.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
            }
            return new HandshakeStatus(200, "OK", myHeaders);
        }
        if (this.hostContainer.isShieldedLeafNode()) {
            return new HandshakeStatus(503, "I am a shielded leaf node", this.createRejectIncomingHeaders());
        }
        HTTPHeaderGroup myHeaders = this.createDefaultHandshakeHeaders();
        if (hostResponse.isDeflateAccepted()) {
            myHeaders.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
        }
        return new HandshakeStatus(200, "OK", myHeaders);
    }

    private boolean areNoneUPConnectionsAllowed() {
        return !ServiceManager.sCfg.allowToBecomeLeaf || !ServiceManager.sCfg.forceUPConnections;
    }
}

