/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import phex.common.address.DestAddress;
import phex.connection.ConnectionEngine;
import phex.connection.ConnectionRejectedException;
import phex.connection.NetworkManager;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.net.OnlineObserver;
import phex.utils.NLogger;

public class OutgoingConnectionDispatcher
implements Runnable {
    public DestAddress hostAddress;

    public void setHostAddressToConnect(DestAddress hostAddress) {
        this.hostAddress = hostAddress;
    }

    public void run() {
        try {
            if (this.hostAddress == null) {
                this.connectToNextCaughtHost();
            } else {
                this.connectToHostAddress();
            }
        }
        catch (Throwable th) {
            NLogger.error("OUT_CONNECTION", (Object)th, th);
        }
    }

    private void connectToHostAddress() {
        NetworkHostsContainer networkContainer = HostManager.getInstance().getNetworkHostsContainer();
        Host host = new Host(this.hostAddress);
        host.setType(Host.TYPE_OUTGOING);
        networkContainer.addNetworkHost(host);
        OnlineObserver onlineObserver = NetworkManager.getInstance().getOnlineObserver();
        try {
            ConnectionEngine engine = new ConnectionEngine(host);
            engine.initializeOutgoingConnection();
            engine.processIncomingData();
        }
        catch (IOException exp) {
            onlineObserver.markFailedConnection();
            host.setStatus(1, exp.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", (Object)exp);
        }
        catch (Exception exp) {
            host.setStatus(1, exp.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.warn("OUT_CONNECTION", (Object)exp, (Throwable)exp);
        }
    }

    private void connectToNextCaughtHost() {
        DestAddress caughtHost;
        NetworkHostsContainer networkContainer = HostManager.getInstance().getNetworkHostsContainer();
        CaughtHostsContainer caughtHostContainer = HostManager.getInstance().getCaughtHostsContainer();
        do {
            if ((caughtHost = caughtHostContainer.getNextCaughtHost()) != null) continue;
            return;
        } while (networkContainer.isConnectedToHost(caughtHost));
        Host host = new Host(caughtHost);
        host.setType(Host.TYPE_OUTGOING);
        networkContainer.addNetworkHost(host);
        OnlineObserver onlineObserver = NetworkManager.getInstance().getOnlineObserver();
        ConnectionEngine engine = new ConnectionEngine(host);
        try {
            engine.initializeOutgoingConnection();
        }
        catch (ConnectionRejectedException exp) {
            caughtHostContainer.reportConnectionStatus(caughtHost, true);
            host.setStatus(1, exp.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", (Object)exp);
            return;
        }
        catch (IOException exp) {
            onlineObserver.markFailedConnection();
            caughtHostContainer.reportConnectionStatus(caughtHost, false);
            host.setStatus(1, exp.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", (Object)exp);
            return;
        }
        catch (Exception exp) {
            caughtHostContainer.reportConnectionStatus(caughtHost, false);
            host.setStatus(1, exp.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.warn("OUT_CONNECTION", (Object)exp, (Throwable)exp);
            return;
        }
        caughtHostContainer.reportConnectionStatus(caughtHost, true);
        try {
            engine.processIncomingData();
        }
        catch (IOException exp) {
            host.setStatus(1, exp.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", (Object)exp);
        }
        catch (Exception exp) {
            host.setStatus(1, exp.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.warn("OUT_CONNECTION", (Object)exp, (Throwable)exp);
        }
    }
}

