/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.util.ArrayList;
import phex.common.ThreadTracking;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.MsgManager;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class ConnectionObserver
implements Runnable {
    private long SLEEP_TIME = 30000L;
    private long PING_WAIT_TIME = 20000L;
    private MsgManager messageMgr;
    private ArrayList snapshootList;
    private ArrayList quiteList;
    private NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
    static /* synthetic */ Class class$phex$connection$ConnectionObserver;

    public ConnectionObserver() {
        this.messageMgr = MsgManager.getInstance();
    }

    public void start() {
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, this, "ConnectionObserver-" + Integer.toHexString(this.hashCode()));
        thread.setPriority(5);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.snapshootList = new ArrayList<E>();
        this.quiteList = new ArrayList<E>();
        block4: while (true) {
            this.snapshootList.clear();
            this.quiteList.clear();
            hosts = this.networkHostsContainer.getUltrapeerConnections();
            this.createSnapshoots(hosts);
            hosts = this.networkHostsContainer.getLeafConnections();
            this.createSnapshoots(hosts);
            hosts = this.networkHostsContainer.getPeerConnections();
            this.createSnapshoots(hosts);
            try {
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            hosts = this.networkHostsContainer.getUltrapeerConnections();
            this.findQuiteHosts(hosts);
            hosts = this.networkHostsContainer.getLeafConnections();
            this.findQuiteHosts(hosts);
            hosts = this.networkHostsContainer.getPeerConnections();
            this.findQuiteHosts(hosts);
            if (this.quiteList.size() <= 0) continue;
            size = this.quiteList.size();
            for (i = 0; i < size; ++i) {
                host = (Host)this.quiteList.get(i);
                NLogger.debug(ConnectionObserver.class$phex$connection$ConnectionObserver == null ? ConnectionObserver.class$("phex.connection.ConnectionObserver") : ConnectionObserver.class$phex$connection$ConnectionObserver, (Object)(host + " - Sending keep alive ping. "));
                this.messageMgr.pingHost(host);
            }
            try {
                Thread.sleep(this.PING_WAIT_TIME);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            i = 0;
            while (true) {
                if (i < size) ** break;
                continue block4;
                host = (Host)this.quiteList.get(i);
                shoot = this.findSnapshoot(host);
                if (shoot.hasBeenQuite(host)) {
                    host.setStatus(1, Localizer.getString("HostNotResponding"));
                    NLogger.debug(ConnectionObserver.class$phex$connection$ConnectionObserver == null ? ConnectionObserver.class$("phex.connection.ConnectionObserver") : ConnectionObserver.class$phex$connection$ConnectionObserver, (Object)(host + " - Host not responding, disconnecting.."));
                    this.networkHostsContainer.disconnectHost(host);
                }
                ++i;
            }
            break;
        }
    }

    private void findQuiteHosts(Host[] hosts) {
        for (int i = 0; i < hosts.length; ++i) {
            ConnectionSnapshoot shoot = this.findSnapshoot(hosts[i]);
            if (shoot == null || !shoot.hasBeenQuite(hosts[i])) continue;
            this.quiteList.add(hosts[i]);
        }
    }

    private void createSnapshoots(Host[] hosts) {
        for (int i = 0; i < hosts.length; ++i) {
            this.snapshootList.add(new ConnectionSnapshoot(hosts[i]));
        }
    }

    private ConnectionSnapshoot findSnapshoot(Host host) {
        int size = this.snapshootList.size();
        for (int i = 0; i < size; ++i) {
            ConnectionSnapshoot shoot = (ConnectionSnapshoot)this.snapshootList.get(i);
            if (shoot.host != host) continue;
            return shoot;
        }
        return null;
    }

    private class ConnectionSnapshoot {
        Host host;
        int receivedCount;
        int sentCount;
        int sendDropCount;

        ConnectionSnapshoot(Host host) {
            this.host = host;
            this.receivedCount = host.getReceivedCount();
            this.sentCount = host.getSentCount();
            this.sendDropCount = host.getSendDropCount();
        }

        public boolean hasBeenQuite(Host host) {
            int receivedDiff = host.getReceivedCount() - this.receivedCount;
            int sentDiff = host.getSentCount() - this.sentCount;
            int sendDropDiff = host.getSendDropCount() - this.sendDropCount;
            if (receivedDiff == 0) {
                return true;
            }
            return sentDiff == sendDropDiff && sentDiff != 0;
        }
    }
}

