/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import phex.common.HorizonTracker;
import phex.common.PongCache;
import phex.common.QueryRoutingTable;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.ConnectionClosedException;
import phex.connection.ConnectionConstants;
import phex.connection.ConnectionRejectedException;
import phex.connection.NetworkManager;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostManager;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPProcessor;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.MsgManager;
import phex.msg.PingMsg;
import phex.msg.PongMsg;
import phex.msg.PushRequestMsg;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.CapabilitiesVMsg;
import phex.msg.vendor.HopsFlowVMsg;
import phex.msg.vendor.MessagesSupportedVMsg;
import phex.msg.vendor.PushProxyAcknowledgementVMsg;
import phex.msg.vendor.PushProxyRequestVMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.msg.vendor.VendorMsg;
import phex.net.OnlineObserver;
import phex.net.connection.Connection;
import phex.net.connection.ConnectionFactory;
import phex.net.presentation.PresentationManager;
import phex.query.QueryHistoryMonitor;
import phex.query.QueryManager;
import phex.security.PhexSecurityManager;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.MessageCountStatistic;
import phex.upload.PushWorker;
import phex.utils.HexConverter;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.QueryGUIDRoutingPair;
import phex.utils.VersionUtils;

public class ConnectionEngine
implements ConnectionConstants {
    private final HostManager hostMgr;
    private final ShareManager shareMgr;
    private final QueryHistoryMonitor queryHistory;
    private final SharedFilesService sharedFilesService;
    private final MsgManager messageMgr;
    private final NetworkManager networkMgr;
    private final PhexSecurityManager securityManager;
    private byte[] headerBuffer;
    private final Host connectedHost;
    private Connection connection;
    private HTTPHeaderGroup headersRead;
    private HTTPHeaderGroup headersSend;

    public ConnectionEngine(Host connectedHost) {
        this.connectedHost = connectedHost;
        this.connection = connectedHost.getConnection();
        this.shareMgr = ShareManager.getInstance();
        this.sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        this.queryHistory = QueryManager.getInstance().getQueryHistoryMonitor();
        this.messageMgr = MsgManager.getInstance();
        this.hostMgr = HostManager.getInstance();
        this.networkMgr = NetworkManager.getInstance();
        this.securityManager = PhexSecurityManager.getInstance();
    }

    public void processIncomingData() throws IOException {
        this.headerBuffer = new byte[23];
        try {
            while (true) {
                Message message;
                MsgHeader header;
                block21: {
                    header = this.readHeader();
                    byte[] body = MessageProcessor.readMessageBody(this.connection, header.getDataLength());
                    this.connectedHost.incReceivedCount();
                    byte ttl = header.getTTL();
                    byte hops = header.getHopsTaken();
                    if (ttl < 0 || hops < 0) {
                        this.dropMessage(header, body, "TTL or hops below 0");
                        continue;
                    }
                    if (hops > ServiceManager.sCfg.maxNetworkTTL) {
                        this.dropMessage(header, body, "Hops larger then maxNetworkTTL");
                        continue;
                    }
                    if (ttl >= ServiceManager.sCfg.maxNetworkTTL) {
                        header.setTTL((byte)(ServiceManager.sCfg.maxNetworkTTL - hops));
                    }
                    try {
                        message = MessageProcessor.createMessageFromBody(header, body);
                        if (message == null) {
                            this.dropMessage(header, body, "Unknown message type");
                        }
                        break block21;
                    }
                    catch (InvalidMessageException exp) {
                        this.dropMessage(header, body, "Invalid message: " + exp.getMessage());
                        NLogger.warn("IncomingMessages", (Object)exp, (Throwable)exp);
                    }
                    continue;
                }
                header.countHop();
                switch (header.getPayload()) {
                    case 0: {
                        this.handlePing((PingMsg)message);
                        break;
                    }
                    case 1: {
                        this.handlePong((PongMsg)message);
                        break;
                    }
                    case 64: {
                        this.handlePushRequest((PushRequestMsg)message);
                        break;
                    }
                    case -128: {
                        this.handleQuery((QueryMsg)message);
                        break;
                    }
                    case -127: {
                        this.handleQueryResponse((QueryResponseMsg)message);
                        break;
                    }
                    case 48: {
                        this.handleRouteTableUpdate((RouteTableUpdateMsg)message);
                        break;
                    }
                    case 49: 
                    case 50: {
                        this.handleVendorMessage((VendorMsg)message);
                    }
                }
            }
        }
        catch (IOException exp) {
            NLogger.debug(ConnectionEngine.class, (Object)exp, (Throwable)exp);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(1, exp.getMessage());
                this.hostMgr.disconnectHost(this.connectedHost);
            }
            throw exp;
        }
        catch (Exception exp) {
            NLogger.warn(ConnectionEngine.class, (Object)exp, (Throwable)exp);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(1, exp.getMessage());
                this.hostMgr.disconnectHost(this.connectedHost);
            }
            throw new IOException("Exception occured: " + exp.getMessage());
        }
    }

    private void handlePing(PingMsg pingMsg) {
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)("Received Ping: " + pingMsg.getDebugString() + " - " + pingMsg.getHeader().getDebugString()));
        }
        MessageCountStatistic.pingMsgInCounter.increment(1);
        MsgHeader header = pingMsg.getHeader();
        if (!this.messageMgr.checkAndAddToPingRoutingTable(header.getMsgID(), this.connectedHost)) {
            this.dropMessage(pingMsg, "Dropping already seen ping");
            return;
        }
        this.respondToPing(pingMsg);
    }

    private void respondToPing(PingMsg pingMsg) {
        byte hops;
        MsgHeader header = pingMsg.getHeader();
        byte ttl = header.getTTL();
        if (ttl + (hops = header.getHopsTaken()) > 2 && !this.hostMgr.areIncommingSlotsAdvertised()) {
            return;
        }
        if (hops == 1 && ttl == 1) {
            Host[] leafs = this.hostMgr.getNetworkHostsContainer().getLeafConnections();
            for (int i = 0; i < leafs.length; ++i) {
                DestAddress ha = leafs[i].getHostAddress();
                PongMsg pong = PongMsg.createOtherLeafsOutgoingPong(header.getMsgID(), (byte)1, (byte)1, ha);
                this.connectedHost.queueMessageToSend(pong);
            }
        }
        byte by = hops;
        hops = (byte)(hops + 1);
        byte newTTL = by;
        if (hops + ttl <= 2) {
            newTTL = 1;
        }
        PongMsg pong = PongMsg.createMyOutgoingPong(header.getMsgID(), newTTL);
        this.connectedHost.queueMessageToSend(pong);
        List pongs = PongCache.getInstance().getPongs();
        GUID guid = header.getMsgID();
        DestAddress orginAddress = this.connectedHost.getHostAddress();
        IpAddress ip = orginAddress.getIpAddress();
        if (ip == null) {
            return;
        }
        Iterator iterator = pongs.iterator();
        while (iterator.hasNext()) {
            pong = (PongMsg)iterator.next();
            if (Arrays.equals(pong.getIP(), ip.getHostIP())) continue;
            this.connectedHost.queueMessageToSend(PongMsg.createFromCachePong(guid, newTTL, pong));
        }
    }

    private void handlePong(PongMsg pongMsg) {
        Host returnHost;
        DestAddress connectedAddress;
        byte[] connectedIP;
        boolean isNew;
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)("Received Pong: " + pongMsg.getDebugString() + " - " + pongMsg.getHeader().getDebugString()));
        }
        MessageCountStatistic.pongMsgInCounter.increment(1);
        HorizonTracker.getInstance().trackPong(pongMsg);
        MsgHeader header = pongMsg.getHeader();
        byte[] pongIP = pongMsg.getIP();
        byte access = this.securityManager.controlHostIPAccess(pongIP);
        if (access == 3) {
            this.dropMessage(pongMsg, "IP access strongly denied.");
            return;
        }
        if (access == 1 && (isNew = this.hostMgr.getCaughtHostsContainer().addCaughtHost(pongMsg))) {
            PongCache.getInstance().addPong(pongMsg);
        }
        int pongPort = pongMsg.getPort();
        byte hopsTaken = pongMsg.getHeader().getHopsTaken();
        if (hopsTaken == 1 && Arrays.equals(connectedIP = (connectedAddress = this.connectedHost.getHostAddress()).getIpAddress().getHostIP(), pongIP)) {
            this.connectedHost.setFileCount(pongMsg.getFileCount());
            this.connectedHost.setTotalFileSize(pongMsg.getFileSizeInKB());
            int connectedPort = connectedAddress.getPort();
            if (connectedPort != pongPort) {
                connectedAddress.setPort(pongPort);
            }
        }
        if ((returnHost = this.messageMgr.getPingRouting(header.getMsgID())) == null || returnHost == Host.LOCAL_HOST) {
            return;
        }
        if (pongMsg.getHeader().getTTL() > 0) {
            returnHost.queueMessageToSend(pongMsg);
        }
    }

    private void handleQuery(QueryMsg msg) {
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)("Received Query: " + msg.toString() + " - " + msg.getHeader().getDebugString()));
        }
        MessageCountStatistic.queryMsgInCounter.increment(1);
        MsgHeader header = msg.getHeader();
        if (!this.messageMgr.checkAndAddToQueryRoutingTable(header.getMsgID(), this.connectedHost)) {
            this.dropMessage(msg, "Dropping already seen query");
            return;
        }
        if (this.connectedHost.isUltrapeerLeafConnection() && header.getHopsTaken() > 2) {
            this.dropMessage(msg, "Dropping Query from Leaf with hops > 2.");
        }
        this.queryHistory.addSearchQuery(msg);
        this.messageMgr.forwardQuery(msg, this.connectedHost);
        ShareFile[] resultFiles = this.shareMgr.handleQuery(msg);
        if (resultFiles.length == 0) {
            return;
        }
        this.replyToQuery(header, resultFiles);
    }

    private void replyToQuery(MsgHeader header, ShareFile[] resultFiles) {
        MsgHeader newHeader = new MsgHeader(header.getMsgID(), -127, (byte)(header.getHopsTaken() + 1), 0, 0);
        int resultCount = resultFiles.length;
        if (resultCount > 255) {
            resultCount = 255;
        }
        ShareFile sfile = null;
        QueryResponseRecord[] records = new QueryResponseRecord[resultCount];
        for (int i = 0; i < resultCount; ++i) {
            QueryResponseRecord record;
            sfile = resultFiles[i];
            records[i] = record = new QueryResponseRecord(sfile.getFileIndex(), sfile.getURN(), (int)sfile.getFileSize(), sfile.getFileName(), sfile.getNetworkCreateTime(), sfile.getAltLocContainer().getAltLocForQueryResponseRecord());
        }
        DestAddress hostAddress = this.networkMgr.getLocalAddress();
        QueryResponseMsg response = new QueryResponseMsg(newHeader, ServiceManager.sCfg.mProgramClientID, hostAddress, Math.round((long)ServiceManager.sCfg.mUploadMaxBandwidth / 1024L * 8L), records);
        this.connectedHost.queueMessageToSend(response);
    }

    private void handleQueryResponse(QueryResponseMsg queryResponseMsg) {
        MessageCountStatistic.queryHitMsgInCounter.increment(1);
        DestAddress queryAddress = queryResponseMsg.getDestAddress();
        byte access = this.securityManager.controlHostAddressAccess(queryAddress);
        if (access == 3) {
            this.dropMessage(queryResponseMsg, "IP access strongly denied.");
            return;
        }
        if (access == 1) {
            this.messageMgr.processQueryResponse(this.connectedHost, queryResponseMsg);
        }
        this.messageMgr.addToPushRoutingTable(queryResponseMsg.getRemoteClientID(), this.connectedHost);
        MsgHeader responseHeader = queryResponseMsg.getHeader();
        QueryGUIDRoutingPair routingPair = this.messageMgr.getQueryRouting(responseHeader.getMsgID(), queryResponseMsg.getUniqueResultCount());
        if (routingPair == null) {
            return;
        }
        Host returnHost = routingPair.getHost();
        if (responseHeader.getTTL() > 0 && returnHost != Host.LOCAL_HOST && routingPair.getRoutedResultCount() < 200) {
            returnHost.queueMessageToSend(queryResponseMsg);
        }
    }

    private void handleRouteTableUpdate(RouteTableUpdateMsg message) {
        MessageCountStatistic.totalInMsgCounter.increment(1);
        if (!this.connectedHost.isQueryRoutingSupported() && !this.connectedHost.isUPQueryRoutingSupported()) {
            this.dropMessage(message, "QRP not supported from host.");
            return;
        }
        QueryRoutingTable qrTable = this.connectedHost.getLastReceivedRoutingTable();
        if (qrTable == null) {
            qrTable = new QueryRoutingTable();
            this.connectedHost.setLastReceivedRoutingTable(qrTable);
        }
        try {
            qrTable.updateRouteTable(message);
            if (this.connectedHost.isUltrapeerLeafConnection()) {
                this.messageMgr.updateLocalQueryRoutingTable();
            }
        }
        catch (InvalidMessageException exp) {
            this.dropMessage(message, "Invalid QRT update message.");
        }
    }

    private void handlePushRequest(PushRequestMsg msg) {
        MessageCountStatistic.pushMsgInCounter.increment(1);
        byte access = this.securityManager.controlHostAddressAccess(msg.getRequestAddress());
        if (access == 3) {
            this.dropMessage(msg, "IP access strongly denied.");
            return;
        }
        if (ServiceManager.sCfg.mProgramClientID.equals(msg.getClientGUID())) {
            if (access == 1) {
                new PushWorker(msg);
            }
            return;
        }
        Host returnHost = this.messageMgr.getPushRouting(msg.getClientGUID());
        if (returnHost == null) {
            return;
        }
        if (msg.getHeader().getTTL() > 0) {
            returnHost.queueMessageToSend(msg);
        }
    }

    private void handleVendorMessage(VendorMsg vendorMsg) {
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)("Received VendorMsg: " + vendorMsg.toString() + " - " + vendorMsg.getHeader().getDebugString()));
        }
        if (vendorMsg instanceof MessagesSupportedVMsg) {
            this.handleMessagesSupportedVMsg((MessagesSupportedVMsg)vendorMsg);
        } else if (vendorMsg instanceof TCPConnectBackVMsg) {
            this.handleTCPConnectBackVMsg((TCPConnectBackVMsg)vendorMsg);
        } else if (vendorMsg instanceof PushProxyRequestVMsg) {
            this.handlePushProxyRequestVMsg((PushProxyRequestVMsg)vendorMsg);
        } else if (vendorMsg instanceof PushProxyAcknowledgementVMsg) {
            this.handlePushProxyAcknowledgementVMsg((PushProxyAcknowledgementVMsg)vendorMsg);
        } else if (vendorMsg instanceof HopsFlowVMsg) {
            this.handleHopsFlowVMsg((HopsFlowVMsg)vendorMsg);
        } else if (vendorMsg instanceof CapabilitiesVMsg) {
            this.handleCapabilitiesVMsg((CapabilitiesVMsg)vendorMsg);
        }
    }

    private void handleMessagesSupportedVMsg(MessagesSupportedVMsg msg) {
        this.connectedHost.setSupportedVMsgs(msg);
        boolean isFirewalled = this.networkMgr.hasConnectedIncoming();
        if ((this.connectedHost.isLeafUltrapeerConnection() || isFirewalled && this.connectedHost.isUltrapeer()) && this.connectedHost.isPushProxySupported()) {
            PushProxyRequestVMsg pprmsg = new PushProxyRequestVMsg();
            if (this.connectedHost.getVendor() != null && this.connectedHost.getVendor().indexOf("LimeWire") != -1) {
                pprmsg.setVersion(1);
            }
            this.connectedHost.queueMessageToSend(pprmsg);
        }
    }

    private void handleCapabilitiesVMsg(CapabilitiesVMsg msg) {
        this.connectedHost.setCapabilitiesVMsgs(msg);
    }

    private void handleTCPConnectBackVMsg(TCPConnectBackVMsg msg) {
        final int connectBackPort = msg.getPort();
        final DestAddress address = this.connectedHost.getHostAddress();
        Runnable connectBackRunner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                try {
                    DefaultDestAddress connectBackAddress = new DefaultDestAddress(address.getHostName(), connectBackPort);
                    connection = ConnectionFactory.createConnection(connectBackAddress, 2000);
                    connection.write("\n\n".getBytes());
                    connection.flush();
                }
                catch (IOException exp) {
                }
                catch (Exception exp) {
                    NLogger.error("OUTGOING_MESSAGES", (Object)exp, (Throwable)exp);
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        };
        ThreadPool.getInstance().addJob(connectBackRunner, "TCPConnectBackJob");
    }

    private void handlePushProxyRequestVMsg(PushProxyRequestVMsg pprvmsg) {
        if (!this.connectedHost.isUltrapeerLeafConnection()) {
            return;
        }
        DestAddress localAddress = this.networkMgr.getLocalAddress();
        if (localAddress.getIpAddress() == null) {
            NLogger.warn("IncomingMessages", (Object)"Local address has no IP to use for PPAck.");
            return;
        }
        GUID requestGUID = pprvmsg.getHeader().getMsgID();
        PushProxyAcknowledgementVMsg ppavmsg = new PushProxyAcknowledgementVMsg(localAddress, requestGUID);
        this.connectedHost.queueMessageToSend(ppavmsg);
        this.messageMgr.addToPushRoutingTable(requestGUID, this.connectedHost);
    }

    private void handlePushProxyAcknowledgementVMsg(PushProxyAcknowledgementVMsg ppavmsg) {
        if (ServiceManager.sCfg.mProgramClientID.equals(ppavmsg.getHeader().getMsgID())) {
            this.connectedHost.setPushProxyAddress(ppavmsg.getHostAddress());
        }
    }

    private void handleHopsFlowVMsg(HopsFlowVMsg hopsFlowVMsg) {
        byte hopsFlowValue = hopsFlowVMsg.getHopsValue();
        this.connectedHost.setHopsFlowLimit(hopsFlowValue);
    }

    private void dropMessage(MsgHeader header, byte[] body, String reason) {
        NLogger.info("IncomingMessages.Dropped", (Object)("Dropping message: " + reason + " from: " + this.connectedHost));
        if (NLogger.isDebugEnabled("IncomingMessages.Dropped")) {
            NLogger.debug("IncomingMessages.Dropped", (Object)("Header: " + header.getDebugString() + " Body: " + " (" + HexConverter.toHexString(body, 0, header.getDataLength()) + ")."));
        }
        this.connectedHost.incDropCount();
        MessageCountStatistic.dropedMsgInCounter.increment(1);
    }

    private void dropMessage(Message msg, String reason) {
        NLogger.info("IncomingMessages.Dropped", (Object)("Dropping message: " + reason + " from: " + this.connectedHost));
        if (NLogger.isDebugEnabled("IncomingMessages.Dropped")) {
            NLogger.debug("IncomingMessages.Dropped", (Object)("Header: [" + msg.getHeader().getDebugString() + "] - Message: [" + msg.toDebugString() + "]."));
        }
        this.connectedHost.incDropCount();
        MessageCountStatistic.dropedMsgInCounter.increment(1);
    }

    private MsgHeader readHeader() throws IOException {
        MsgHeader header = MessageProcessor.parseMessageHeader(this.connection, this.headerBuffer);
        if (header == null) {
            throw new ConnectionClosedException("Connection closed by remote host");
        }
        int length = header.getDataLength();
        if (length < 0) {
            throw new IOException("Negative body size. Disconnecting the remote host.");
        }
        if (length > ServiceManager.sCfg.maxMessageLength) {
            if (NLogger.isWarnEnabled(ConnectionEngine.class)) {
                byte[] body = MessageProcessor.readMessageBody(this.connection, 262144);
                String hexBody = HexConverter.toHexString(body);
                NLogger.warn(ConnectionEngine.class, (Object)(this.connectedHost + " - Body too big. Header: " + header + "\nBody(256KB): " + hexBody));
            }
            throw new IOException("Packet too big. Disconnecting the remote host.");
        }
        header.setArrivalTime(System.currentTimeMillis());
        header.setFromHost(this.connectedHost);
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeOutgoingConnection() throws IOException {
        this.connectedHost.setStatus(2);
        this.connection = ConnectionFactory.createConnection(this.connectedHost.getHostAddress());
        OnlineObserver onlineObserver = NetworkManager.getInstance().getOnlineObserver();
        onlineObserver.markSuccessfulConnection();
        this.connectedHost.setConnection(this.connection);
        try {
            this.initializeOutgoingWith06();
            this.configureConnectionType(this.headersSend, this.headersRead);
            this.postHandshakeConfiguration(this.headersSend, this.headersRead);
        }
        finally {
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
        }
        this.connectedHost.setStatus(4);
        this.hostMgr.addConnectedHost(this.connectedHost);
        this.messageMgr.pingHost(this.connectedHost, (byte)ServiceManager.sCfg.ttl);
        if (this.connectedHost.isVendorMessageSupported()) {
            MessagesSupportedVMsg vMsg = MessagesSupportedVMsg.getMyMsgSupported();
            if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
                NLogger.debug("OUTGOING_MESSAGES", (Object)("Queueing MessagesSupportedVMsg: " + vMsg.toString() + " - " + vMsg.getHeader().getDebugString() + " - Host: " + this.connectedHost.toString()));
            }
            this.connectedHost.queueMessageToSend(vMsg);
            CapabilitiesVMsg capVMsg = CapabilitiesVMsg.getMyCapabilitiesVMsg();
            if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
                NLogger.debug("OUTGOING_MESSAGES", (Object)("Queueing CapabilitiesVMsg: " + capVMsg.toString() + " - " + capVMsg.getHeader().getDebugString() + " - Host: " + this.connectedHost.toString()));
            }
            this.connectedHost.queueMessageToSend(capVMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeIncomingConnection(String requestLine) throws IOException {
        int idx = requestLine.lastIndexOf(47) + 1;
        String version = requestLine.substring(idx, requestLine.length());
        try {
            if (version.equals("0.4")) {
                this.initializeIncomingWith04();
            } else if (this.is06orHigher(version)) {
                this.initializeIncomingWith06();
            }
            this.configureConnectionType(this.headersSend, this.headersRead);
            this.postHandshakeConfiguration(this.headersSend, this.headersRead);
        }
        finally {
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
        }
        this.connectedHost.setStatus(4);
        this.hostMgr.addIncomingHost(this.connectedHost);
        this.messageMgr.pingHost(this.connectedHost, (byte)ServiceManager.sCfg.ttl);
        if (this.connectedHost.isVendorMessageSupported()) {
            MessagesSupportedVMsg vMsg = MessagesSupportedVMsg.getMyMsgSupported();
            if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
                NLogger.debug("OUTGOING_MESSAGES", (Object)("Queueing MessagesSupportedVMsg: " + vMsg.toString() + " - " + vMsg.getHeader().getDebugString() + " - Host: " + this.connectedHost.toString()));
            }
            this.connectedHost.queueMessageToSend(vMsg);
            CapabilitiesVMsg capVMsg = CapabilitiesVMsg.getMyCapabilitiesVMsg();
            if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
                NLogger.debug("OUTGOING_MESSAGES", (Object)("Queueing CapabilitiesVMsg: " + capVMsg.toString() + " - " + capVMsg.getHeader().getDebugString() + " - Host: " + this.connectedHost.toString()));
            }
            this.connectedHost.queueMessageToSend(capVMsg);
        }
    }

    private void initializeIncomingWith04() throws IOException {
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HandshakeStatus response = handshakeHandler.createHandshakeResponse(new HandshakeStatus(200, "OK"), false);
        if (response.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + response.getStatusCode() + " " + response.getStatusMessage());
        }
        this.sendStringToHost("GNUTELLA OK\n\n");
        this.headersRead = HTTPHeaderGroup.EMPTY_HEADERGROUP;
        this.headersSend = HTTPHeaderGroup.EMPTY_HEADERGROUP;
    }

    private void initializeIncomingWith06() throws IOException {
        this.headersRead = HTTPProcessor.parseHTTPHeaders(this.connection);
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Connect headers: " + this.headersRead.buildHTTPHeaderString()));
        }
        this.configureRemoteHost(this.headersRead);
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HandshakeStatus myResponse = handshakeHandler.createHandshakeResponse(new HandshakeStatus(this.headersRead), false);
        this.headersSend = myResponse.getResponseHeaders();
        this.sendStringToHost("GNUTELLA/0.6 " + myResponse.getStatusCode() + " " + myResponse.getStatusMessage() + "\r\n");
        String httpHeaderString = myResponse.getResponseHeaders().buildHTTPHeaderString();
        this.sendStringToHost(httpHeaderString);
        this.sendStringToHost("\r\n");
        if (myResponse.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + myResponse.getStatusCode() + " " + myResponse.getStatusMessage());
        }
        HandshakeStatus inResponse = HandshakeStatus.parseHandshakeResponse(this.connection);
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Code: '" + inResponse.getStatusCode() + "'."));
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Message: '" + inResponse.getStatusMessage() + "'."));
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Headers: " + inResponse.getResponseHeaders().buildHTTPHeaderString()));
        }
        if (inResponse.getStatusCode() != 200) {
            throw new IOException("Host rejected connection: " + inResponse.getStatusCode() + " " + inResponse.getStatusMessage());
        }
        this.headersRead.replaceHeaders(inResponse.getResponseHeaders());
    }

    private void initializeOutgoingWith06() throws IOException {
        this.connectedHost.setStatus(2, Localizer.getString("Negotiate0_6Handshake"));
        String greeting = this.networkMgr.getGnutellaNetwork().getNetworkGreeting();
        String requestLine = greeting + '/' + "0.6" + "\r\n";
        StringBuffer requestBuffer = new StringBuffer(100);
        requestBuffer.append(requestLine);
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HTTPHeaderGroup handshakeHeaders = handshakeHandler.createOutgoingHandshakeHeaders();
        requestBuffer.append(handshakeHeaders.buildHTTPHeaderString());
        requestBuffer.append("\r\n");
        this.headersSend = handshakeHeaders;
        String requestStr = requestBuffer.toString();
        this.sendStringToHost(requestStr);
        HandshakeStatus handshakeResponse = HandshakeStatus.parseHandshakeResponse(this.connection);
        this.headersRead = handshakeResponse.getResponseHeaders();
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Code: '" + handshakeResponse.getStatusCode() + "'."));
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Message: '" + handshakeResponse.getStatusMessage() + "'."));
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Headers: " + this.headersRead.buildHTTPHeaderString()));
        }
        if (handshakeResponse.getStatusCode() != 200) {
            if (handshakeResponse.getStatusCode() == 503) {
                throw new ConnectionRejectedException(handshakeResponse.getStatusCode() + " " + handshakeResponse.getStatusMessage());
            }
            throw new ConnectionRejectedException("Gnutella 0.6 connection rejected. Status: " + handshakeResponse.getStatusCode() + " - " + handshakeResponse.getStatusMessage());
        }
        this.configureRemoteHost(this.headersRead);
        HandshakeStatus myResponse = handshakeHandler.createHandshakeResponse(handshakeResponse, true);
        HTTPHeaderGroup myResponseHeaders = myResponse.getResponseHeaders();
        this.headersSend.replaceHeaders(myResponseHeaders);
        this.sendStringToHost("GNUTELLA/0.6 " + myResponse.getStatusCode() + " " + myResponse.getStatusMessage() + "\r\n");
        String httpHeaderString = myResponseHeaders.buildHTTPHeaderString();
        this.sendStringToHost(httpHeaderString);
        this.sendStringToHost("\r\n");
        if (myResponse.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + myResponse.getStatusCode() + " " + myResponse.getStatusMessage());
        }
    }

    private void configureConnectionType(HTTPHeaderGroup myHeadersSend, HTTPHeaderGroup theirHeadersRead) {
        HTTPHeader myUPHeader = myHeadersSend.getHeader("X-Ultrapeer");
        HTTPHeader theirUPHeader = theirHeadersRead.getHeader("X-Ultrapeer");
        if (myUPHeader == null || theirUPHeader == null) {
            this.connectedHost.setConnectionType((byte)0);
        } else if (myUPHeader.booleanValue()) {
            if (theirUPHeader.booleanValue()) {
                this.connectedHost.setConnectionType((byte)2);
            } else {
                this.connectedHost.setConnectionType((byte)3);
            }
        } else if (theirUPHeader.booleanValue()) {
            this.connectedHost.setConnectionType((byte)1);
        } else {
            this.connectedHost.setConnectionType((byte)0);
        }
    }

    private void handleXTryHeaders(HTTPHeaderGroup headers) {
        HTTPHeader[] hostAddresses = headers.getHeaders("X-Try");
        if (hostAddresses != null) {
            this.handleXTryHosts(hostAddresses, true);
        }
        if ((hostAddresses = headers.getHeaders("X-Try-Ultrapeers")) != null) {
            this.handleXTryHosts(hostAddresses, false);
        }
    }

    private void handleXTryHosts(HTTPHeader[] xtryHostAdresses, boolean isUltrapeerList) {
        short priority = isUltrapeerList ? (short)2 : 1;
        CaughtHostsContainer hostContainer = this.hostMgr.getCaughtHostsContainer();
        for (int i = 0; i < xtryHostAdresses.length; ++i) {
            StringTokenizer tokenizer = new StringTokenizer(xtryHostAdresses[i].getValue(), ",");
            block6: while (tokenizer.hasMoreTokens()) {
                String hostAddressStr = tokenizer.nextToken().trim();
                try {
                    DestAddress address = PresentationManager.getInstance().createHostAddress(hostAddressStr, 6346);
                    byte access = this.securityManager.controlHostAddressAccess(address);
                    switch (access) {
                        case 2: 
                        case 3: {
                            continue block6;
                        }
                    }
                    IpAddress ipAddress = address.getIpAddress();
                    if (!isUltrapeerList && ipAddress != null && ipAddress.isSiteLocalIP()) {
                        priority = 0;
                    }
                    hostContainer.addCaughtHost(address, priority);
                }
                catch (MalformedDestAddressException exp) {}
            }
        }
    }

    private void configureRemoteHost(HTTPHeaderGroup headers) {
        byte[] remoteIP;
        HTTPHeader header = headers.getHeader("User-Agent");
        if (header != null) {
            this.connectedHost.setVendor(header.getValue());
        }
        if (this.connectedHost.isIncomming()) {
            header = headers.getHeader("Listen-IP");
            if (header == null) {
                header = headers.getHeader("X-My-Address");
            }
            if (header != null) {
                DestAddress addi = this.connectedHost.getHostAddress();
                int port = AddressUtils.parsePort(header.getValue());
                if (port > 0) {
                    addi.setPort(port);
                }
            }
        }
        if ((header = headers.getHeader("Remote-IP")) != null && (remoteIP = AddressUtils.parseIP(header.getValue())) != null) {
            IpAddress ip = new IpAddress(remoteIP);
            DestAddress address = PresentationManager.getInstance().createHostAddress(ip, -1);
            this.networkMgr.updateLocalAddress(address);
        }
        if ((header = headers.getHeader("X-Query-Routing")) != null) {
            try {
                float version = Float.parseFloat(header.getValue());
                if (version >= 0.1f) {
                    this.connectedHost.setQueryRoutingSupported(true);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((header = headers.getHeader("X-Ultrapeer-Query-Routing")) != null) {
            try {
                float version = Float.parseFloat(header.getValue());
                if (version >= 0.1f) {
                    this.connectedHost.setUPQueryRoutingSupported(true);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((header = headers.getHeader("X-Dynamic-Querying")) != null) {
            try {
                float version = header.floatValue();
                if (version >= 0.1f) {
                    this.connectedHost.setDynamicQuerySupported(true);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        byte maxTTL = headers.getByteHeaderValue("X-Max-TTL", (byte)4);
        this.connectedHost.setMaxTTL(maxTTL);
        int degree = headers.getIntHeaderValue("X-Degree", 6);
        this.connectedHost.setUltrapeerDegree(degree);
    }

    private void postHandshakeConfiguration(HTTPHeaderGroup myHeadersSend, HTTPHeaderGroup theirHeadersRead) throws IOException {
        HTTPHeader header;
        if (myHeadersSend.isHeaderValueContaining("Accept-Encoding", "deflate") && theirHeadersRead.isHeaderValueContaining("Content-Encoding", "deflate")) {
            this.connectedHost.activateInputInflation();
        }
        if (theirHeadersRead.isHeaderValueContaining("Accept-Encoding", "deflate") && myHeadersSend.isHeaderValueContaining("Content-Encoding", "deflate")) {
            this.connectedHost.activateOutputDeflation();
        }
        if ((header = theirHeadersRead.getHeader("Vendor-Message")) != null && !header.getValue().equals("")) {
            this.connectedHost.setVendorMessageSupported(true);
        }
    }

    private boolean is06orHigher(String version) {
        int diff = VersionUtils.compare(version, "0.6");
        return diff >= 0;
    }

    private void sendStringToHost(String str) throws IOException {
        NLogger.debug("OUTGOING_MESSAGES", (Object)(this.connectedHost + " - Send: " + str));
        byte[] bytes = str.getBytes();
        this.connection.write(bytes, 0, bytes.length);
        this.connection.flush();
    }
}

