/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.utils.DirectByteBuffer;
import phex.utils.DirectByteBufferProvider;
import phex.utils.NLogger;

public class ManagedFileInputStream
extends InputStream {
    private DirectByteBuffer buffer;
    private ManagedFile managedFile;
    private long inputOffset;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ManagedFileInputStream(ManagedFile managedFile, long inputOffset) {
        this.managedFile = managedFile;
        this.inputOffset = inputOffset;
        this.buffer = DirectByteBufferProvider.requestBuffer(65536);
        this.buffer.flip();
    }

    public int read() throws IOException {
        ByteBuffer internalBuffer = this.buffer.getInternalBuffer();
        if (!internalBuffer.hasRemaining()) {
            this.fill();
        }
        if (!internalBuffer.hasRemaining()) {
            return -1;
        }
        byte b = internalBuffer.get();
        if (NLogger.isDebugEnabled(ManagedFileInputStream.class)) {
            NLogger.debug(ManagedFileInputStream.class, (Object)("Read: " + (char)b));
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int read;
        int toRead;
        if ((offset | length | offset + length | b.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        ByteBuffer internalBuffer = this.buffer.getInternalBuffer();
        if (!internalBuffer.hasRemaining()) {
            this.fill();
        }
        if (!internalBuffer.hasRemaining()) {
            return -1;
        }
        for (read = 0; read < length && internalBuffer.hasRemaining(); read += toRead) {
            toRead = Math.min(length - read, internalBuffer.remaining());
            internalBuffer.get(b, offset + read, toRead);
            if (internalBuffer.hasRemaining()) continue;
            this.fill();
        }
        if (NLogger.isDebugEnabled(ManagedFileInputStream.class)) {
            NLogger.debug(ManagedFileInputStream.class, (Object)("Read: " + new String(b, offset, read)));
        }
        return read;
    }

    public int available() throws IOException {
        ByteBuffer internalBuffer = this.buffer.getInternalBuffer();
        if (!internalBuffer.hasRemaining()) {
            this.fill();
        }
        return internalBuffer.remaining();
    }

    private void fill() throws IOException {
        ByteBuffer internalBuffer = this.buffer.getInternalBuffer();
        if (!$assertionsDisabled && internalBuffer.hasRemaining()) {
            throw new AssertionError();
        }
        internalBuffer.clear();
        try {
            this.managedFile.read(this.buffer, this.inputOffset);
        }
        catch (ManagedFileException exp) {
            IOException ioExp = new IOException("Cause: " + exp.getMessage());
            ioExp.initCause(exp);
            throw ioExp;
        }
        internalBuffer.flip();
        this.inputOffset += (long)internalBuffer.limit();
    }

    public void close() throws IOException {
        this.buffer.release();
    }

    static {
        $assertionsDisabled = !ManagedFileInputStream.class.desiredAssertionStatus();
    }
}

