/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.commons.collections.map.ReferenceMap;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.file.ReadOnlyManagedFile;

public class FileManager
implements Manager {
    private static FileManager instance;
    private ReferenceMap fileManagedFileMap = new ReferenceMap(2, 2);
    private LinkedHashMap openFileMap;

    public static FileManager getInstance() {
        if (instance == null) {
            instance = new FileManager();
        }
        return instance;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        if (this.openFileMap == null) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedFile getManagedFile(File file) {
        ReferenceMap referenceMap = this.fileManagedFileMap;
        synchronized (referenceMap) {
            ManagedFile managedFile = (ManagedFile)this.fileManagedFileMap.get(file);
            if (managedFile == null) {
                managedFile = new ManagedFile(file);
                this.fileManagedFileMap.put(file, managedFile);
            }
            return managedFile;
        }
    }

    public ManagedFile getReadWriteManagedFile(File file) throws ManagedFileException {
        ManagedFile managedFile = this.getManagedFile(file);
        managedFile.setAccessMode(1);
        return managedFile;
    }

    public ReadOnlyManagedFile getReadOnlyManagedFile(File file) throws ManagedFileException {
        ManagedFile managedFile = this.getManagedFile(file);
        managedFile.setAccessMode(0);
        return managedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOpenFileTracking() {
        if (ServiceManager.sCfg.openFilesLimit == 0) {
            this.openFileMap = null;
            return;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this.openFileMap == null) {
                this.openFileMap = new LinkedHashMap(ServiceManager.sCfg.openFilesLimit, 0.75f, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackFileOpen(ManagedFile managedFile) throws ManagedFileException {
        this.initOpenFileTracking();
        if (this.openFileMap == null) {
            return;
        }
        ManagedFile oldestEntry = null;
        LinkedHashMap linkedHashMap = this.openFileMap;
        synchronized (linkedHashMap) {
            if (this.openFileMap.size() >= ServiceManager.sCfg.openFilesLimit) {
                Iterator iterator = this.openFileMap.keySet().iterator();
                oldestEntry = (ManagedFile)iterator.next();
                iterator.remove();
            }
            this.openFileMap.put(managedFile, managedFile);
        }
        if (oldestEntry != null) {
            oldestEntry.closeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackFileInUse(ManagedFile managedFile) {
        this.initOpenFileTracking();
        if (this.openFileMap == null) {
            return;
        }
        LinkedHashMap linkedHashMap = this.openFileMap;
        synchronized (linkedHashMap) {
            if (this.openFileMap.containsKey(managedFile)) {
                this.openFileMap.get(managedFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackFileClose(ManagedFile managedFile) {
        this.initOpenFileTracking();
        if (this.openFileMap == null) {
            return;
        }
        LinkedHashMap linkedHashMap = this.openFileMap;
        synchronized (linkedHashMap) {
            this.openFileMap.remove(managedFile);
        }
    }
}

